/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.menus;

import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.CommandException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.menus.IWidget;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate2;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.services.IServiceLocator;

final class PulldownDelegateWidgetProxy
implements IWidget {
    private final ParameterizedCommand command;
    private IConfigurationElement configurationElement;
    private IWorkbenchWindowPulldownDelegate delegate = null;
    private final String delegateAttributeName;
    private final DisposeListener disposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent disposeEvent) {
            if (disposeEvent.widget == PulldownDelegateWidgetProxy.this.widget) {
                PulldownDelegateWidgetProxy.this.dispose();
                PulldownDelegateWidgetProxy.this.widget = null;
            }
        }
    };
    private final IServiceLocator locator;
    private final Listener selectionListener = new Listener(){

        public final void handleEvent(Event event) {
            IHandlerService iHandlerService;
            Widget widget = event.widget;
            if (widget == null) {
                return;
            }
            int n = widget.getStyle();
            if ((n & 4) != 0 && event.detail == 4 && widget instanceof ToolItem) {
                iHandlerService = (ToolItem)widget;
                ToolBar toolBar = iHandlerService.getParent();
                if (PulldownDelegateWidgetProxy.this.loadDelegate() && PulldownDelegateWidgetProxy.this.delegate instanceof IWorkbenchWindowPulldownDelegate2) {
                    IWorkbenchWindowPulldownDelegate2 iWorkbenchWindowPulldownDelegate2 = (IWorkbenchWindowPulldownDelegate2)PulldownDelegateWidgetProxy.this.delegate;
                    MenuLoader menuLoader = new MenuLoader((IWorkbenchWindowPulldownDelegate)iWorkbenchWindowPulldownDelegate2, (Control)toolBar);
                    SafeRunner.run((ISafeRunnable)menuLoader);
                    Menu menu = menuLoader.getMenu();
                    if (menu != null) {
                        Rectangle rectangle = iHandlerService.getBounds();
                        Point point = toolBar.toDisplay(new Point(rectangle.x, rectangle.y + rectangle.height));
                        menu.setLocation(point);
                        menu.setVisible(true);
                        return;
                    }
                }
            }
            iHandlerService = (IHandlerService)PulldownDelegateWidgetProxy.this.locator.getService(IHandlerService.class);
            try {
                iHandlerService.executeCommand(PulldownDelegateWidgetProxy.this.command, event);
            }
            catch (CommandException commandException) {}
        }
    };
    private Widget widget = null;

    public PulldownDelegateWidgetProxy(IConfigurationElement iConfigurationElement, String string, ParameterizedCommand parameterizedCommand, IServiceLocator iServiceLocator) {
        if (iConfigurationElement == null) {
            throw new NullPointerException("The configuration element backing a handler proxy cannot be null");
        }
        if (string == null) {
            throw new NullPointerException("The attribute containing the handler class must be known");
        }
        if (parameterizedCommand == null) {
            throw new NullPointerException("The command cannot be null");
        }
        this.configurationElement = iConfigurationElement;
        this.delegateAttributeName = string;
        this.command = parameterizedCommand;
        this.locator = iServiceLocator;
    }

    public final void dispose() {
        if (this.delegate != null) {
            this.delegate.dispose();
        }
    }

    public final void fill(Composite composite) {
    }

    public final void fill(CoolBar coolBar, int n) {
    }

    public final void fill(Menu menu, int n) {
        if (this.widget != null || menu == null) {
            return;
        }
        MenuItem menuItem = n >= 0 ? new MenuItem(menu, 64, n) : new MenuItem(menu, 64);
        menuItem.setData((Object)this);
        this.widget = menuItem;
        if (this.loadDelegate() && this.delegate instanceof IWorkbenchWindowPulldownDelegate2) {
            IWorkbenchWindowPulldownDelegate2 iWorkbenchWindowPulldownDelegate2 = (IWorkbenchWindowPulldownDelegate2)this.delegate;
            MenuLoader menuLoader = new MenuLoader(iWorkbenchWindowPulldownDelegate2, menu);
            SafeRunner.run((ISafeRunnable)menuLoader);
            Menu menu2 = menuLoader.getMenu();
            if (menu2 != null) {
                menuItem.setMenu(menu2);
            }
        }
        menuItem.addDisposeListener(this.disposeListener);
        menuItem.addListener(13, this.selectionListener);
    }

    public final void fill(ToolBar toolBar, int n) {
        if (this.widget != null && toolBar == null) {
            return;
        }
        ToolItem toolItem = n >= 0 ? new ToolItem(toolBar, 4, n) : new ToolItem(toolBar, 4);
        toolItem.setData((Object)this);
        this.widget = toolItem;
        toolItem.addDisposeListener(this.disposeListener);
        toolItem.addListener(13, this.selectionListener);
    }

    private final boolean loadDelegate() {
        if (this.delegate == null) {
            try {
                this.delegate = (IWorkbenchWindowPulldownDelegate)this.configurationElement.createExecutableExtension(this.delegateAttributeName);
                this.configurationElement = null;
                return true;
            }
            catch (ClassCastException classCastException) {
                Status status = new Status(4, WorkbenchPlugin.PI_WORKBENCH, 0, "The proxied delegate was the wrong class", (Throwable)classCastException);
                WorkbenchPlugin.log("The proxied delegate was the wrong class", (IStatus)status);
                return false;
            }
            catch (CoreException coreException) {
                String string = "The proxied delegate for '" + this.configurationElement.getAttribute(this.delegateAttributeName) + "' could not be loaded";
                Status status = new Status(4, WorkbenchPlugin.PI_WORKBENCH, 0, string, (Throwable)coreException);
                WorkbenchPlugin.log(string, (IStatus)status);
                return false;
            }
        }
        return true;
    }

    public final String toString() {
        if (this.delegate == null) {
            return this.configurationElement.getAttribute(this.delegateAttributeName);
        }
        return this.delegate.toString();
    }

    private static final class MenuLoader
    implements ISafeRunnable {
        private final Control control;
        private final IWorkbenchWindowPulldownDelegate delegate;
        private Menu menu = null;
        private final Menu parent;

        private MenuLoader(IWorkbenchWindowPulldownDelegate iWorkbenchWindowPulldownDelegate, Control control) {
            this.delegate = iWorkbenchWindowPulldownDelegate;
            this.parent = null;
            this.control = control;
        }

        private MenuLoader(IWorkbenchWindowPulldownDelegate2 iWorkbenchWindowPulldownDelegate2, Menu menu) {
            this.delegate = iWorkbenchWindowPulldownDelegate2;
            this.parent = menu;
            this.control = null;
        }

        private Menu getMenu() {
            return this.menu;
        }

        public void handleException(Throwable throwable) {
        }

        public void run() throws Exception {
            this.menu = this.parent == null ? this.delegate.getMenu(this.control) : ((IWorkbenchWindowPulldownDelegate2)this.delegate).getMenu(this.parent);
        }
    }
}

