/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.menus;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.internal.menus.AbstractMenuAdditionCacheEntry;
import org.eclipse.ui.internal.menus.MenuAdditionCacheEntry;
import org.eclipse.ui.internal.menus.MenuLocationURI;
import org.eclipse.ui.internal.menus.ProxyMenuAdditionCacheEntry;
import org.eclipse.ui.internal.menus.TrimAdditionCacheEntry;
import org.eclipse.ui.internal.menus.WorkbenchMenuService;
import org.eclipse.ui.internal.services.RegistryPersistence;

final class MenuPersistence
extends RegistryPersistence {
    private final WorkbenchMenuService menuService;

    MenuPersistence(WorkbenchMenuService workbenchMenuService) {
        if (workbenchMenuService == null) {
            throw new NullPointerException("The menu service cannot be null");
        }
        this.menuService = workbenchMenuService;
    }

    @Override
    public final void dispose() {
        super.dispose();
    }

    @Override
    protected final boolean isChangeImportant(IRegistryChangeEvent iRegistryChangeEvent) {
        return false;
    }

    public boolean menusNeedUpdating(IRegistryChangeEvent iRegistryChangeEvent) {
        IExtensionDelta[] iExtensionDeltaArray = iRegistryChangeEvent.getExtensionDeltas("org.eclipse.ui", "menus");
        return iExtensionDeltaArray.length != 0;
    }

    @Override
    protected final void read() {
        super.read();
        this.readTrimAdditions();
        this.readAdditions();
    }

    public void readTrimAdditions() {
        if (this.menuService == null) {
            return;
        }
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor("org.eclipse.ui.menus");
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            if ("group".equals(iConfigurationElementArray[n].getName())) {
                String string = iConfigurationElementArray[n].getAttribute("id");
                String string2 = "toolbar:" + string;
                if (iConfigurationElementArray[n].getChildren("location").length > 0) {
                    MenuLocationURI menuLocationURI;
                    IConfigurationElement iConfigurationElement = iConfigurationElementArray[n].getChildren("location")[0];
                    if (iConfigurationElement.getChildren("order").length > 0) {
                        menuLocationURI = iConfigurationElement.getChildren("order")[0];
                        String string3 = menuLocationURI.getAttribute("position");
                        String string4 = menuLocationURI.getAttribute("relativeTo");
                        string2 = String.valueOf(string2) + "?" + string3 + "=" + string4;
                        MenuLocationURI menuLocationURI2 = new MenuLocationURI("toolbar:" + string4);
                        List list = this.menuService.getAdditionsForURI(menuLocationURI2);
                        menuLocationURI2 = new MenuLocationURI(string2);
                        list.add(new TrimAdditionCacheEntry(iConfigurationElementArray[n], menuLocationURI2, this.menuService));
                    } else {
                        menuLocationURI = new MenuLocationURI(string2);
                        this.menuService.getAdditionsForURI(menuLocationURI);
                    }
                }
            }
            ++n;
        }
    }

    public void readAdditions() {
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        ArrayList<IConfigurationElement> arrayList = new ArrayList<IConfigurationElement>();
        IConfigurationElement[] iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor("org.eclipse.ui.menus");
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            if ("menuContribution".equals(iConfigurationElementArray[n].getName())) {
                arrayList.add(iConfigurationElementArray[n]);
            }
            ++n;
        }
        Comparator comparator = new Comparator(){

            public int compare(Object object, Object object2) {
                IConfigurationElement iConfigurationElement = (IConfigurationElement)object;
                IConfigurationElement iConfigurationElement2 = (IConfigurationElement)object2;
                return iConfigurationElement.getNamespaceIdentifier().compareToIgnoreCase(iConfigurationElement2.getNamespaceIdentifier());
            }
        };
        Collections.sort(arrayList, comparator);
        for (IConfigurationElement iConfigurationElement : arrayList) {
            AbstractMenuAdditionCacheEntry abstractMenuAdditionCacheEntry = null;
            abstractMenuAdditionCacheEntry = this.isProgramaticContribution(iConfigurationElement) ? new ProxyMenuAdditionCacheEntry(iConfigurationElement.getAttribute("locationURI"), iConfigurationElement.getNamespaceIdentifier(), iConfigurationElement) : new MenuAdditionCacheEntry(this.menuService, iConfigurationElement, iConfigurationElement.getAttribute("locationURI"), iConfigurationElement.getNamespaceIdentifier());
            if (abstractMenuAdditionCacheEntry == null) continue;
            this.menuService.addContributionFactory(abstractMenuAdditionCacheEntry);
        }
    }

    private boolean isProgramaticContribution(IConfigurationElement iConfigurationElement) {
        return iConfigurationElement.getAttribute("class") != null;
    }
}

