/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.menus;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.menus.AbstractMenuAdditionCacheEntry;
import org.eclipse.ui.internal.menus.DynamicMenuContributionItem;
import org.eclipse.ui.internal.menus.DynamicToolBarContributionItem;
import org.eclipse.ui.internal.menus.InternalControlContribution;
import org.eclipse.ui.internal.menus.MenuLocationURI;
import org.eclipse.ui.internal.provisional.presentations.IActionBarPresentationFactory;
import org.eclipse.ui.internal.services.IWorkbenchLocationService;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.menus.IContributionRoot;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.services.IServiceLocator;

public class MenuAdditionCacheEntry
extends AbstractMenuAdditionCacheEntry {
    private HashMap visWhenMap = new HashMap();
    private IMenuService menuService;
    private List subCaches;
    private boolean hasAdditions = false;
    private Boolean contributeToAllPopups = null;

    public MenuAdditionCacheEntry(IMenuService iMenuService, IConfigurationElement iConfigurationElement, String string, String string2) {
        super(string, string2, iConfigurationElement);
        this.menuService = iMenuService;
        this.findAdditions();
        this.generateSubCaches();
    }

    private void generateSubCaches() {
        IConfigurationElement[] iConfigurationElementArray = this.getConfigElement().getChildren();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            String string = iConfigurationElementArray[n].getName();
            if ("menu".equals(string) || "toolbar".equals(string)) {
                String string2 = String.valueOf(new MenuLocationURI(this.getLocation()).getScheme()) + ":" + MenuAdditionCacheEntry.getId(iConfigurationElementArray[n]);
                MenuAdditionCacheEntry menuAdditionCacheEntry = new MenuAdditionCacheEntry(this.menuService, iConfigurationElementArray[n], string2, this.getNamespace());
                this.menuService.addContributionFactory(menuAdditionCacheEntry);
                if (this.subCaches == null) {
                    this.subCaches = new ArrayList();
                }
                this.subCaches.add(menuAdditionCacheEntry);
            }
            ++n;
        }
    }

    private Expression getVisibleWhenForItem(IContributionItem iContributionItem, IConfigurationElement iConfigurationElement) {
        if (!this.visWhenMap.containsKey(iConfigurationElement)) {
            try {
                IConfigurationElement[] iConfigurationElementArray;
                IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElement.getChildren("visibleWhen");
                if (iConfigurationElementArray2.length > 0 && iConfigurationElementArray2.length < 2 && (iConfigurationElementArray = iConfigurationElementArray2[0].getChildren()).length > 0) {
                    Expression expression = ExpressionConverter.getDefault().perform(iConfigurationElementArray[0]);
                    this.visWhenMap.put(iConfigurationElement, expression);
                }
            }
            catch (InvalidRegistryObjectException invalidRegistryObjectException) {
                this.visWhenMap.put(iConfigurationElement, null);
                invalidRegistryObjectException.printStackTrace();
            }
            catch (CoreException coreException) {
                this.visWhenMap.put(iConfigurationElement, null);
                coreException.printStackTrace();
            }
        }
        return (Expression)this.visWhenMap.get(iConfigurationElement);
    }

    @Override
    public void createContributionItems(IServiceLocator iServiceLocator, IContributionRoot iContributionRoot) {
        IActionBarPresentationFactory iActionBarPresentationFactory = null;
        IWorkbenchLocationService iWorkbenchLocationService = (IWorkbenchLocationService)iServiceLocator.getService(IWorkbenchLocationService.class);
        WorkbenchWindow workbenchWindow = (WorkbenchWindow)iWorkbenchLocationService.getWorkbenchWindow();
        if (workbenchWindow != null) {
            iActionBarPresentationFactory = workbenchWindow.getActionBarPresentationFactory();
        }
        IConfigurationElement[] iConfigurationElementArray = this.getConfigElement().getChildren();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            String string = iConfigurationElementArray[n].getName();
            IContributionItem iContributionItem = null;
            if ("command".equals(string)) {
                iContributionItem = this.createCommandAdditionContribution(iServiceLocator, iConfigurationElementArray[n]);
            } else if ("dynamic".equals(string)) {
                iContributionItem = this.createDynamicAdditionContribution(iServiceLocator, iConfigurationElementArray[n]);
            } else if ("control".equals(string)) {
                iContributionItem = this.createControlAdditionContribution(iServiceLocator, iConfigurationElementArray[n]);
            } else if ("separator".equals(string)) {
                iContributionItem = this.createSeparatorAdditionContribution(iConfigurationElementArray[n]);
            } else if ("menu".equals(string)) {
                iContributionItem = this.createMenuAdditionContribution(iConfigurationElementArray[n]);
            } else if ("toolbar".equals(string)) {
                iContributionItem = this.createToolBarAdditionContribution(workbenchWindow, iActionBarPresentationFactory, iConfigurationElementArray[n]);
            }
            if (iContributionItem instanceof InternalControlContribution) {
                ((InternalControlContribution)iContributionItem).setWorkbenchWindow(workbenchWindow);
            }
            if (iContributionItem != null) {
                iContributionRoot.addContributionItem(iContributionItem, this.getVisibleWhenForItem(iContributionItem, iConfigurationElementArray[n]));
            }
            ++n;
        }
    }

    private IContributionItem createToolBarAdditionContribution(WorkbenchWindow workbenchWindow, IActionBarPresentationFactory iActionBarPresentationFactory, IConfigurationElement iConfigurationElement) {
        if (!this.inToolbar()) {
            return null;
        }
        String string = MenuAdditionCacheEntry.getId(iConfigurationElement);
        String string2 = MenuAdditionCacheEntry.getLabel(iConfigurationElement);
        if (string2 != null && string2.length() > 0) {
            workbenchWindow.putToolbarLabel(string, string2);
        }
        if (iActionBarPresentationFactory != null) {
            return iActionBarPresentationFactory.createToolBarContributionItem((IToolBarManager)iActionBarPresentationFactory.createToolBarManager(), string);
        }
        return new ToolBarContributionItem((IToolBarManager)new ToolBarManager(), string);
    }

    private boolean inToolbar() {
        return this.getLocation().startsWith("toolbar");
    }

    private IContributionItem createMenuAdditionContribution(IConfigurationElement iConfigurationElement) {
        int n;
        if (this.inToolbar()) {
            return null;
        }
        String string = MenuAdditionCacheEntry.getLabel(iConfigurationElement);
        String string2 = MenuAdditionCacheEntry.getMnemonic(iConfigurationElement);
        if (string != null && string2 != null && (n = string.indexOf(string2)) != -1) {
            string = String.valueOf(string.substring(0, n)) + '&' + string.substring(n);
        }
        MenuManager menuManager = new MenuManager(string, MenuAdditionCacheEntry.getIconDescriptor(iConfigurationElement), MenuAdditionCacheEntry.getId(iConfigurationElement));
        menuManager.setActionDefinitionId(MenuAdditionCacheEntry.getCommandId(iConfigurationElement));
        return menuManager;
    }

    private IContributionItem createSeparatorAdditionContribution(IConfigurationElement iConfigurationElement) {
        if (MenuAdditionCacheEntry.isSeparatorVisible(iConfigurationElement)) {
            return new Separator(MenuAdditionCacheEntry.getName(iConfigurationElement));
        }
        return new GroupMarker(MenuAdditionCacheEntry.getName(iConfigurationElement));
    }

    private IContributionItem createDynamicAdditionContribution(IServiceLocator iServiceLocator, IConfigurationElement iConfigurationElement) {
        return new DynamicMenuContributionItem(MenuAdditionCacheEntry.getId(iConfigurationElement), iServiceLocator, iConfigurationElement);
    }

    private IContributionItem createControlAdditionContribution(IServiceLocator iServiceLocator, IConfigurationElement iConfigurationElement) {
        if (this.inToolbar()) {
            return new DynamicToolBarContributionItem(MenuAdditionCacheEntry.getId(iConfigurationElement), iServiceLocator, iConfigurationElement);
        }
        return null;
    }

    private IContributionItem createCommandAdditionContribution(IServiceLocator iServiceLocator, IConfigurationElement iConfigurationElement) {
        CommandContributionItemParameter commandContributionItemParameter = new CommandContributionItemParameter(iServiceLocator, MenuAdditionCacheEntry.getId(iConfigurationElement), MenuAdditionCacheEntry.getCommandId(iConfigurationElement), MenuAdditionCacheEntry.getParameters(iConfigurationElement), MenuAdditionCacheEntry.getIconDescriptor(iConfigurationElement), MenuAdditionCacheEntry.getDisabledIconDescriptor(iConfigurationElement), MenuAdditionCacheEntry.getHoverIconDescriptor(iConfigurationElement), MenuAdditionCacheEntry.getLabel(iConfigurationElement), MenuAdditionCacheEntry.getMnemonic(iConfigurationElement), MenuAdditionCacheEntry.getTooltip(iConfigurationElement), this.getStyle(iConfigurationElement), MenuAdditionCacheEntry.getHelpContextId(iConfigurationElement), MenuAdditionCacheEntry.getVisibleEnabled(iConfigurationElement));
        if (this.inToolbar()) {
            commandContributionItemParameter.iconStyle = "toolbar";
        }
        commandContributionItemParameter.mode = MenuAdditionCacheEntry.getMode(iConfigurationElement);
        return new CommandContributionItem(commandContributionItemParameter);
    }

    static boolean getVisibleEnabled(IConfigurationElement iConfigurationElement) {
        IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren("visibleWhen");
        String string = null;
        if (iConfigurationElementArray.length > 0) {
            string = iConfigurationElementArray[0].getAttribute("checkEnabled");
        }
        return string != null && string.equalsIgnoreCase("true");
    }

    public static String getId(IConfigurationElement iConfigurationElement) {
        String string = iConfigurationElement.getAttribute("id");
        if (string == null || string.length() == 0) {
            string = MenuAdditionCacheEntry.getCommandId(iConfigurationElement);
        }
        if (string == null || string.length() == 0) {
            string = iConfigurationElement.toString();
        }
        return string;
    }

    static String getName(IConfigurationElement iConfigurationElement) {
        return iConfigurationElement.getAttribute("name");
    }

    static int getMode(IConfigurationElement iConfigurationElement) {
        if ("FORCE_TEXT".equals(iConfigurationElement.getAttribute("mode"))) {
            return CommandContributionItem.MODE_FORCE_TEXT;
        }
        return 0;
    }

    static String getLabel(IConfigurationElement iConfigurationElement) {
        return iConfigurationElement.getAttribute("label");
    }

    static String getMnemonic(IConfigurationElement iConfigurationElement) {
        return iConfigurationElement.getAttribute("mnemonic");
    }

    static String getTooltip(IConfigurationElement iConfigurationElement) {
        return iConfigurationElement.getAttribute("tooltip");
    }

    static String getIconPath(IConfigurationElement iConfigurationElement) {
        return iConfigurationElement.getAttribute("icon");
    }

    static String getDisabledIconPath(IConfigurationElement iConfigurationElement) {
        return iConfigurationElement.getAttribute("disabledIcon");
    }

    static String getHoverIconPath(IConfigurationElement iConfigurationElement) {
        return iConfigurationElement.getAttribute("hoverIcon");
    }

    static ImageDescriptor getIconDescriptor(IConfigurationElement iConfigurationElement) {
        String string = iConfigurationElement.getDeclaringExtension().getContributor().getName();
        String string2 = MenuAdditionCacheEntry.getIconPath(iConfigurationElement);
        if (string2 != null) {
            return AbstractUIPlugin.imageDescriptorFromPlugin(string, string2);
        }
        return null;
    }

    static ImageDescriptor getDisabledIconDescriptor(IConfigurationElement iConfigurationElement) {
        String string = iConfigurationElement.getDeclaringExtension().getContributor().getName();
        String string2 = MenuAdditionCacheEntry.getDisabledIconPath(iConfigurationElement);
        if (string2 != null) {
            return AbstractUIPlugin.imageDescriptorFromPlugin(string, string2);
        }
        return null;
    }

    static ImageDescriptor getHoverIconDescriptor(IConfigurationElement iConfigurationElement) {
        String string = iConfigurationElement.getDeclaringExtension().getContributor().getName();
        String string2 = MenuAdditionCacheEntry.getHoverIconPath(iConfigurationElement);
        if (string2 != null) {
            return AbstractUIPlugin.imageDescriptorFromPlugin(string, string2);
        }
        return null;
    }

    static String getHelpContextId(IConfigurationElement iConfigurationElement) {
        return iConfigurationElement.getAttribute("helpContextId");
    }

    public static boolean isSeparatorVisible(IConfigurationElement iConfigurationElement) {
        String string = iConfigurationElement.getAttribute("visible");
        return Boolean.valueOf(string);
    }

    public static String getClassSpec(IConfigurationElement iConfigurationElement) {
        return iConfigurationElement.getAttribute("class");
    }

    public static String getCommandId(IConfigurationElement iConfigurationElement) {
        return iConfigurationElement.getAttribute("commandId");
    }

    private int getStyle(IConfigurationElement iConfigurationElement) {
        String string = iConfigurationElement.getAttribute("style");
        if (string == null || string.length() == 0) {
            return 8;
        }
        if ("toggle".equals(string)) {
            return 32;
        }
        if ("radio".equals(string)) {
            return 16;
        }
        if ("pulldown".equals(string)) {
            return 4;
        }
        return 8;
    }

    public static Map getParameters(IConfigurationElement iConfigurationElement) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren("parameter");
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            String string = iConfigurationElementArray[n].getAttribute("name");
            String string2 = iConfigurationElementArray[n].getAttribute("value");
            if (string != null && string2 != null) {
                hashMap.put(string, string2);
            }
            ++n;
        }
        return hashMap;
    }

    public List getSubCaches() {
        return this.subCaches;
    }

    private void findAdditions() {
        IConfigurationElement[] iConfigurationElementArray = this.getConfigElement().getChildren();
        boolean bl = false;
        int n = 0;
        while (n < iConfigurationElementArray.length && !bl) {
            String string = iConfigurationElementArray[n].getName();
            if ("separator".equals(string) && "additions".equals(MenuAdditionCacheEntry.getName(iConfigurationElementArray[n]))) {
                this.hasAdditions = true;
                bl = true;
            }
            ++n;
        }
    }

    public boolean hasAdditions() {
        return this.hasAdditions;
    }

    public boolean contributeToAllPopups() {
        if (this.contributeToAllPopups == null) {
            String string = this.getConfigElement().getAttribute("allPopups");
            this.contributeToAllPopups = string == null || Boolean.valueOf(string) != false ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.contributeToAllPopups;
    }
}

