/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.menus;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.CommandEvent;
import org.eclipse.core.commands.ICommandListener;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.State;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.Scheme;
import org.eclipse.jface.bindings.keys.KeyBinding;
import org.eclipse.jface.bindings.keys.KeyLookupFactory;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.commands.RadioState;
import org.eclipse.jface.commands.ToggleState;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.SelectionEnabler;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.ActionExpression;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.expressions.LegacyActionExpressionWrapper;
import org.eclipse.ui.internal.expressions.LegacyActionSetExpression;
import org.eclipse.ui.internal.expressions.LegacyEditorContributionExpression;
import org.eclipse.ui.internal.expressions.LegacySelectionEnablerWrapper;
import org.eclipse.ui.internal.expressions.LegacyViewContributionExpression;
import org.eclipse.ui.internal.expressions.LegacyViewerContributionExpression;
import org.eclipse.ui.internal.handlers.ActionDelegateHandlerProxy;
import org.eclipse.ui.internal.handlers.IActionCommandMappingService;
import org.eclipse.ui.internal.keys.BindingService;
import org.eclipse.ui.internal.services.RegistryPersistence;
import org.eclipse.ui.keys.IBindingService;

public final class LegacyActionPersistence
extends RegistryPersistence {
    private static final int INDEX_ACTION_SETS = 0;
    private static final int INDEX_EDITOR_CONTRIBUTIONS = 1;
    private static final int INDEX_OBJECT_CONTRIBUTIONS = 2;
    private static final int INDEX_VIEW_CONTRIBUTIONS = 3;
    private static final int INDEX_VIEWER_CONTRIBUTIONS = 4;
    private final BindingService bindingService;
    private final ICommandService commandService;
    private final Collection handlerActivations = new ArrayList();
    private final Collection menuContributions = new ArrayList();
    private final IWorkbenchWindow window;
    private ICommandListener actionSetListener = new ICommandListener(){

        public void commandChanged(CommandEvent commandEvent) {
            Command command = commandEvent.getCommand();
            String string = command.getId();
            Binding binding = (Binding)LegacyActionPersistence.this.commandIdToBinding.get(string);
            if (binding != null) {
                if (command.isEnabled()) {
                    if (!LegacyActionPersistence.this.actionSetActiveBindings.contains(binding)) {
                        LegacyActionPersistence.this.bindingService.addBinding(binding);
                        LegacyActionPersistence.this.actionSetActiveBindings.add(binding);
                    }
                } else if (LegacyActionPersistence.this.actionSetActiveBindings.contains(binding)) {
                    LegacyActionPersistence.this.bindingService.removeBinding(binding);
                    LegacyActionPersistence.this.actionSetActiveBindings.remove(binding);
                }
            }
        }
    };
    private HashMap commandIdToBinding = new HashMap();
    private HashSet actionSetActiveBindings = new HashSet();

    private static final Expression readVisibility(IConfigurationElement iConfigurationElement, String string, List list) {
        IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren("visibility");
        if (iConfigurationElementArray == null || iConfigurationElementArray.length == 0) {
            return null;
        }
        if (iConfigurationElementArray.length != 1) {
            LegacyActionPersistence.addWarning(list, "There can only be one visibility element", iConfigurationElement, string);
        }
        IConfigurationElement iConfigurationElement2 = iConfigurationElementArray[0];
        ActionExpression actionExpression = new ActionExpression(iConfigurationElement2);
        LegacyActionExpressionWrapper legacyActionExpressionWrapper = new LegacyActionExpressionWrapper(actionExpression, null);
        return legacyActionExpressionWrapper;
    }

    public LegacyActionPersistence(IWorkbenchWindow iWorkbenchWindow) {
        this.bindingService = (BindingService)iWorkbenchWindow.getService(IBindingService.class);
        this.commandService = (ICommandService)iWorkbenchWindow.getService(ICommandService.class);
        this.window = iWorkbenchWindow;
    }

    private final void clearActivations() {
        IHandlerService iHandlerService = (IHandlerService)this.window.getService(IHandlerService.class);
        iHandlerService.deactivateHandlers(this.handlerActivations);
        for (IHandlerActivation iHandlerActivation : this.handlerActivations) {
            IHandler iHandler = iHandlerActivation.getHandler();
            if (iHandler == null) continue;
            iHandler.dispose();
        }
        this.handlerActivations.clear();
    }

    private final void clearBindings() {
        for (Map.Entry entry : this.commandIdToBinding.entrySet()) {
            String string = (String)entry.getKey();
            Binding binding = (Binding)entry.getValue();
            this.commandService.getCommand(string).removeCommandListener(this.actionSetListener);
            if (binding == null || !this.actionSetActiveBindings.contains(binding)) continue;
            this.bindingService.removeBinding(binding);
        }
        this.commandIdToBinding.clear();
        this.actionSetActiveBindings.clear();
    }

    private final void clearImages() {
    }

    private final void clearMenus() {
        this.menuContributions.clear();
    }

    private final void convertActionToBinding(IConfigurationElement iConfigurationElement, ParameterizedCommand parameterizedCommand, List list) {
        String string;
        String string2 = LegacyActionPersistence.readOptional(iConfigurationElement, "accelerator");
        if (string2 == null && (string = LegacyActionPersistence.readOptional(iConfigurationElement, "label")) != null) {
            string2 = LegacyActionTools.extractAcceleratorText((String)string);
        }
        if (string2 != null) {
            string = KeyLookupFactory.getSWTKeyLookup();
            int n = LegacyActionTools.convertAccelerator((String)string2);
            int n2 = string.getAlt() | string.getCommand() | string.getCtrl() | string.getShift();
            int n3 = n & n2;
            int n4 = n & ~n2;
            KeyStroke keyStroke = KeyStroke.getInstance((int)n3, (int)n4);
            KeySequence keySequence = KeySequence.getInstance((KeyStroke)keyStroke);
            Scheme scheme = this.bindingService.getActiveScheme();
            try {
                KeyBinding keyBinding = new KeyBinding(keySequence, parameterizedCommand, scheme.getId(), "org.eclipse.ui.contexts.window", null, null, null, 0);
                this.commandIdToBinding.put(parameterizedCommand.getCommand().getId(), keyBinding);
                if (parameterizedCommand.getCommand().isEnabled()) {
                    this.bindingService.addBinding((Binding)keyBinding);
                    this.actionSetActiveBindings.add(keyBinding);
                }
                parameterizedCommand.getCommand().addCommandListener(this.actionSetListener);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LegacyActionPersistence.addWarning(list, "invalid keybinding: " + illegalArgumentException.getMessage(), iConfigurationElement, parameterizedCommand.getCommand().getId());
            }
        }
    }

    private final ParameterizedCommand convertActionToCommand(IConfigurationElement iConfigurationElement, String string, String string2, List list) {
        String string3 = LegacyActionPersistence.readOptional(iConfigurationElement, "definitionId");
        Command command = null;
        if (string3 != null) {
            command = this.commandService.getCommand(string3);
        }
        IActionCommandMappingService iActionCommandMappingService = (IActionCommandMappingService)this.window.getService(IActionCommandMappingService.class);
        String string4 = null;
        if (string3 == null || !command.isDefined()) {
            if (string3 == null && iActionCommandMappingService != null) {
                string3 = iActionCommandMappingService.getGeneratedCommandId(string, string2);
            }
            if (string3 == null) {
                WorkbenchPlugin.log("MappingService unavailable");
                return null;
            }
            string4 = LegacyActionPersistence.readRequired(iConfigurationElement, "label", list, "Actions require a non-empty label or definitionId", string3);
            if (string4 == null) {
                string4 = WorkbenchMessages.LegacyActionPersistence_AutogeneratedCommandName;
            }
            String string5 = LegacyActionPersistence.readOptional(iConfigurationElement, "tooltip");
            command = this.commandService.getCommand(string3);
            Category category = this.commandService.getCategory(null);
            String string6 = LegacyActionTools.removeAcceleratorText((String)Action.removeMnemonics((String)string4));
            command.define(string6, string5, category, null);
            String string7 = LegacyActionPersistence.readOptional(iConfigurationElement, "style");
            if ("radio".equals(string7)) {
                RadioState radioState = new RadioState();
                boolean bl = LegacyActionPersistence.readBoolean(iConfigurationElement, "state", false);
                radioState.setValue((Object)(bl ? Boolean.TRUE : Boolean.FALSE));
                command.addState("STYLE", (State)radioState);
            } else if ("toggle".equals(string7)) {
                ToggleState toggleState = new ToggleState();
                boolean bl = LegacyActionPersistence.readBoolean(iConfigurationElement, "state", false);
                toggleState.setValue((Object)(bl ? Boolean.TRUE : Boolean.FALSE));
                command.addState("STYLE", (State)toggleState);
            }
        }
        if (iActionCommandMappingService != null && string3 != null) {
            iActionCommandMappingService.map(iActionCommandMappingService.getGeneratedCommandId(string, string2), string3);
        }
        return new ParameterizedCommand(command, null);
    }

    private final void convertActionToHandler(IConfigurationElement iConfigurationElement, String string, ParameterizedCommand parameterizedCommand, Expression expression, String string2, List list) {
        Object object;
        boolean bl = LegacyActionPersistence.readBoolean(iConfigurationElement, "retarget", false);
        boolean bl2 = iConfigurationElement.getAttribute("class") != null || iConfigurationElement.getChildren("class").length != 0;
        String string3 = LegacyActionPersistence.readOptional(iConfigurationElement, "class");
        if (bl2 && string3 == null) {
            string3 = LegacyActionPersistence.readOptional(iConfigurationElement.getChildren("class")[0], "class");
        }
        if (bl) {
            IActionCommandMappingService iActionCommandMappingService;
            if (bl2 && !LegacyActionPersistence.isPulldown(iConfigurationElement)) {
                LegacyActionPersistence.addWarning(list, "The class was not null but retarget was set to true", iConfigurationElement, string, "class", string3);
            }
            if ((iActionCommandMappingService = (IActionCommandMappingService)this.window.getService(IActionCommandMappingService.class)) != null) {
                iActionCommandMappingService.map(string, parameterizedCommand.getId());
            } else {
                LegacyActionPersistence.addWarning(list, "Retarget service unavailable", iConfigurationElement, string);
            }
            return;
        }
        if (!bl2) {
            LegacyActionPersistence.addWarning(list, "There was no class provided, and the action is not retargettable", iConfigurationElement, string);
            return;
        }
        SelectionEnabler selectionEnabler = null;
        if (iConfigurationElement.getAttribute("enablesFor") != null) {
            selectionEnabler = new SelectionEnabler(iConfigurationElement);
        } else {
            object = iConfigurationElement.getChildren("enablement");
            if (((IConfigurationElement[])object).length > 0) {
                selectionEnabler = new SelectionEnabler(iConfigurationElement);
            }
        }
        object = selectionEnabler == null ? null : new LegacySelectionEnablerWrapper(selectionEnabler, this.window);
        ActionDelegateHandlerProxy actionDelegateHandlerProxy = new ActionDelegateHandlerProxy(iConfigurationElement, "class", string, parameterizedCommand, this.window, null, (Expression)object, string2);
        String string4 = LegacyActionPersistence.readOptional(iConfigurationElement, "helpContextId");
        if (string4 != null) {
            this.commandService.setHelpContextId((IHandler)actionDelegateHandlerProxy, string4);
        }
        String string5 = parameterizedCommand.getId();
        IHandlerService iHandlerService = (IHandlerService)this.window.getService(IHandlerService.class);
        IHandlerActivation iHandlerActivation = expression == null ? iHandlerService.activateHandler(string5, (IHandler)actionDelegateHandlerProxy) : iHandlerService.activateHandler(string5, (IHandler)actionDelegateHandlerProxy, expression);
        this.handlerActivations.add(iHandlerActivation);
    }

    @Override
    public final void dispose() {
        super.dispose();
        this.clear();
    }

    private void clear() {
        this.clearActivations();
        this.clearBindings();
        this.clearImages();
        this.clearMenus();
    }

    @Override
    protected final boolean isChangeImportant(IRegistryChangeEvent iRegistryChangeEvent) {
        return iRegistryChangeEvent.getExtensionDeltas("org.eclipse.ui", "actionSets").length != 0 || iRegistryChangeEvent.getExtensionDeltas("org.eclipse.ui", "editorActions").length != 0 || iRegistryChangeEvent.getExtensionDeltas("org.eclipse.ui", "popupMenus").length != 0 || iRegistryChangeEvent.getExtensionDeltas("org.eclipse.ui", "viewActions").length != 0;
    }

    @Override
    public final void read() {
        String string;
        String string2;
        String string3;
        this.clear();
        LegacyActionPersistence.super.read();
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        IConfigurationElement[][] iConfigurationElementArrayArray = new IConfigurationElement[5][];
        IConfigurationElement[] iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor("org.eclipse.ui.actionSets");
        int n6 = 0;
        while (n6 < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n6];
            string3 = iConfigurationElement.getName();
            if ("actionSet".equals(string3)) {
                LegacyActionPersistence.addElementToIndexedArray(iConfigurationElement, iConfigurationElementArrayArray, 0, n++);
            }
            ++n6;
        }
        IConfigurationElement[] iConfigurationElementArray2 = iExtensionRegistry.getConfigurationElementsFor("org.eclipse.ui.editorActions");
        int n7 = 0;
        while (n7 < iConfigurationElementArray2.length) {
            string3 = iConfigurationElementArray2[n7];
            string2 = string3.getName();
            if ("editorContribution".equals(string2)) {
                LegacyActionPersistence.addElementToIndexedArray((IConfigurationElement)string3, iConfigurationElementArrayArray, 1, n2++);
            }
            ++n7;
        }
        IConfigurationElement[] iConfigurationElementArray3 = iExtensionRegistry.getConfigurationElementsFor("org.eclipse.ui.popupMenus");
        int n8 = 0;
        while (n8 < iConfigurationElementArray3.length) {
            string2 = iConfigurationElementArray3[n8];
            string = string2.getName();
            if ("objectContribution".equals(string)) {
                LegacyActionPersistence.addElementToIndexedArray((IConfigurationElement)string2, iConfigurationElementArrayArray, 2, n3++);
            } else if ("viewerContribution".equals(string)) {
                LegacyActionPersistence.addElementToIndexedArray((IConfigurationElement)string2, iConfigurationElementArrayArray, 4, n5++);
            }
            ++n8;
        }
        IConfigurationElement[] iConfigurationElementArray4 = iExtensionRegistry.getConfigurationElementsFor("org.eclipse.ui.viewActions");
        int n9 = 0;
        while (n9 < iConfigurationElementArray4.length) {
            string = iConfigurationElementArray4[n9];
            String string4 = string.getName();
            if ("viewContribution".equals(string4)) {
                LegacyActionPersistence.addElementToIndexedArray((IConfigurationElement)string, iConfigurationElementArrayArray, 3, n4++);
            }
            ++n9;
        }
        this.readActionSets(iConfigurationElementArrayArray[0], n);
        this.readEditorContributions(iConfigurationElementArrayArray[1], n2);
        this.readObjectContributions(iConfigurationElementArrayArray[2], n3);
        this.readViewContributions(iConfigurationElementArrayArray[3], n4);
        this.readViewerContributions(iConfigurationElementArrayArray[4], n5);
    }

    private final void readActions(String string, IConfigurationElement[] iConfigurationElementArray, List list, Expression expression, String string2) {
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            ParameterizedCommand parameterizedCommand;
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            String string3 = LegacyActionPersistence.readRequired(iConfigurationElement, "id", list, "Actions require an id");
            if (string3 != null && (parameterizedCommand = this.convertActionToCommand(iConfigurationElement, string, string3, list)) != null) {
                this.convertActionToHandler(iConfigurationElement, string3, parameterizedCommand, expression, string2, list);
                this.convertActionToBinding(iConfigurationElement, parameterizedCommand, list);
            }
            ++n;
        }
    }

    private final void readActionsAndMenus(IConfigurationElement iConfigurationElement, String string, List list, Expression expression, String string2) {
        IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren("action");
        this.readActions(string, iConfigurationElementArray, list, expression, string2);
    }

    private final void readActionSets(IConfigurationElement[] iConfigurationElementArray, int n) {
        ArrayList arrayList = new ArrayList(1);
        int n2 = 0;
        while (n2 < n) {
            String string;
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
            String string2 = LegacyActionPersistence.readRequired(iConfigurationElement, "id", arrayList, "Action sets need an id");
            if (string2 != null && (string = LegacyActionPersistence.readRequired(iConfigurationElement, "label", arrayList, "Actions set need a label", string2)) != null) {
                LegacyActionSetExpression legacyActionSetExpression = new LegacyActionSetExpression(string2, this.window);
                this.readActionsAndMenus(iConfigurationElement, string2, arrayList, legacyActionSetExpression, null);
            }
            ++n2;
        }
        LegacyActionPersistence.logWarnings(arrayList, "Warnings while parsing the action sets from the 'org.eclipse.ui.actionSets' extension point");
    }

    private final void readEditorContributions(IConfigurationElement[] iConfigurationElementArray, int n) {
        ArrayList arrayList = new ArrayList(1);
        int n2 = 0;
        while (n2 < n) {
            String string;
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
            String string2 = LegacyActionPersistence.readRequired(iConfigurationElement, "id", arrayList, "Editor contributions need an id");
            if (string2 != null && (string = LegacyActionPersistence.readRequired(iConfigurationElement, "targetID", arrayList, "Editor contributions need a target id", string2)) != null) {
                LegacyEditorContributionExpression legacyEditorContributionExpression = new LegacyEditorContributionExpression(string, this.window);
                this.readActionsAndMenus(iConfigurationElement, string2, arrayList, legacyEditorContributionExpression, null);
            }
            ++n2;
        }
        LegacyActionPersistence.logWarnings(arrayList, "Warnings while parsing the editor contributions from the 'org.eclipse.ui.editorActions' extension point");
    }

    private final void readObjectContributions(IConfigurationElement[] iConfigurationElementArray, int n) {
        ArrayList arrayList = new ArrayList(1);
        int n2 = 0;
        while (n2 < n) {
            String string;
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
            String string2 = LegacyActionPersistence.readRequired(iConfigurationElement, "id", arrayList, "Object contributions need an id");
            if (string2 != null && (string = LegacyActionPersistence.readRequired(iConfigurationElement, "objectClass", arrayList, "Object contributions need an object class", string2)) != null) {
                boolean bl = LegacyActionPersistence.readBoolean(iConfigurationElement, "adaptable", false);
                Expression expression = LegacyActionPersistence.readVisibility(iConfigurationElement, string2, arrayList);
                if (expression == null) {
                    expression = new ObjectClassExpression(string, bl);
                }
                this.readActionsAndMenus(iConfigurationElement, string2, arrayList, expression, null);
            }
            ++n2;
        }
        LegacyActionPersistence.logWarnings(arrayList, "Warnings while parsing the object contributions from the 'org.eclipse.ui.popupMenus' extension point");
    }

    private final void readViewContributions(IConfigurationElement[] iConfigurationElementArray, int n) {
        ArrayList arrayList = new ArrayList(1);
        int n2 = 0;
        while (n2 < n) {
            String string;
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
            String string2 = LegacyActionPersistence.readRequired(iConfigurationElement, "id", arrayList, "View contributions need an id");
            if (string2 != null && (string = LegacyActionPersistence.readRequired(iConfigurationElement, "targetID", arrayList, "View contributions need a target id", string2)) != null) {
                LegacyViewContributionExpression legacyViewContributionExpression = new LegacyViewContributionExpression(string, this.window);
                this.readActionsAndMenus(iConfigurationElement, string2, arrayList, legacyViewContributionExpression, string);
            }
            ++n2;
        }
        LegacyActionPersistence.logWarnings(arrayList, "Warnings while parsing the view contributions from the 'org.eclipse.ui.viewActions' extension point");
    }

    private final void readViewerContributions(IConfigurationElement[] iConfigurationElementArray, int n) {
        ArrayList arrayList = new ArrayList(1);
        int n2 = 0;
        while (n2 < n) {
            String string;
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
            String string2 = LegacyActionPersistence.readRequired(iConfigurationElement, "id", arrayList, "Viewer contributions need an id");
            if (string2 != null && (string = LegacyActionPersistence.readRequired(iConfigurationElement, "targetID", arrayList, "Viewer contributions need a target id", string2)) != null) {
                Expression expression = LegacyActionPersistence.readVisibility(iConfigurationElement, string2, arrayList);
                LegacyViewerContributionExpression legacyViewerContributionExpression = new LegacyViewerContributionExpression(string, this.window, expression);
                this.readActionsAndMenus(iConfigurationElement, string2, arrayList, legacyViewerContributionExpression, string);
            }
            ++n2;
        }
        LegacyActionPersistence.logWarnings(arrayList, "Warnings while parsing the viewer contributions from the 'org.eclipse.ui.popupMenus' extension point");
    }

    private static class ObjectClassExpression
    extends Expression {
        String objectClass;
        boolean adapt = false;

        public ObjectClassExpression(String string, boolean bl) {
            this.objectClass = string;
            this.adapt = bl;
        }

        public void collectExpressionInfo(ExpressionInfo expressionInfo) {
            expressionInfo.addVariableNameAccess("activeMenuSelection");
        }

        public EvaluationResult evaluate(IEvaluationContext iEvaluationContext) throws CoreException {
            Object object = iEvaluationContext.getVariable("activeMenuSelection");
            if (object == null || object == IEvaluationContext.UNDEFINED_VARIABLE) {
                return EvaluationResult.FALSE;
            }
            if (this.adapt) {
                int n = Platform.getAdapterManager().queryAdapter(object, this.objectClass);
                switch (n) {
                    case 2: {
                        return EvaluationResult.TRUE;
                    }
                    case 1: {
                        return EvaluationResult.NOT_LOADED;
                    }
                }
            } else if (this.objectClass.equals(object.getClass().getName())) {
                return EvaluationResult.TRUE;
            }
            return EvaluationResult.FALSE;
        }
    }
}

