/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.menus;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.AbstractSourceProvider;
import org.eclipse.ui.swt.IFocusService;

public class FocusControlSourceProvider
extends AbstractSourceProvider
implements IFocusService {
    private static final String[] PROVIDED_SOURCE_NAMES = new String[]{"activeFocusControlId", "activeFocusControl"};
    Map controlToId = new HashMap();
    private FocusListener focusListener;
    private String currentId;
    private Control currentControl;
    private DisposeListener disposeListener;

    @Override
    public void addFocusTracker(Control control, String string) {
        if (control.isDisposed()) {
            return;
        }
        this.controlToId.put(control, string);
        control.addFocusListener(this.getFocusListener());
        control.addDisposeListener(this.getDisposeListener());
    }

    private DisposeListener getDisposeListener() {
        if (this.disposeListener == null) {
            this.disposeListener = new DisposeListener(){

                public void widgetDisposed(DisposeEvent disposeEvent) {
                    FocusControlSourceProvider.this.controlToId.remove(disposeEvent.widget);
                }
            };
        }
        return this.disposeListener;
    }

    private FocusListener getFocusListener() {
        if (this.focusListener == null) {
            this.focusListener = new FocusListener(){

                public void focusGained(FocusEvent focusEvent) {
                    FocusControlSourceProvider.this.focusIn(focusEvent.widget);
                }

                public void focusLost(FocusEvent focusEvent) {
                    FocusControlSourceProvider.this.focusIn(null);
                }
            };
        }
        return this.focusListener;
    }

    private void focusIn(Widget widget) {
        String string = (String)this.controlToId.get(widget);
        if (this.currentId != string) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            if (string == null) {
                this.currentId = null;
                this.currentControl = null;
                hashMap.put("activeFocusControlId", IEvaluationContext.UNDEFINED_VARIABLE);
                hashMap.put("activeFocusControl", IEvaluationContext.UNDEFINED_VARIABLE);
            } else {
                this.currentId = string;
                this.currentControl = (Control)widget;
                hashMap.put("activeFocusControlId", this.currentId);
                hashMap.put("activeFocusControl", this.currentControl);
            }
            this.fireSourceChanged(Integer.MIN_VALUE, hashMap);
        }
    }

    @Override
    public void removeFocusTracker(Control control) {
        this.controlToId.remove(control);
        if (control.isDisposed()) {
            return;
        }
        control.removeFocusListener(this.getFocusListener());
        control.removeDisposeListener(this.getDisposeListener());
    }

    @Override
    public void dispose() {
        for (Control control : this.controlToId.keySet()) {
            if (control.isDisposed()) continue;
            control.removeFocusListener(this.getFocusListener());
            control.removeDisposeListener(this.getDisposeListener());
        }
        this.controlToId.clear();
        this.controlToId = null;
        this.focusListener = null;
        this.disposeListener = null;
    }

    @Override
    public Map getCurrentState() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (this.currentId == null) {
            hashMap.put("activeFocusControlId", IEvaluationContext.UNDEFINED_VARIABLE);
            hashMap.put("activeFocusControl", IEvaluationContext.UNDEFINED_VARIABLE);
        } else {
            hashMap.put("activeFocusControlId", this.currentId);
            hashMap.put("activeFocusControl", this.currentControl);
        }
        return hashMap;
    }

    @Override
    public String[] getProvidedSourceNames() {
        return PROVIDED_SOURCE_NAMES;
    }
}

