/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.menus;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.menus.WorkbenchWindowControlContribution;
import org.eclipse.ui.services.IServiceLocator;

public class DynamicToolBarContributionItem
extends WorkbenchWindowControlContribution {
    private final IConfigurationElement dynamicAddition;
    private final IServiceLocator locator;
    private boolean alreadyFailed;
    private WorkbenchWindowControlContribution loadedDynamicContribution;

    public DynamicToolBarContributionItem(String string, IServiceLocator iServiceLocator, IConfigurationElement iConfigurationElement) {
        super(string);
        this.locator = iServiceLocator;
        this.dynamicAddition = iConfigurationElement;
    }

    public boolean isDynamic() {
        if (this.loadedDynamicContribution != null) {
            return this.loadedDynamicContribution.isDynamic();
        }
        return true;
    }

    public boolean isDirty() {
        if (this.loadedDynamicContribution != null) {
            return this.loadedDynamicContribution.isDirty();
        }
        return super.isDirty();
    }

    public boolean isEnabled() {
        if (this.loadedDynamicContribution != null) {
            return this.loadedDynamicContribution.isEnabled();
        }
        return super.isEnabled();
    }

    public boolean isGroupMarker() {
        if (this.loadedDynamicContribution != null) {
            return this.loadedDynamicContribution.isGroupMarker();
        }
        return super.isGroupMarker();
    }

    public boolean isSeparator() {
        if (this.loadedDynamicContribution != null) {
            return this.loadedDynamicContribution.isSeparator();
        }
        return super.isSeparator();
    }

    public void saveWidgetState() {
        if (this.loadedDynamicContribution != null) {
            this.loadedDynamicContribution.saveWidgetState();
        }
        super.saveWidgetState();
    }

    public void setVisible(boolean bl) {
        if (this.loadedDynamicContribution != null) {
            this.loadedDynamicContribution.setVisible(bl);
        }
        super.setVisible(bl);
    }

    public boolean isVisible() {
        if (this.loadedDynamicContribution != null) {
            return this.loadedDynamicContribution.isVisible();
        }
        return super.isVisible();
    }

    public void fill(CoolBar coolBar, int n) {
        WorkbenchWindowControlContribution workbenchWindowControlContribution = this.getContributionItem();
        if (workbenchWindowControlContribution != null) {
            workbenchWindowControlContribution.fill(coolBar, n);
        }
    }

    private WorkbenchWindowControlContribution getContributionItem() {
        if (this.loadedDynamicContribution == null && !this.alreadyFailed) {
            this.createContributionItem();
        }
        return this.loadedDynamicContribution;
    }

    private void createContributionItem() {
        this.loadedDynamicContribution = (WorkbenchWindowControlContribution)((Object)Util.safeLoadExecutableExtension(this.dynamicAddition, "class", WorkbenchWindowControlContribution.class));
        if (this.loadedDynamicContribution == null) {
            this.alreadyFailed = true;
            return;
        }
        this.loadedDynamicContribution.setId(this.getId());
        this.loadedDynamicContribution.setParent(this.getParent());
        this.loadedDynamicContribution.setWorkbenchWindow(this.getWorkbenchWindow());
        this.loadedDynamicContribution.setCurSide(this.getCurSide());
        if (this.loadedDynamicContribution instanceof IWorkbenchContribution) {
            ((IWorkbenchContribution)((Object)this.loadedDynamicContribution)).initialize(this.locator);
        }
    }

    public void dispose() {
        if (this.loadedDynamicContribution != null) {
            this.loadedDynamicContribution.dispose();
            this.loadedDynamicContribution = null;
        }
        super.dispose();
    }

    public void update() {
        if (this.loadedDynamicContribution != null) {
            this.loadedDynamicContribution.update();
        }
    }

    public void update(String string) {
        if (this.loadedDynamicContribution != null) {
            this.loadedDynamicContribution.update(string);
        }
    }

    public void setParent(IContributionManager iContributionManager) {
        super.setParent(iContributionManager);
        if (this.loadedDynamicContribution != null) {
            this.loadedDynamicContribution.setParent(iContributionManager);
        }
    }

    @Override
    public void setWorkbenchWindow(IWorkbenchWindow iWorkbenchWindow) {
        super.setWorkbenchWindow(iWorkbenchWindow);
        if (this.loadedDynamicContribution != null) {
            this.loadedDynamicContribution.setWorkbenchWindow(iWorkbenchWindow);
        }
    }

    @Override
    public void setCurSide(int n) {
        super.setCurSide(n);
        if (this.loadedDynamicContribution != null) {
            this.loadedDynamicContribution.setCurSide(n);
        }
    }

    public Control createControl(Composite composite) {
        WorkbenchWindowControlContribution workbenchWindowControlContribution = this.getContributionItem();
        if (workbenchWindowControlContribution != null) {
            return workbenchWindowControlContribution.delegateCreateControl(composite);
        }
        return null;
    }
}

