/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.menus;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;

public class DynamicMenuContributionItem
extends ContributionItem {
    private final IConfigurationElement dynamicAddition;
    private final IServiceLocator locator;
    private boolean alreadyFailed;
    private ContributionItem loadedDynamicContribution;

    public DynamicMenuContributionItem(String string, IServiceLocator iServiceLocator, IConfigurationElement iConfigurationElement) {
        super(string);
        this.locator = iServiceLocator;
        this.dynamicAddition = iConfigurationElement;
    }

    public boolean isDynamic() {
        if (this.loadedDynamicContribution != null) {
            return this.loadedDynamicContribution.isDynamic();
        }
        return true;
    }

    public boolean isDirty() {
        if (this.loadedDynamicContribution != null) {
            return this.loadedDynamicContribution.isDirty();
        }
        return super.isDirty();
    }

    public boolean isEnabled() {
        if (this.loadedDynamicContribution != null) {
            return this.loadedDynamicContribution.isEnabled();
        }
        return super.isEnabled();
    }

    public boolean isGroupMarker() {
        if (this.loadedDynamicContribution != null) {
            return this.loadedDynamicContribution.isGroupMarker();
        }
        return super.isGroupMarker();
    }

    public boolean isSeparator() {
        if (this.loadedDynamicContribution != null) {
            return this.loadedDynamicContribution.isSeparator();
        }
        return super.isSeparator();
    }

    public boolean isVisible() {
        if (this.loadedDynamicContribution != null) {
            return this.loadedDynamicContribution.isVisible();
        }
        return super.isVisible();
    }

    public void saveWidgetState() {
        if (this.loadedDynamicContribution != null) {
            this.loadedDynamicContribution.saveWidgetState();
        }
        super.saveWidgetState();
    }

    public void setVisible(boolean bl) {
        if (this.loadedDynamicContribution != null) {
            this.loadedDynamicContribution.setVisible(bl);
        }
        super.setVisible(bl);
    }

    public void fill(Composite composite) {
        IContributionItem iContributionItem = this.getContributionItem();
        if (iContributionItem != null) {
            iContributionItem.fill(composite);
        }
    }

    public void fill(CoolBar coolBar, int n) {
        IContributionItem iContributionItem = this.getContributionItem();
        if (iContributionItem != null) {
            iContributionItem.fill(coolBar, n);
        }
    }

    public void fill(Menu menu, int n) {
        IContributionItem iContributionItem = this.getContributionItem();
        if (iContributionItem != null) {
            iContributionItem.fill(menu, n);
        }
    }

    public void fill(ToolBar toolBar, int n) {
        IContributionItem iContributionItem = this.getContributionItem();
        if (iContributionItem != null) {
            iContributionItem.fill(toolBar, n);
        }
    }

    private IContributionItem getContributionItem() {
        if (this.loadedDynamicContribution == null && !this.alreadyFailed) {
            this.createContributionItem();
        }
        return this.loadedDynamicContribution;
    }

    private void createContributionItem() {
        this.loadedDynamicContribution = (ContributionItem)Util.safeLoadExecutableExtension(this.dynamicAddition, "class", ContributionItem.class);
        if (this.loadedDynamicContribution == null) {
            this.alreadyFailed = true;
            return;
        }
        this.loadedDynamicContribution.setId(this.getId());
        this.loadedDynamicContribution.setParent(this.getParent());
        if (this.loadedDynamicContribution instanceof IWorkbenchContribution) {
            ((IWorkbenchContribution)this.loadedDynamicContribution).initialize(this.locator);
        }
    }

    public void dispose() {
        if (this.loadedDynamicContribution != null) {
            this.loadedDynamicContribution.dispose();
            this.loadedDynamicContribution = null;
        }
        super.dispose();
    }

    public void update() {
        if (this.loadedDynamicContribution != null) {
            this.loadedDynamicContribution.update();
        }
    }

    public void update(String string) {
        if (this.loadedDynamicContribution != null) {
            this.loadedDynamicContribution.update(string);
        }
    }

    public void setParent(IContributionManager iContributionManager) {
        super.setParent(iContributionManager);
        if (this.loadedDynamicContribution != null) {
            this.loadedDynamicContribution.setParent(iContributionManager);
        }
    }
}

