/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.menus;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.expressions.Expression;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.ui.internal.expressions.AlwaysEnabledExpression;
import org.eclipse.ui.internal.menus.InternalMenuService;
import org.eclipse.ui.menus.AbstractContributionFactory;
import org.eclipse.ui.menus.IContributionRoot;

final class ContributionRoot
implements IContributionRoot {
    private List topLevelItems = new ArrayList();
    private List itemsToExpressions = new ArrayList();
    private InternalMenuService menuService;
    Set restriction;
    private ContributionManager mgr;
    private AbstractContributionFactory factory;

    public ContributionRoot(InternalMenuService internalMenuService, Set set, ContributionManager contributionManager, AbstractContributionFactory abstractContributionFactory) {
        this.menuService = internalMenuService;
        this.restriction = set;
        this.mgr = contributionManager;
        this.factory = abstractContributionFactory;
    }

    @Override
    public void addContributionItem(IContributionItem iContributionItem, Expression expression) {
        if (iContributionItem == null) {
            throw new IllegalArgumentException();
        }
        this.topLevelItems.add(iContributionItem);
        if (expression == null) {
            expression = AlwaysEnabledExpression.INSTANCE;
        }
        this.menuService.registerVisibleWhen(iContributionItem, expression, this.restriction, this.createIdentifierId(iContributionItem));
        this.itemsToExpressions.add(iContributionItem);
    }

    private String createIdentifierId(IContributionItem iContributionItem) {
        String string = this.factory.getNamespace();
        String string2 = string != null ? String.valueOf(string) + '/' + iContributionItem.getId() : null;
        return string2;
    }

    public List getItems() {
        return this.topLevelItems;
    }

    public void release() {
        for (IContributionItem iContributionItem : this.itemsToExpressions) {
            this.menuService.unregisterVisibleWhen(iContributionItem, this.restriction);
            iContributionItem.dispose();
        }
    }

    @Override
    public void registerVisibilityForChild(IContributionItem iContributionItem, Expression expression) {
        if (iContributionItem == null) {
            throw new IllegalArgumentException();
        }
        if (expression == null) {
            expression = AlwaysEnabledExpression.INSTANCE;
        }
        this.menuService.registerVisibleWhen(iContributionItem, expression, this.restriction, this.createIdentifierId(iContributionItem));
        this.itemsToExpressions.add(iContributionItem);
    }

    public ContributionManager getManager() {
        return this.mgr;
    }
}

