/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.layout;

import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.internal.IChangeListener;
import org.eclipse.ui.internal.IntModel;
import org.eclipse.ui.internal.RadioMenu;
import org.eclipse.ui.internal.TrimFrame;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.dnd.DragUtil;
import org.eclipse.ui.internal.layout.IWindowTrim;
import org.eclipse.ui.internal.layout.LayoutUtil;
import org.eclipse.ui.internal.layout.TrimLayout;
import org.eclipse.ui.presentations.PresentationUtil;

public abstract class TrimToolBarBase
implements IWindowTrim {
    protected String id;
    protected int orientation;
    protected WorkbenchWindow wbw;
    protected TrimLayout layout;
    protected ToolBarManager tbMgr = null;
    protected ToolItem contextToolItem = null;
    private TrimFrame frame = null;
    private CoolBar cb = null;
    private CoolItem ci = null;
    private MenuManager dockMenuManager;
    private ContributionItem dockContributionItem = null;
    private Menu sidesMenu;
    private MenuItem dockCascade;
    private RadioMenu radioButtons;
    private IntModel radioVal = new IntModel(0);
    private Listener tbListener = new Listener(){

        public void handleEvent(Event event) {
            Point point = new Point(event.x, event.y);
            if (event.type == 35) {
                TrimToolBarBase.this.showToolBarPopup(point);
            }
        }
    };
    private Listener cbListener = new Listener(){

        public void handleEvent(Event event) {
            Point point = new Point(event.x, event.y);
            if (event.type == 35) {
                TrimToolBarBase.this.showDockTrimPopup(point);
            }
        }
    };
    private Listener dragListener = new Listener(){

        public void handleEvent(Event event) {
            if (event.button != 3) {
                Point point = DragUtil.getEventLoc(event);
                TrimToolBarBase.this.startDraggingTrim(point);
            }
        }
    };

    protected TrimToolBarBase(String string, int n, WorkbenchWindow workbenchWindow) {
        this.id = string;
        this.wbw = workbenchWindow;
        this.layout = (TrimLayout)workbenchWindow.getTrimManager();
    }

    private void showToolBarPopup(Point point) {
        Point point2 = this.tbMgr.getControl().toControl(point);
        this.contextToolItem = this.tbMgr.getControl().getItem(point2);
        MenuManager menuManager = this.tbMgr.getContextMenuManager();
        if (menuManager != null) {
            Menu menu = menuManager.createContextMenu((Control)this.wbw.getShell());
            menu.setLocation(point.x, point.y);
            menu.setVisible(true);
        }
    }

    public abstract void initToolBarManager(ToolBarManager var1);

    public abstract void hookControl(ToolBarManager var1);

    private void createControl(int n) {
        this.dispose();
        this.radioVal.set(n);
        this.orientation = n == 16384 || n == 131072 ? 512 : 256;
        this.frame = new TrimFrame((Composite)this.wbw.getShell());
        this.cb = new CoolBar(this.frame.getComposite(), this.orientation | 0x800000);
        this.ci = new CoolItem(this.cb, 0x800000);
        this.tbMgr = new ToolBarManager(this.orientation | 0x800000);
        this.initToolBarManager(this.tbMgr);
        ToolBar toolBar = this.tbMgr.createControl((Composite)this.cb);
        this.ci.setControl((Control)toolBar);
        this.hookControl(this.tbMgr);
        this.update(true);
        Cursor cursor = this.getControl().getDisplay().getSystemCursor(5);
        this.cb.setCursor(cursor);
        Cursor cursor2 = this.getControl().getDisplay().getSystemCursor(0);
        toolBar.setCursor(cursor2);
        PresentationUtil.addDragListener((Control)this.cb, this.dragListener);
        this.dockMenuManager = new MenuManager();
        this.dockContributionItem = this.getDockingContribution();
        this.dockMenuManager.add((IContributionItem)this.dockContributionItem);
        toolBar.addListener(35, this.tbListener);
        this.cb.addListener(35, this.cbListener);
        this.cb.pack(true);
        this.cb.setVisible(true);
        this.tbMgr.getControl().setVisible(true);
        this.cb.setVisible(true);
        this.frame.getComposite().setVisible(true);
    }

    private void handleShowOnChange() {
        if (this.getControl() == null) {
            return;
        }
        this.layout.removeTrim(this);
        this.dock(this.radioVal.get());
        this.layout.addTrim(this.radioVal.get(), this, null);
        LayoutUtil.resize(this.getControl());
    }

    public void update(boolean bl) {
        this.tbMgr.update(bl);
        this.tbMgr.getControl().pack();
        Point point = this.tbMgr.getControl().getSize();
        Point point2 = this.ci.computeSize(point.x, point.y);
        this.ci.setPreferredSize(point2);
        this.ci.setSize(point2);
        this.cb.pack();
        this.cb.update();
        LayoutUtil.resize(this.getControl());
    }

    private ContributionItem getDockingContribution() {
        if (this.dockContributionItem == null) {
            this.dockContributionItem = new ContributionItem(){

                public void fill(Menu menu, int n) {
                    super.fill(menu, n);
                    if (TrimToolBarBase.this.isCloseable()) {
                        MenuItem menuItem = new MenuItem(menu, 8, n++);
                        menuItem.setText(WorkbenchMessages.TrimCommon_Close);
                        menuItem.addSelectionListener(new SelectionListener(){

                            public void widgetSelected(SelectionEvent selectionEvent) {
                                TrimToolBarBase.this.handleCloseTrim();
                            }

                            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                            }
                        });
                        new MenuItem(menu, 2, n++);
                    }
                    TrimToolBarBase.this.dockCascade = new MenuItem(menu, 64, n++);
                    TrimToolBarBase.this.dockCascade.setText(WorkbenchMessages.TrimCommon_DockOn);
                    TrimToolBarBase.this.sidesMenu = new Menu(TrimToolBarBase.this.dockCascade);
                    TrimToolBarBase.this.radioButtons = new RadioMenu(TrimToolBarBase.this.sidesMenu, TrimToolBarBase.this.radioVal);
                    TrimToolBarBase.this.radioButtons.addMenuItem(WorkbenchMessages.TrimCommon_Top, new Integer(128));
                    TrimToolBarBase.this.radioButtons.addMenuItem(WorkbenchMessages.TrimCommon_Bottom, new Integer(1024));
                    TrimToolBarBase.this.radioButtons.addMenuItem(WorkbenchMessages.TrimCommon_Left, new Integer(16384));
                    TrimToolBarBase.this.radioButtons.addMenuItem(WorkbenchMessages.TrimCommon_Right, new Integer(131072));
                    TrimToolBarBase.this.dockCascade.setMenu(TrimToolBarBase.this.sidesMenu);
                    TrimToolBarBase.this.radioVal.addChangeListener(new IChangeListener(){

                        @Override
                        public void update(boolean bl) {
                            if (bl) {
                                TrimToolBarBase.this.handleShowOnChange();
                            }
                        }
                    });
                }
            };
        }
        return this.dockContributionItem;
    }

    public int getCurrentSide() {
        return this.radioVal.get();
    }

    private void handleCloseTrim() {
        this.handleClose();
    }

    public void dispose() {
        if (this.getControl() == null || this.getControl().isDisposed()) {
            return;
        }
        if (this.radioButtons != null) {
            this.radioButtons.dispose();
        }
        this.getControl().removeListener(35, this.cbListener);
        this.tbMgr.dispose();
        this.tbMgr = null;
        this.getControl().dispose();
        this.frame = null;
    }

    private void startDraggingTrim(Point point) {
        Rectangle rectangle = new Rectangle(100000, 0, 0, 0);
        DragUtil.performDrag(this, rectangle, point, true);
    }

    private void showDockTrimPopup(Point point) {
        Menu menu = this.dockMenuManager.createContextMenu(this.getControl());
        menu.setLocation(point.x, point.y);
        menu.setVisible(true);
    }

    @Override
    public void dock(int n) {
        this.createControl(n);
    }

    @Override
    public Control getControl() {
        if (this.frame == null) {
            return null;
        }
        return this.frame.getComposite();
    }

    @Override
    public String getDisplayName() {
        return this.id;
    }

    @Override
    public int getHeightHint() {
        return this.getControl().computeSize((int)-1, (int)-1, (boolean)true).y;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public int getValidSides() {
        return 148608;
    }

    @Override
    public int getWidthHint() {
        return this.getControl().computeSize((int)-1, (int)-1, (boolean)true).x;
    }

    @Override
    public void handleClose() {
    }

    @Override
    public boolean isCloseable() {
        return false;
    }

    @Override
    public boolean isResizeable() {
        return false;
    }
}

