/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.layout;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.layout.ICachingLayout;
import org.eclipse.ui.internal.layout.ITrimManager;
import org.eclipse.ui.internal.layout.IWindowTrim;
import org.eclipse.ui.internal.layout.LayoutUtil;
import org.eclipse.ui.internal.layout.SizeCache;
import org.eclipse.ui.internal.layout.TrimArea;
import org.eclipse.ui.internal.layout.TrimCommonUIHandle;
import org.eclipse.ui.internal.layout.TrimDescriptor;
import org.eclipse.ui.internal.layout.TrimToolBarBase;

public class TrimLayout
extends Layout
implements ICachingLayout,
ITrimManager {
    public static final Integer TOP_ID = new Integer(128);
    public static final Integer BOTTOM_ID = new Integer(1024);
    public static final Integer LEFT_ID = new Integer(16384);
    public static final Integer RIGHT_ID = new Integer(131072);
    public static final Integer NONTRIM_ID = new Integer(-1);
    private static final int[] TRIM_ID_INFO = new int[]{16384, 131072, 128, 1024};
    private SizeCache centerArea = new SizeCache();
    private Map fTrimArea = new HashMap();
    private Map fTrimDescriptors = new HashMap();
    private boolean trimLocked;
    private HashMap preferredLocationMap = new HashMap();

    public TrimLayout() {
        IPreferenceStore iPreferenceStore = PlatformUI.getPreferenceStore();
        this.trimLocked = iPreferenceStore.getBoolean("LOCK_TRIM");
        this.createTrimArea(TOP_ID, TOP_ID.toString());
        this.createTrimArea(BOTTOM_ID, BOTTOM_ID.toString());
        this.createTrimArea(LEFT_ID, LEFT_ID.toString());
        this.createTrimArea(RIGHT_ID, RIGHT_ID.toString());
    }

    private void createTrimArea(Integer n, String string) {
        TrimArea trimArea = new TrimArea(n, string);
        this.fTrimArea.put(n, trimArea);
    }

    public int getTrimAreaId(Control control) {
        TrimDescriptor trimDescriptor = this.findTrimDescription(control);
        if (trimDescriptor != null) {
            return trimDescriptor.getAreaId();
        }
        return -1;
    }

    public void addTrim(IWindowTrim iWindowTrim, int n) {
        this.addTrim(n, iWindowTrim, null);
    }

    public void addTrim(IWindowTrim iWindowTrim, int n, IWindowTrim iWindowTrim2) {
        this.addTrim(n, iWindowTrim, iWindowTrim2);
    }

    @Override
    public void addTrim(int n, IWindowTrim iWindowTrim) {
        IWindowTrim iWindowTrim2 = null;
        List list = this.getAreaTrim(n);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IWindowTrim iWindowTrim3 = (IWindowTrim)iterator.next();
            if (!iWindowTrim3.getId().equals(iWindowTrim.getId()) || !iterator.hasNext()) continue;
            iWindowTrim2 = (IWindowTrim)iterator.next();
        }
        this.addTrim(n, iWindowTrim, iWindowTrim2);
    }

    @Override
    public void addTrim(int n, IWindowTrim iWindowTrim, IWindowTrim iWindowTrim2) {
        Object object;
        TrimArea trimArea = (TrimArea)this.fTrimArea.get(new Integer(n));
        if (trimArea == null) {
            return;
        }
        this.removeTrim(iWindowTrim);
        TrimDescriptor trimDescriptor = new TrimDescriptor(iWindowTrim, n);
        boolean bl = iWindowTrim instanceof TrimToolBarBase;
        if (!this.trimLocked && iWindowTrim.getValidSides() != 0 && !bl) {
            object = new TrimCommonUIHandle(this, iWindowTrim, n);
            trimDescriptor.setDockingCache(new SizeCache((Control)object));
        }
        object = new SizeCache(iWindowTrim.getControl());
        iWindowTrim.getControl().setLayoutData((Object)iWindowTrim);
        trimDescriptor.setCache((SizeCache)object);
        iWindowTrim.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                Control control = (Control)disposeEvent.widget;
                if (control.getLayoutData() instanceof IWindowTrim) {
                    IWindowTrim iWindowTrim = (IWindowTrim)control.getLayoutData();
                    TrimLayout.this.removeTrim(iWindowTrim);
                }
            }
        });
        this.fTrimDescriptors.put(trimDescriptor.getId(), trimDescriptor);
        if (iWindowTrim2 != null) {
            TrimDescriptor trimDescriptor2 = (TrimDescriptor)this.fTrimDescriptors.get(iWindowTrim2.getId());
            if (trimDescriptor2 != null && trimDescriptor2.getAreaId() == n) {
                trimArea.addTrim(trimDescriptor, trimDescriptor2);
            } else {
                trimArea.addTrim(trimDescriptor);
            }
        } else {
            trimArea.addTrim(trimDescriptor);
        }
    }

    @Override
    public void forceLayout() {
        this.removeDisposed();
        for (TrimDescriptor trimDescriptor : this.fTrimDescriptors.values()) {
            if (trimDescriptor.getTrim().getControl() == null) continue;
            LayoutUtil.resize(trimDescriptor.getTrim().getControl());
            return;
        }
    }

    @Override
    public void removeTrim(IWindowTrim iWindowTrim) {
        TrimDescriptor trimDescriptor = (TrimDescriptor)this.fTrimDescriptors.remove(iWindowTrim.getId());
        if (trimDescriptor == null) {
            return;
        }
        TrimArea trimArea = (TrimArea)this.fTrimArea.get(new Integer(trimDescriptor.getAreaId()));
        if (trimArea != null) {
            trimArea.removeTrim(trimDescriptor);
            trimDescriptor.getCache().getControl().setLayoutData(null);
        }
        if (trimDescriptor.getDockingCache() != null) {
            Control control = trimDescriptor.getDockingCache().getControl();
            control.setVisible(false);
            trimDescriptor.setDockingCache(null);
        }
    }

    @Override
    public IWindowTrim getTrim(String string) {
        TrimDescriptor trimDescriptor = (TrimDescriptor)this.fTrimDescriptors.get(string);
        if (trimDescriptor != null) {
            return trimDescriptor.getTrim();
        }
        return null;
    }

    private void removeDisposed() {
        for (TrimArea trimArea : this.fTrimArea.values()) {
            for (TrimDescriptor trimDescriptor : trimArea.getDescriptors()) {
                Control control = trimDescriptor.getTrim().getControl();
                if (control != null && !control.isDisposed()) continue;
                trimArea.removeTrim(trimDescriptor);
                this.fTrimDescriptors.remove(trimDescriptor.getId());
            }
        }
    }

    protected Point computeSize(Composite composite, int n, int n2, boolean bl) {
        return new Point(0, 0);
    }

    protected void layout(Composite composite, boolean bl) {
        this.removeDisposed();
        TrimArea trimArea = (TrimArea)this.fTrimArea.get(TOP_ID);
        TrimArea trimArea2 = (TrimArea)this.fTrimArea.get(BOTTOM_ID);
        TrimArea trimArea3 = (TrimArea)this.fTrimArea.get(LEFT_ID);
        TrimArea trimArea4 = (TrimArea)this.fTrimArea.get(RIGHT_ID);
        Rectangle rectangle = composite.getClientArea();
        int n = trimArea.computeWrappedTrim(rectangle.width);
        int n2 = trimArea2.computeWrappedTrim(rectangle.width);
        int n3 = rectangle.height - (n + n2);
        int n4 = trimArea3.computeWrappedTrim(n3);
        int n5 = trimArea4.computeWrappedTrim(n3);
        trimArea.tileTrim(rectangle.x, rectangle.y, rectangle.width);
        trimArea2.tileTrim(rectangle.x, rectangle.height - n2, rectangle.width);
        trimArea3.tileTrim(rectangle.x, rectangle.y + n, n3);
        trimArea4.tileTrim(rectangle.width - n5, rectangle.y + n, n3);
        if (this.centerArea.getControl() != null) {
            Control control = this.centerArea.getControl();
            control.setBounds(rectangle.x + n4, rectangle.y + n, rectangle.width - (n4 + n5), rectangle.height - (n + n2));
        }
    }

    public void setCenterControl(Control control) {
        this.centerArea.setControl(control);
    }

    public Control getCenterControl() {
        return this.centerArea.getControl();
    }

    @Override
    public void flush(Control control) {
        if (control == this.centerArea.getControl()) {
            this.centerArea.flush();
        } else {
            TrimDescriptor trimDescriptor = this.findTrimDescription(control);
            if (trimDescriptor != null) {
                trimDescriptor.flush();
            }
        }
    }

    @Override
    public int[] getAreaIds() {
        return (int[])TRIM_ID_INFO.clone();
    }

    @Override
    public List getAreaTrim(int n) {
        TrimArea trimArea = (TrimArea)this.fTrimArea.get(new Integer(n));
        if (trimArea == null) {
            return Collections.EMPTY_LIST;
        }
        return trimArea.getTrims();
    }

    @Override
    public void updateAreaTrim(int n, List list, boolean bl) {
        TrimArea trimArea = (TrimArea)this.fTrimArea.get(new Integer(n));
        if (trimArea == null) {
            return;
        }
        List list2 = trimArea.getTrims();
        for (IWindowTrim iWindowTrim : list) {
            iWindowTrim.dock(n);
            this.addTrim(n, iWindowTrim, null);
            list2.remove(iWindowTrim);
        }
        if (bl) {
            for (IWindowTrim iWindowTrim : list2) {
                this.removeTrim(iWindowTrim);
            }
        }
    }

    public Rectangle getTrimRect(Composite composite, int n) {
        TrimArea trimArea = this.getTrimArea(n);
        return composite.getDisplay().map((Control)composite, null, trimArea.getCurRect());
    }

    @Override
    public List getAllTrim() {
        ArrayList<IWindowTrim> arrayList = new ArrayList<IWindowTrim>(this.fTrimDescriptors.size());
        for (TrimDescriptor trimDescriptor : this.fTrimDescriptors.values()) {
            arrayList.add(trimDescriptor.getTrim());
        }
        return arrayList;
    }

    @Override
    public void setTrimVisible(IWindowTrim iWindowTrim, boolean bl) {
        TrimDescriptor trimDescriptor = this.findTrimDescription(iWindowTrim.getControl());
        if (trimDescriptor != null) {
            trimDescriptor.setVisible(bl);
        }
    }

    private TrimDescriptor findTrimDescription(Control control) {
        for (TrimDescriptor trimDescriptor : this.fTrimDescriptors.values()) {
            if (trimDescriptor.getTrim().getControl() == control) {
                return trimDescriptor;
            }
            if (trimDescriptor.getDockingCache() == null || trimDescriptor.getDockingCache().getControl() != control) continue;
            return trimDescriptor;
        }
        return null;
    }

    public TrimArea getTrimArea(int n) {
        return (TrimArea)this.fTrimArea.get(new Integer(n));
    }

    public void setPreferredLocations(int n, List list) {
        this.preferredLocationMap.put(new Integer(n), list);
    }

    public int getPreferredArea(String string) {
        for (Integer n : this.preferredLocationMap.keySet()) {
            List list = (List)this.preferredLocationMap.get(n);
            if (!list.contains(string)) continue;
            return n;
        }
        return -1;
    }

    public IWindowTrim getPreferredLocation(String string) {
        for (Integer n : this.preferredLocationMap.keySet()) {
            List list = (List)this.preferredLocationMap.get(n);
            int n2 = list.indexOf(string);
            if (n2 == -1) continue;
            int n3 = n2 + 1;
            while (n3 < list.size()) {
                String string2 = (String)list.get(n3);
                IWindowTrim iWindowTrim = this.getTrim(string2);
                if (iWindowTrim != null) {
                    return iWindowTrim;
                }
                ++n3;
            }
        }
        return null;
    }

    public List disableTrim(IWindowTrim iWindowTrim) {
        ArrayList<Control> arrayList = new ArrayList<Control>();
        List list = this.getAllTrim();
        for (IWindowTrim iWindowTrim2 : list) {
            Control control;
            if (iWindowTrim == iWindowTrim2 || (control = iWindowTrim2.getControl()) == null || control.isDisposed() || !control.isVisible() || !control.isEnabled()) continue;
            control.setEnabled(false);
            arrayList.add(control);
        }
        return arrayList;
    }

    public void enableTrim(List list) {
        for (Control control : list) {
            if (control.isDisposed() || control.isEnabled()) continue;
            control.setEnabled(true);
        }
    }
}

