/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.layout;

import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.internal.IChangeListener;
import org.eclipse.ui.internal.IntModel;
import org.eclipse.ui.internal.RadioMenu;
import org.eclipse.ui.internal.WindowTrimProxy;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dnd.DragUtil;
import org.eclipse.ui.internal.layout.IWindowTrim;
import org.eclipse.ui.internal.layout.LayoutUtil;
import org.eclipse.ui.internal.layout.TrimLayout;
import org.eclipse.ui.presentations.PresentationUtil;

public class TrimCommonUIHandle
extends Composite {
    private TrimLayout layout;
    private IWindowTrim trim;
    private Control toDrag;
    private int orientation;
    private CoolBar cb = null;
    private CoolItem ci = null;
    private static int horizontalHandleSize = -1;
    private static int verticalHandleSize = -1;
    private MenuManager dockMenuManager;
    private ContributionItem dockContributionItem = null;
    private Menu sidesMenu;
    private MenuItem dockCascade;
    private RadioMenu radioButtons;
    private IntModel radioVal = new IntModel(0);
    private Listener dragListener = new Listener(){

        public void handleEvent(Event event) {
            if (event.button != 3) {
                Point point = DragUtil.getEventLoc(event);
                TrimCommonUIHandle.this.startDraggingTrim(point);
            }
        }
    };
    private Listener menuListener = new Listener(){

        public void handleEvent(Event event) {
            Point point = new Point(event.x, event.y);
            if (event.type == 35) {
                TrimCommonUIHandle.this.showDockTrimPopup(point);
            }
        }
    };
    private ControlListener controlListener = new ControlListener(){

        public void controlMoved(ControlEvent controlEvent) {
        }

        public void controlResized(ControlEvent controlEvent) {
            if (controlEvent.widget instanceof TrimCommonUIHandle) {
                TrimCommonUIHandle trimCommonUIHandle = (TrimCommonUIHandle)controlEvent.widget;
                Point point = trimCommonUIHandle.getSize();
                TrimCommonUIHandle.this.cb.setSize(point);
                TrimCommonUIHandle.this.ci.setSize(point);
                TrimCommonUIHandle.this.ci.setPreferredSize(point);
                TrimCommonUIHandle.this.cb.layout(true);
            }
        }
    };

    public TrimCommonUIHandle(TrimLayout trimLayout, IWindowTrim iWindowTrim, int n) {
        super(iWindowTrim.getControl().getParent(), 0);
        this.setup(trimLayout, iWindowTrim, n);
        this.addControlListener(this.controlListener);
    }

    public void setup(TrimLayout trimLayout, IWindowTrim iWindowTrim, int n) {
        this.layout = trimLayout;
        this.trim = iWindowTrim;
        this.toDrag = iWindowTrim.getControl();
        this.radioVal.set(n);
        this.orientation = n == 16384 || n == 131072 ? 512 : 256;
        this.insertCoolBar(this.orientation);
        this.createWindowTrimProxy();
        this.setDragCursor();
        PresentationUtil.addDragListener((Control)this.cb, this.dragListener);
        this.dockMenuManager = new MenuManager();
        this.dockContributionItem = this.getDockingContribution();
        this.dockMenuManager.add((IContributionItem)this.dockContributionItem);
        this.cb.addListener(35, this.menuListener);
        this.setVisible(true);
    }

    private void handleShowOnChange() {
        this.layout.removeTrim(this.trim);
        this.trim.dock(this.radioVal.get());
        this.layout.addTrim(this.radioVal.get(), this.trim, null);
        LayoutUtil.resize(this.trim.getControl());
    }

    private void createWindowTrimProxy() {
        WindowTrimProxy windowTrimProxy = new WindowTrimProxy((Control)this, "NONE", "NONE", 148608, false);
        if (this.orientation == 256) {
            windowTrimProxy.setWidthHint(this.getHandleSize());
            windowTrimProxy.setHeightHint(0);
        } else {
            windowTrimProxy.setWidthHint(0);
            windowTrimProxy.setHeightHint(this.getHandleSize());
        }
        this.setLayoutData(windowTrimProxy);
    }

    private int getHandleSize() {
        int n;
        if (this.orientation == 256 && horizontalHandleSize != -1) {
            return horizontalHandleSize;
        }
        if (this.orientation == 512 && verticalHandleSize != -1) {
            return verticalHandleSize;
        }
        CoolBar coolBar = new CoolBar(this.trim.getControl().getParent(), this.orientation);
        CoolItem coolItem = new CoolItem(coolBar, 0);
        Label label = new Label((Composite)coolBar, 8);
        label.setText("Button 1");
        Point point = label.computeSize(-1, -1);
        Point point2 = coolItem.computeSize(point.x, point.y);
        coolItem.setPreferredSize(point2);
        coolItem.setControl((Control)label);
        coolBar.pack();
        Point point3 = label.getLocation();
        Point point4 = coolBar.getLocation();
        label.dispose();
        coolItem.dispose();
        coolBar.dispose();
        if (this.orientation == 256) {
            horizontalHandleSize = n = point3.x - point4.x;
        } else {
            verticalHandleSize = n = point3.y - point4.y;
        }
        return n;
    }

    public void insertCoolBar(int n) {
        if (this.cb != null) {
            this.ci.dispose();
            PresentationUtil.removeDragListener((Control)this.cb, this.dragListener);
            this.cb.dispose();
        }
        this.cb = new CoolBar((Composite)this, n | 0x800000);
        this.cb.setLocation(0, 0);
        this.ci = new CoolItem(this.cb, 0x800000);
        Composite composite = new Composite((Composite)this.cb, 0);
        this.ci.setControl((Control)composite);
    }

    private void setDragCursor() {
        Cursor cursor = this.toDrag.getDisplay().getSystemCursor(5);
        this.setCursor(cursor);
    }

    public Point computeSize(int n, int n2, boolean bl) {
        Point point = this.trim.getControl().computeSize(n, n2);
        if (this.orientation == 256) {
            return new Point(this.getHandleSize(), point.y);
        }
        return new Point(point.x, this.getHandleSize());
    }

    public ContributionItem getDockingContribution() {
        if (this.dockContributionItem == null) {
            this.dockContributionItem = new ContributionItem(){

                public void fill(Menu menu, int n) {
                    super.fill(menu, n);
                    if (TrimCommonUIHandle.this.trim.isCloseable()) {
                        MenuItem menuItem = new MenuItem(menu, 8, n++);
                        menuItem.setText(WorkbenchMessages.TrimCommon_Close);
                        menuItem.addSelectionListener(new SelectionListener(){

                            public void widgetSelected(SelectionEvent selectionEvent) {
                                TrimCommonUIHandle.this.handleCloseTrim();
                            }

                            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                            }
                        });
                        new MenuItem(menu, 2, n++);
                    }
                    TrimCommonUIHandle.this.dockCascade = new MenuItem(menu, 64, n++);
                    TrimCommonUIHandle.this.dockCascade.setText(WorkbenchMessages.TrimCommon_DockOn);
                    TrimCommonUIHandle.this.sidesMenu = new Menu(TrimCommonUIHandle.this.dockCascade);
                    TrimCommonUIHandle.this.radioButtons = new RadioMenu(TrimCommonUIHandle.this.sidesMenu, TrimCommonUIHandle.this.radioVal);
                    TrimCommonUIHandle.this.radioButtons.addMenuItem(WorkbenchMessages.TrimCommon_Top, new Integer(128));
                    TrimCommonUIHandle.this.radioButtons.addMenuItem(WorkbenchMessages.TrimCommon_Bottom, new Integer(1024));
                    TrimCommonUIHandle.this.radioButtons.addMenuItem(WorkbenchMessages.TrimCommon_Left, new Integer(16384));
                    TrimCommonUIHandle.this.radioButtons.addMenuItem(WorkbenchMessages.TrimCommon_Right, new Integer(131072));
                    TrimCommonUIHandle.this.dockCascade.setMenu(TrimCommonUIHandle.this.sidesMenu);
                    TrimCommonUIHandle.this.radioVal.addChangeListener(new IChangeListener(){

                        @Override
                        public void update(boolean bl) {
                            if (bl) {
                                TrimCommonUIHandle.this.handleShowOnChange();
                            }
                        }
                    });
                }
            };
        }
        return this.dockContributionItem;
    }

    private void handleCloseTrim() {
        this.layout.removeTrim(this.trim);
        this.trim.handleClose();
    }

    public void dispose() {
        if (this.radioButtons != null) {
            this.radioButtons.dispose();
        }
        this.removeControlListener(this.controlListener);
        this.removeListener(35, this.menuListener);
        super.dispose();
    }

    protected void startDraggingTrim(Point point) {
        Rectangle rectangle = new Rectangle(100000, 0, 0, 0);
        DragUtil.performDrag(this.trim, rectangle, point, true);
    }

    private void showDockTrimPopup(Point point) {
        Menu menu = this.dockMenuManager.createContextMenu(this.toDrag);
        menu.setLocation(point.x, point.y);
        menu.setVisible(true);
    }
}

