/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.layout;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.swt.custom.CBanner;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.internal.WindowTrimProxy;
import org.eclipse.ui.internal.layout.IWindowTrim;
import org.eclipse.ui.internal.layout.SizeCache;
import org.eclipse.ui.internal.layout.TrimCommonUIHandle;
import org.eclipse.ui.internal.layout.TrimDescriptor;

public class TrimArea {
    private static final IWindowTrim defaultData = new WindowTrimProxy(null, null, null, 0, true);
    private int fId;
    private String fDisplayName;
    private List lines = new ArrayList();
    private ArrayList fTrim;
    private static final String PREFSIZE_DATA_ID = "prefSize";
    private static final int MIN_BANNER_LEFT = 150;
    private static int TILE_SPACING = 2;
    private static int LINE_SPACING = 2;
    private Rectangle curRect = new Rectangle(0, 0, 0, 0);
    static int tileCount = 0;

    private static IWindowTrim getData(Control control) {
        IWindowTrim iWindowTrim = (IWindowTrim)control.getLayoutData();
        if (iWindowTrim == null) {
            iWindowTrim = defaultData;
        }
        return iWindowTrim;
    }

    public TrimArea(int n, String string) {
        this.fTrim = new ArrayList();
        this.fId = n;
        this.fDisplayName = string;
    }

    public boolean isEmpty() {
        return this.fTrim.isEmpty();
    }

    public Rectangle getCurRect() {
        return this.curRect;
    }

    public List getTrims() {
        ArrayList<IWindowTrim> arrayList = new ArrayList<IWindowTrim>(this.fTrim.size());
        for (TrimDescriptor trimDescriptor : this.fTrim) {
            arrayList.add(trimDescriptor.getTrim());
        }
        return arrayList;
    }

    public List getDescriptors() {
        return (List)this.fTrim.clone();
    }

    private Point getPrefSize(Control control) {
        Point point = control.getSize();
        if (!(point.x != 0 && point.y != 0 || TrimArea.getData(control).isResizeable())) {
            point = control.computeSize(-1, -1);
            control.setSize(point);
        }
        if (TrimArea.getData(control).isResizeable()) {
            if (control instanceof CBanner) {
                CBanner cBanner = (CBanner)control;
                point.x = cBanner.getRightWidth() + cBanner.getBorderWidth() + 150;
                point.y = 0;
            } else {
                point = TrimArea.getData(control).getId().equals("org.eclipse.jface.action.StatusLineManager") ? new Point(250, 26) : control.computeSize(-1, -1);
            }
            control.setData(PREFSIZE_DATA_ID, (Object)point);
        }
        return point;
    }

    public int computeWrappedTrim(int n) {
        int n2 = 0;
        this.lines.clear();
        boolean bl = !this.isVertical();
        TrimLine trimLine = new TrimLine(n);
        this.lines.add(trimLine);
        TrimCommonUIHandle trimCommonUIHandle = null;
        List list = this.getCaches();
        for (SizeCache sizeCache : list) {
            int n3;
            Point point;
            Control control = sizeCache.getControl();
            if (control == null || !control.getVisible()) continue;
            if (control instanceof TrimCommonUIHandle) {
                trimCommonUIHandle = (TrimCommonUIHandle)control;
                point = trimCommonUIHandle.getSize();
                if (point.x != 0 && point.y != 0) continue;
                trimCommonUIHandle.setSize(trimCommonUIHandle.computeSize(-1, -1));
                continue;
            }
            point = this.getPrefSize(control);
            int n4 = bl ? point.x : point.y;
            int n5 = n3 = bl ? point.y : point.x;
            if (trimCommonUIHandle != null) {
                Point point2 = trimCommonUIHandle.getSize();
                n4 += bl ? point2.x : point2.y;
            }
            if ((n4 += TILE_SPACING) < trimLine.availableSpace || trimLine.controls.size() == 0) {
                trimLine.addControl(control, n4, n3, (Control)trimCommonUIHandle);
            } else {
                n2 += trimLine.terminate();
                trimLine = new TrimLine(n);
                this.lines.add(trimLine);
                trimLine.addControl(control, n4, n3, (Control)trimCommonUIHandle);
            }
            trimCommonUIHandle = null;
        }
        n2 += trimLine.terminate();
        return n2 += (this.lines.size() + 1) * LINE_SPACING;
    }

    public void tileTrim(int n, int n2, int n3) {
        this.curRect.x = n;
        this.curRect.y = n2;
        boolean bl = !this.isVertical();
        int n4 = n;
        int n5 = n2;
        if (bl) {
            n4 += TILE_SPACING;
            n5 += LINE_SPACING;
        } else {
            n5 += TILE_SPACING;
            n4 += LINE_SPACING;
        }
        for (TrimLine trimLine : this.lines) {
            int n6 = trimLine.availableSpace;
            int n7 = trimLine.resizableCount;
            for (Control control : trimLine.controls) {
                Point point = control.getSize();
                if (TrimArea.getData(control).isResizeable() && n7 > 0) {
                    Point point2 = (Point)control.getData(PREFSIZE_DATA_ID);
                    point.x = point2.x;
                    point.y = point2.y;
                    int n8 = n6 / n7;
                    if (bl) {
                        point.x += n8;
                    } else {
                        point.y += n8;
                    }
                    n6 -= n8;
                    --n7;
                    control.setSize(point);
                }
                control.setLocation(n4, n5);
                if (bl) {
                    n4 += point.x;
                } else {
                    n5 += point.y;
                }
                if (control instanceof TrimCommonUIHandle) continue;
                if (bl) {
                    n4 += TILE_SPACING;
                    continue;
                }
                n5 += TILE_SPACING;
            }
            if (bl) {
                n5 += trimLine.minorMax + LINE_SPACING;
                n4 = n + TILE_SPACING;
                continue;
            }
            n4 += trimLine.minorMax + LINE_SPACING;
            n5 = n2 + TILE_SPACING;
        }
        if (bl) {
            this.curRect.width = n3;
            this.curRect.height = n5 - n2;
        } else {
            this.curRect.width = n4 - n;
            this.curRect.height = n3;
        }
    }

    public boolean isVertical() {
        return this.fId == 16384 || this.fId == 131072;
    }

    public int getId() {
        return this.fId;
    }

    public String getDisplayName() {
        return this.fDisplayName;
    }

    public void addTrim(TrimDescriptor trimDescriptor) {
        this.fTrim.add(trimDescriptor);
    }

    public void addTrim(TrimDescriptor trimDescriptor, TrimDescriptor trimDescriptor2) {
        int n = this.fTrim.indexOf(trimDescriptor2);
        if (n == -1) {
            this.fTrim.add(trimDescriptor);
        } else {
            ListIterator<TrimDescriptor> listIterator = this.fTrim.listIterator(n);
            listIterator.add(trimDescriptor);
        }
    }

    public void removeTrim(TrimDescriptor trimDescriptor) {
        this.fTrim.remove(trimDescriptor);
    }

    public boolean contains(TrimDescriptor trimDescriptor) {
        return this.fTrim.contains(trimDescriptor);
    }

    public List getCaches() {
        ArrayList<SizeCache> arrayList = new ArrayList<SizeCache>(this.fTrim.size());
        for (TrimDescriptor trimDescriptor : this.fTrim) {
            if (trimDescriptor.getDockingCache() != null) {
                arrayList.add(trimDescriptor.getDockingCache());
            }
            arrayList.add(trimDescriptor.getCache());
        }
        return arrayList;
    }

    private class TrimLine {
        List controls = new ArrayList();
        int minorMax;
        int resizableCount;
        int availableSpace;

        public TrimLine(int n) {
            this.availableSpace = n;
        }

        void addControl(Control control, int n, int n2, Control control2) {
            if (control2 != null) {
                this.controls.add(control2);
            }
            this.controls.add(control);
            if (TrimArea.getData(control).isResizeable()) {
                ++this.resizableCount;
            }
            if (n2 > this.minorMax) {
                this.minorMax = n2;
            }
            this.availableSpace -= n;
        }

        int terminate() {
            for (Control control : this.controls) {
                if (!(control instanceof CBanner)) continue;
                CBanner cBanner = (CBanner)control;
                Point point = (Point)cBanner.getData(TrimArea.PREFSIZE_DATA_ID);
                int n = point.x + this.availableSpace / this.resizableCount;
                Point point2 = cBanner.computeSize(n, -1);
                cBanner.setData(TrimArea.PREFSIZE_DATA_ID, (Object)new Point(point.x, point2.y));
                if (point2.y <= this.minorMax) continue;
                this.minorMax = point2.y;
            }
            return this.minorMax;
        }
    }
}

