/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.layout;

import java.util.List;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;

public class SizeCache {
    private Control control;
    private Point preferredSize;
    private Point cachedWidth;
    private Point cachedHeight;
    private boolean flushChildren;
    private boolean independentDimensions = false;
    private boolean preferredWidthOrLargerIsMinimumHeight = false;
    private int widthAdjustment = 0;
    private int heightAdjustment = 0;

    public SizeCache() {
        this(null);
    }

    public SizeCache(Control control) {
        this.setControl(control);
    }

    public void setControl(Control control) {
        if (control != this.control) {
            this.control = control;
            if (this.control == null) {
                this.independentDimensions = true;
                this.preferredWidthOrLargerIsMinimumHeight = false;
                this.widthAdjustment = 0;
                this.heightAdjustment = 0;
            } else {
                this.independentDimensions = SizeCache.independentLengthAndWidth(this.control);
                this.preferredWidthOrLargerIsMinimumHeight = SizeCache.isPreferredWidthMaximum(this.control);
                this.computeHintOffset(this.control);
                this.flush();
            }
        }
    }

    public Control getControl() {
        return this.control;
    }

    public void flush() {
        this.flush(true);
    }

    public void flush(boolean bl) {
        this.preferredSize = null;
        this.cachedWidth = null;
        this.cachedHeight = null;
        this.flushChildren = bl;
    }

    private Point getPreferredSize() {
        if (this.preferredSize == null) {
            this.preferredSize = this.computeSize(this.control, -1, -1);
        }
        return this.preferredSize;
    }

    public Point computeSize(int n, int n2) {
        if (this.control == null) {
            return new Point(0, 0);
        }
        if (n != -1 && n2 != -1) {
            return new Point(n, n2);
        }
        if (n == -1 && n2 == -1) {
            return Geometry.copy((Point)this.getPreferredSize());
        }
        if (this.independentDimensions) {
            Point point = Geometry.copy((Point)this.getPreferredSize());
            if (n != -1) {
                point.x = n;
            }
            if (n2 != -1) {
                point.y = n2;
            }
            return point;
        }
        if (n2 == -1) {
            if (this.preferredSize != null && n == this.preferredSize.x) {
                return Geometry.copy((Point)this.preferredSize);
            }
            if (this.cachedHeight != null && this.cachedHeight.x == n) {
                return Geometry.copy((Point)this.cachedHeight);
            }
            if (this.preferredWidthOrLargerIsMinimumHeight) {
                this.getPreferredSize();
                if (n >= this.preferredSize.x) {
                    Point point = Geometry.copy((Point)this.preferredSize);
                    point.x = n;
                    return point;
                }
            }
            this.cachedHeight = this.computeSize(this.control, n, n2);
            return Geometry.copy((Point)this.cachedHeight);
        }
        if (n == -1) {
            if (this.preferredSize != null && n2 == this.preferredSize.y) {
                return Geometry.copy((Point)this.preferredSize);
            }
            if (this.cachedWidth != null && this.cachedWidth.y == n2) {
                return Geometry.copy((Point)this.cachedWidth);
            }
            this.cachedWidth = this.computeSize(this.control, n, n2);
            return Geometry.copy((Point)this.cachedWidth);
        }
        return this.computeSize(this.control, n, n2);
    }

    private Point computeSize(Control control, int n, int n2) {
        int n3 = n == -1 ? -1 : Math.max(0, n - this.widthAdjustment);
        int n4 = n2 == -1 ? -1 : Math.max(0, n2 - this.heightAdjustment);
        Point point = control.computeSize(n3, n4, this.flushChildren);
        this.flushChildren = false;
        if (n != -1) {
            point.x = n;
        }
        if (n2 != -1) {
            point.y = n2;
        }
        return point;
    }

    static boolean independentLengthAndWidth(Control control) {
        if (control == null) {
            return true;
        }
        if (control instanceof Button || control instanceof ProgressBar || control instanceof Sash || control instanceof Scale || control instanceof Slider || control instanceof List || control instanceof Combo || control instanceof Tree) {
            return true;
        }
        if (control instanceof Label || control instanceof Text) {
            return (control.getStyle() & 0x40) == 0;
        }
        return false;
    }

    private void computeHintOffset(Control control) {
        if (control instanceof Composite) {
            Composite composite = (Composite)control;
            Rectangle rectangle = composite.computeTrim(0, 0, 0, 0);
            this.widthAdjustment = rectangle.width;
            this.heightAdjustment = rectangle.height;
        } else {
            this.heightAdjustment = this.widthAdjustment = control.getBorderWidth() * 2;
        }
    }

    private static boolean isPreferredWidthMaximum(Control control) {
        return control instanceof ToolBar || control instanceof Label;
    }
}

