/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.layout;

import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.internal.layout.CellData;
import org.eclipse.ui.internal.layout.CellLayout;
import org.eclipse.ui.internal.layout.CellLayoutUtil;

class GridInfo {
    private int cols = 0;
    private int rows = 0;
    private int[] gridInfo;
    int[] controlRow;
    int[] controlCol;
    private CellData[] cellData;
    Control[] controls;

    GridInfo() {
    }

    public void initGrid(Control[] controlArray, CellLayout cellLayout) {
        this.cols = cellLayout.getColumns();
        this.controls = controlArray;
        int n = 0;
        int n2 = 0;
        this.controlRow = new int[this.controls.length];
        this.controlCol = new int[this.controls.length];
        this.cellData = new CellData[this.controls.length];
        int n3 = 0;
        while (n3 < this.controls.length) {
            if (this.controls[n3] != null) {
                CellData cellData;
                this.cellData[n3] = cellData = CellLayoutUtil.getData(this.controls[n3]);
                n += cellData.horizontalSpan * cellData.verticalSpan;
                n2 += cellData.horizontalSpan;
            }
            ++n3;
        }
        if (this.cols == 0) {
            this.cols = n2;
        }
        this.rows = n / this.cols;
        if (n % this.cols > 0) {
            ++this.rows;
        }
        n = this.rows * this.cols;
        this.gridInfo = new int[n];
        n3 = 0;
        while (n3 < n) {
            this.gridInfo[n3] = -1;
            ++n3;
        }
        n3 = 0;
        int n4 = 0;
        while (n4 < this.controls.length) {
            CellData cellData = this.cellData[n4];
            while (this.gridInfo[n3] >= 0) {
                ++n3;
            }
            this.controlRow[n4] = n3 / this.cols;
            this.controlCol[n4] = n3 % this.cols;
            int n5 = 0;
            while (n5 < cellData.verticalSpan) {
                int n6 = 0;
                while (n6 < cellData.horizontalSpan) {
                    this.gridInfo[n3 + n5 * this.cols + n6] = n4;
                    ++n6;
                }
                ++n5;
            }
            n3 += cellData.horizontalSpan;
            ++n4;
        }
    }

    public int getRows() {
        return this.rows;
    }

    public int getStartPos(int n, boolean bl) {
        if (bl) {
            return this.controlRow[n];
        }
        return this.controlCol[n];
    }

    public int getNumRows(boolean bl) {
        if (bl) {
            return this.rows;
        }
        return this.cols;
    }

    public void getRow(int[] nArray, int n, boolean bl) {
        if (bl) {
            int n2 = -1;
            int n3 = 0;
            while (n3 < this.cols) {
                int n4 = this.gridInfo[this.cols * n + n3];
                nArray[n3] = n2 == n4 ? -1 : n4;
                n2 = n4;
                ++n3;
            }
        } else {
            int n5 = -1;
            int n6 = 0;
            while (n6 < this.rows) {
                int n7 = this.gridInfo[this.cols * n6 + n];
                nArray[n6] = n5 == n7 ? -1 : n7;
                n5 = n7;
                ++n6;
            }
        }
    }

    public CellData getCellData(int n) {
        return this.cellData[n];
    }

    public int getCols() {
        return this.cols;
    }
}

