/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.layout;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.ui.internal.layout.SizeCache;

public final class CellData {
    public static final int NONE = 0;
    public static final int OVERRIDE = 1;
    public static final int MINIMUM = 2;
    public static final int MAXIMUM = 3;
    public int hintType = 1;
    public int widthHint = -1;
    public int heightHint = -1;
    public int verticalSpan = 1;
    public int horizontalSpan = 1;
    public int horizontalAlignment = 4;
    public int verticalAlignment = 4;
    public int horizontalIndent = 0;
    public int verticalIndent = 0;

    public CellData() {
    }

    public CellData(GridData gridData) {
        this.verticalSpan = gridData.verticalSpan;
        this.horizontalSpan = gridData.horizontalSpan;
        switch (gridData.horizontalAlignment) {
            case 1: {
                this.horizontalAlignment = 16384;
                break;
            }
            case 2: {
                this.horizontalAlignment = 0x1000000;
                break;
            }
            case 3: {
                this.horizontalAlignment = 131072;
                break;
            }
            case 4: {
                this.horizontalAlignment = 4;
            }
        }
        switch (gridData.verticalAlignment) {
            case 1: {
                this.verticalAlignment = 16384;
                break;
            }
            case 2: {
                this.verticalAlignment = 0x1000000;
                break;
            }
            case 3: {
                this.verticalAlignment = 131072;
                break;
            }
            case 4: {
                this.verticalAlignment = 4;
            }
        }
        this.widthHint = gridData.widthHint;
        this.heightHint = gridData.heightHint;
        this.horizontalIndent = gridData.horizontalIndent;
        this.hintType = 1;
    }

    public CellData(CellData cellData) {
        this.hintType = cellData.hintType;
        this.widthHint = cellData.widthHint;
        this.heightHint = cellData.heightHint;
        this.horizontalAlignment = cellData.horizontalAlignment;
        this.verticalAlignment = cellData.verticalAlignment;
        this.horizontalSpan = cellData.horizontalSpan;
        this.verticalSpan = cellData.verticalSpan;
    }

    public CellData setHint(int n, Point point) {
        return this.setHint(n, point.x, point.y);
    }

    public CellData setHint(int n, int n2, int n3) {
        this.hintType = n;
        this.heightHint = n3;
        this.widthHint = n2;
        return this;
    }

    public CellData align(int n, int n2) {
        this.horizontalAlignment = n;
        this.verticalAlignment = n2;
        return this;
    }

    public CellData span(int n, int n2) {
        this.horizontalSpan = n;
        this.verticalSpan = n2;
        return this;
    }

    public CellData indent(Point point) {
        return this.indent(point.x, point.y);
    }

    public CellData indent(int n, int n2) {
        this.horizontalIndent = n;
        this.verticalIndent = n2;
        return this;
    }

    public Point computeSize(SizeCache sizeCache, int n, int n2) {
        int n3 = Math.abs(this.horizontalIndent);
        int n4 = Math.abs(this.verticalIndent);
        if (n != -1) {
            n -= n3;
        }
        if (n2 != -1) {
            n2 -= n4;
        }
        int n5 = this.horizontalAlignment == 4 ? n : -1;
        int n6 = this.verticalAlignment == 4 ? n2 : -1;
        Point point = this.computeControlSize(sizeCache, n5, n6);
        if (n != -1 && point.x > n) {
            point = this.computeControlSize(sizeCache, n, n6);
            if (n2 != -1 && point.y > n2) {
                point.y = n2;
            }
        } else if (n2 != -1 && point.y > n2) {
            point = this.computeControlSize(sizeCache, n5, n2);
            if (n != -1 && point.x > n) {
                point.x = n;
            }
        }
        point.x += n3;
        point.y += n4;
        return point;
    }

    public void positionControl(SizeCache sizeCache, Rectangle rectangle) {
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width - this.horizontalIndent;
        int n4 = rectangle.height - this.verticalIndent;
        Point point = this.computeSize(sizeCache, n3, n4);
        switch (this.horizontalAlignment) {
            case 131072: {
                n = rectangle.x + n3 - point.x;
                break;
            }
            case 0x1000000: {
                n = rectangle.x + (n3 - point.x) / 2;
            }
        }
        switch (this.verticalAlignment) {
            case 1024: {
                n2 = rectangle.y + n4 - point.y;
                break;
            }
            case 0x1000000: {
                n2 = rectangle.y + (n4 - point.y) / 2;
            }
        }
        sizeCache.getControl().setBounds(n + this.horizontalIndent, n2 + this.verticalIndent, point.x, point.y);
    }

    private Point computeControlSize(SizeCache sizeCache, int n, int n2) {
        switch (this.hintType) {
            case 1: {
                return CellData.computeOverrideSize(sizeCache, n, n2, this.widthHint, this.heightHint);
            }
            case 2: {
                return CellData.computeMinimumBoundedSize(sizeCache, n, n2, this.widthHint, this.heightHint);
            }
            case 3: {
                return CellData.computeMaximumBoundedSize(sizeCache, n, n2, this.widthHint, this.heightHint);
            }
        }
        return CellData.computeRawSize(sizeCache, n, n2);
    }

    private static Point computeRawSize(SizeCache sizeCache, int n, int n2) {
        if (n != -1 && n2 != -1) {
            return new Point(n, n2);
        }
        Point point = sizeCache.computeSize(n, n2);
        if (n != -1) {
            point.x = n;
        } else if (n2 != -1) {
            point.y = n2;
        }
        return point;
    }

    private static Point computeOverrideSize(SizeCache sizeCache, int n, int n2, int n3, int n4) {
        int n5 = n3;
        int n6 = n4;
        if (n != -1) {
            n5 = n;
        }
        if (n2 != -1) {
            n6 = n2;
        }
        if (n5 == -1 || n6 == -1) {
            Point point = CellData.computeRawSize(sizeCache, n5, n6);
            return point;
        }
        return new Point(n5, n6);
    }

    private static Point computeMaximumBoundedSize(SizeCache sizeCache, int n, int n2, int n3, int n4) {
        Point point = CellData.computeRawSize(sizeCache, n, n2);
        if (n == -1 && n3 != -1 && point.x > n3) {
            return CellData.computeMaximumBoundedSize(sizeCache, n3, n2, n3, n4);
        }
        if (n2 == -1 && n4 != -1 && point.y > n4) {
            return CellData.computeMaximumBoundedSize(sizeCache, n, n4, n3, n4);
        }
        return point;
    }

    private static Point computeMinimumBoundedSize(SizeCache sizeCache, int n, int n2, int n3, int n4) {
        Point point = CellData.computeRawSize(sizeCache, n, n2);
        if (n3 != -1 && n == -1 && point.x < n3) {
            return CellData.computeMinimumBoundedSize(sizeCache, n3, n2, n3, n4);
        }
        if (n4 != -1 && n2 == -1 && point.y < n4) {
            return CellData.computeMinimumBoundedSize(sizeCache, n, n4, n3, n4);
        }
        return point;
    }
}

