/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.layout;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.internal.layout.ICachingLayout;
import org.eclipse.ui.internal.layout.SizeCache;

public class CacheWrapper {
    private Composite proxy;
    private SizeCache cache = new SizeCache();
    private Rectangle lastBounds = new Rectangle(0, 0, 0, 0);

    public CacheWrapper(Composite composite) {
        this.proxy = new Composite(composite, 0);
        this.proxy.setLayout((Layout)new WrapperLayout());
    }

    public void flushCache() {
        this.cache.flush();
    }

    public Composite getControl() {
        return this.proxy;
    }

    public void dispose() {
        if (this.proxy != null) {
            this.proxy.dispose();
            this.proxy = null;
        }
    }

    private class WrapperLayout
    extends Layout
    implements ICachingLayout {
        private WrapperLayout() {
        }

        protected Point computeSize(Composite composite, int n, int n2, boolean bl) {
            Control[] controlArray = composite.getChildren();
            if (controlArray.length != 1) {
                return new Point(0, 0);
            }
            CacheWrapper.this.cache.setControl(controlArray[0]);
            return CacheWrapper.this.cache.computeSize(n, n2);
        }

        protected void layout(Composite composite, boolean bl) {
            Control[] controlArray = composite.getChildren();
            if (controlArray.length != 1) {
                return;
            }
            Control control = controlArray[0];
            Rectangle rectangle = composite.getClientArea();
            if (!rectangle.equals((Object)CacheWrapper.this.lastBounds)) {
                control.setBounds(rectangle);
                CacheWrapper.this.lastBounds = rectangle;
            }
        }

        @Override
        public void flush(Control control) {
            CacheWrapper.this.flushCache();
        }
    }
}

