/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.keys.model;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.core.commands.CommandManager;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.BindingManager;
import org.eclipse.jface.bindings.Scheme;
import org.eclipse.jface.bindings.keys.KeyBinding;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.keys.KeysPreferencePage;
import org.eclipse.ui.internal.keys.NewKeysPreferenceMessages;
import org.eclipse.ui.internal.keys.model.BindingElement;
import org.eclipse.ui.internal.keys.model.BindingModel;
import org.eclipse.ui.internal.keys.model.ConflictModel;
import org.eclipse.ui.internal.keys.model.ContextElement;
import org.eclipse.ui.internal.keys.model.ContextModel;
import org.eclipse.ui.internal.keys.model.ModelElement;
import org.eclipse.ui.internal.keys.model.SchemeElement;
import org.eclipse.ui.internal.keys.model.SchemeModel;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.statushandlers.StatusManager;

public class KeyController {
    private static final String DELIMITER = ",";
    private static final String ESCAPED_QUOTE = "\"";
    private static final String REPLACEMENT = "\"\"";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle(KeysPreferencePage.class.getName());
    private ListenerList eventManager = null;
    private BindingManager fBindingManager;
    private ContextModel contextModel;
    private SchemeModel fSchemeModel;
    private BindingModel bindingModel;
    private boolean notifying = true;
    private ConflictModel conflictModel;
    private IServiceLocator serviceLocator;

    private ListenerList getEventManager() {
        if (this.eventManager == null) {
            this.eventManager = new ListenerList(1);
        }
        return this.eventManager;
    }

    public void setNotifying(boolean bl) {
        this.notifying = bl;
    }

    public boolean isNotifying() {
        return this.notifying;
    }

    public void firePropertyChange(Object object, String string, Object object2, Object object3) {
        if (!this.isNotifying()) {
            return;
        }
        if (Util.equals(object2, object3)) {
            return;
        }
        Object[] objectArray = this.getEventManager().getListeners();
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(object, string, object2, object3);
        int n = 0;
        while (n < objectArray.length) {
            ((IPropertyChangeListener)objectArray[n]).propertyChange(propertyChangeEvent);
            ++n;
        }
    }

    public void addPropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.getEventManager().add((Object)iPropertyChangeListener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.getEventManager().remove((Object)iPropertyChangeListener);
    }

    public void init(IServiceLocator iServiceLocator) {
        this.getEventManager().clear();
        this.serviceLocator = iServiceLocator;
        this.fBindingManager = KeyController.loadModelBackend(this.serviceLocator);
        this.contextModel = new ContextModel(this);
        this.contextModel.init(this.serviceLocator);
        this.fSchemeModel = new SchemeModel(this);
        this.fSchemeModel.init(this.fBindingManager);
        this.bindingModel = new BindingModel(this);
        this.bindingModel.init(this.serviceLocator, this.fBindingManager, this.contextModel);
        this.conflictModel = new ConflictModel(this);
        this.conflictModel.init(this.fBindingManager, this.bindingModel);
        this.addSetContextListener();
        this.addSetBindingListener();
        this.addSetConflictListener();
        this.addSetKeySequenceListener();
        this.addSetSchemeListener();
        this.addSetModelObjectListener();
    }

    private static BindingManager loadModelBackend(IServiceLocator iServiceLocator) {
        IBindingService iBindingService = (IBindingService)iServiceLocator.getService(IBindingService.class);
        BindingManager bindingManager = new BindingManager(new ContextManager(), new CommandManager());
        Scheme[] schemeArray = iBindingService.getDefinedSchemes();
        try {
            Scheme scheme = null;
            int n = 0;
            while (n < schemeArray.length) {
                Scheme scheme2 = schemeArray[n];
                Scheme scheme3 = bindingManager.getScheme(scheme2.getId());
                scheme3.define(scheme2.getName(), scheme2.getDescription(), scheme2.getParentId());
                if (schemeArray[n] == iBindingService.getActiveScheme()) {
                    scheme = scheme3;
                }
                ++n;
            }
            bindingManager.setActiveScheme(scheme);
        }
        catch (NotDefinedException notDefinedException) {
            StatusManager.getManager().handle((IStatus)new Status(2, WorkbenchPlugin.PI_WORKBENCH, "Keys page found an undefined scheme", (Throwable)notDefinedException));
        }
        bindingManager.setLocale(iBindingService.getLocale());
        bindingManager.setPlatform(iBindingService.getPlatform());
        bindingManager.setBindings(iBindingService.getBindings());
        return bindingManager;
    }

    public ContextModel getContextModel() {
        return this.contextModel;
    }

    public SchemeModel getSchemeModel() {
        return this.fSchemeModel;
    }

    public BindingModel getBindingModel() {
        return this.bindingModel;
    }

    public ConflictModel getConflictModel() {
        return this.conflictModel;
    }

    private void addSetContextListener() {
        this.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getSource() == KeyController.this.contextModel && "selectedElement".equals(propertyChangeEvent.getProperty())) {
                    KeyController.this.updateBindingContext((ContextElement)propertyChangeEvent.getNewValue());
                }
            }
        });
    }

    private void addSetBindingListener() {
        this.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getSource() == KeyController.this.bindingModel && "selectedElement".equals(propertyChangeEvent.getProperty())) {
                    BindingElement bindingElement = (BindingElement)propertyChangeEvent.getNewValue();
                    if (bindingElement == null) {
                        KeyController.this.conflictModel.setSelectedElement(null);
                        return;
                    }
                    KeyController.this.conflictModel.setSelectedElement(bindingElement);
                    ContextElement contextElement = bindingElement.getContext();
                    if (contextElement != null) {
                        KeyController.this.contextModel.setSelectedElement(contextElement);
                    }
                }
            }
        });
    }

    private void addSetConflictListener() {
        this.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getSource() == KeyController.this.conflictModel && "selectedElement".equals(propertyChangeEvent.getProperty()) && propertyChangeEvent.getNewValue() != null) {
                    KeyController.this.bindingModel.setSelectedElement((ModelElement)propertyChangeEvent.getNewValue());
                }
            }
        });
    }

    private void addSetKeySequenceListener() {
        this.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("trigger".equals(propertyChangeEvent.getProperty())) {
                    KeyController.this.updateTrigger((BindingElement)propertyChangeEvent.getSource(), (KeySequence)propertyChangeEvent.getOldValue(), (KeySequence)propertyChangeEvent.getNewValue());
                }
            }
        });
    }

    private void addSetModelObjectListener() {
        this.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getSource() instanceof BindingElement && "modelObject".equals(propertyChangeEvent.getProperty()) && propertyChangeEvent.getNewValue() != null) {
                    BindingElement bindingElement = (BindingElement)propertyChangeEvent.getSource();
                    Object object = propertyChangeEvent.getOldValue();
                    Object object2 = propertyChangeEvent.getNewValue();
                    if (object instanceof Binding && object2 instanceof Binding) {
                        KeyController.this.conflictModel.updateConflictsFor(bindingElement, ((Binding)object).getTriggerSequence(), ((Binding)object2).getTriggerSequence(), false);
                    } else {
                        KeyController.this.conflictModel.updateConflictsFor(bindingElement, false);
                    }
                    ContextElement contextElement = bindingElement.getContext();
                    if (contextElement != null) {
                        KeyController.this.contextModel.setSelectedElement(contextElement);
                    }
                }
            }
        });
    }

    private void addSetSchemeListener() {
        this.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getSource() == KeyController.this.fSchemeModel && "selectedElement".equals(propertyChangeEvent.getProperty())) {
                    KeyController.this.changeScheme((SchemeElement)propertyChangeEvent.getOldValue(), (SchemeElement)propertyChangeEvent.getNewValue());
                }
            }
        });
    }

    protected void changeScheme(SchemeElement schemeElement, SchemeElement schemeElement2) {
        if (schemeElement2 == null || schemeElement2.getModelObject() == this.fBindingManager.getActiveScheme()) {
            return;
        }
        try {
            this.fBindingManager.setActiveScheme((Scheme)schemeElement2.getModelObject());
            this.bindingModel.refresh(this.contextModel);
            this.bindingModel.setSelectedElement(null);
        }
        catch (NotDefinedException notDefinedException) {
            notDefinedException.printStackTrace();
        }
    }

    private void updateBindingContext(ContextElement contextElement) {
        KeyBinding keyBinding;
        if (contextElement == null) {
            return;
        }
        BindingElement bindingElement = (BindingElement)this.bindingModel.getSelectedElement();
        if (bindingElement == null) {
            return;
        }
        String string = this.fSchemeModel.getSelectedElement().getId();
        Object object = bindingElement.getModelObject();
        if (object instanceof KeyBinding && !(keyBinding = (KeyBinding)object).getContextId().equals(contextElement.getId())) {
            KeyBinding keyBinding2 = new KeyBinding(keyBinding.getKeySequence(), keyBinding.getParameterizedCommand(), string, contextElement.getId(), null, null, null, 1);
            if (keyBinding.getType() == 1) {
                this.fBindingManager.removeBinding((Binding)keyBinding);
            } else {
                this.fBindingManager.addBinding((Binding)new KeyBinding(keyBinding.getKeySequence(), null, keyBinding.getSchemeId(), keyBinding.getContextId(), null, null, null, 1));
            }
            this.bindingModel.getBindingToElement().remove(bindingElement.getModelObject());
            this.fBindingManager.addBinding((Binding)keyBinding2);
            bindingElement.fill(keyBinding2, this.contextModel);
            this.bindingModel.getBindingToElement().put(keyBinding2, bindingElement);
        }
    }

    public void updateTrigger(BindingElement bindingElement, KeySequence keySequence, KeySequence keySequence2) {
        if (bindingElement == null) {
            return;
        }
        Object object = bindingElement.getModelObject();
        if (object instanceof KeyBinding) {
            KeyBinding keyBinding = (KeyBinding)object;
            if (!keyBinding.getKeySequence().equals((Object)keySequence2)) {
                if (keySequence2 != null && !keySequence2.isEmpty()) {
                    String string = this.fSchemeModel.getSelectedElement().getId();
                    ModelElement modelElement = this.contextModel.getSelectedElement();
                    String string2 = modelElement == null ? "org.eclipse.ui.contexts.window" : modelElement.getId();
                    KeyBinding keyBinding2 = new KeyBinding(keySequence2, keyBinding.getParameterizedCommand(), string, string2, null, null, null, 1);
                    Map map = this.bindingModel.getBindingToElement();
                    map.remove(keyBinding);
                    if (keyBinding.getType() == 1) {
                        this.fBindingManager.removeBinding((Binding)keyBinding);
                    } else {
                        this.fBindingManager.addBinding((Binding)new KeyBinding(keyBinding.getKeySequence(), null, keyBinding.getSchemeId(), keyBinding.getContextId(), null, null, null, 1));
                    }
                    this.fBindingManager.addBinding((Binding)keyBinding2);
                    bindingElement.fill(keyBinding2, this.contextModel);
                    this.bindingModel.getBindingToElement().put(keyBinding2, bindingElement);
                    Object[] objectArray = map.keySet().toArray();
                    int n = 0;
                    while (n < objectArray.length) {
                        Binding binding = (Binding)objectArray[n];
                        if (keySequence.equals((Object)binding.getTriggerSequence()) && binding.getType() == 0) {
                            BindingElement bindingElement2 = (BindingElement)map.get(binding);
                            this.bindingModel.remove(bindingElement2);
                        }
                        ++n;
                    }
                    this.bindingModel.setSelectedElement(bindingElement);
                } else {
                    this.bindingModel.getBindingToElement().remove(keyBinding);
                    if (keyBinding.getType() == 1) {
                        this.fBindingManager.removeBinding((Binding)keyBinding);
                    } else {
                        this.fBindingManager.addBinding((Binding)new KeyBinding(keyBinding.getKeySequence(), null, keyBinding.getSchemeId(), keyBinding.getContextId(), null, null, null, 1));
                    }
                    bindingElement.fill(keyBinding.getParameterizedCommand());
                }
            }
        } else if (object instanceof ParameterizedCommand) {
            ParameterizedCommand parameterizedCommand = (ParameterizedCommand)object;
            if (keySequence2 != null && !keySequence2.isEmpty()) {
                String string = this.fSchemeModel.getSelectedElement().getId();
                ModelElement modelElement = this.contextModel.getSelectedElement();
                String string3 = modelElement == null ? "org.eclipse.ui.contexts.window" : modelElement.getId();
                KeyBinding keyBinding = new KeyBinding(keySequence2, parameterizedCommand, string, string3, null, null, null, 1);
                this.fBindingManager.addBinding((Binding)keyBinding);
                bindingElement.fill(keyBinding, this.contextModel);
                this.bindingModel.getBindingToElement().put(keyBinding, bindingElement);
            }
        }
    }

    public void saveBindings(IBindingService iBindingService) {
        try {
            iBindingService.savePreferences(this.fBindingManager.getActiveScheme(), this.fBindingManager.getBindings());
        }
        catch (IOException iOException) {
            this.logPreferenceStoreException(iOException);
        }
    }

    private final void logPreferenceStoreException(Throwable throwable) {
        String string = NewKeysPreferenceMessages.PreferenceStoreError_Message;
        String string2 = throwable.getMessage();
        if (string2 == null) {
            string2 = string;
        }
        Status status = new Status(4, WorkbenchPlugin.PI_WORKBENCH, 0, string2, throwable);
        WorkbenchPlugin.log(string, (IStatus)status);
        StatusUtil.handleStatus(string, throwable, 2);
    }

    public void filterContexts(boolean bl, boolean bl2, boolean bl3) {
        this.contextModel.filterContexts(bl, bl2, bl3);
    }

    public void setDefaultBindings(IBindingService iBindingService) {
        String string = iBindingService.getDefaultSchemeId();
        Scheme scheme = this.fBindingManager.getScheme(string);
        try {
            this.fBindingManager.setActiveScheme(scheme);
        }
        catch (NotDefinedException notDefinedException) {}
        Binding[] bindingArray = this.fBindingManager.getBindings();
        int n = 0;
        while (n < bindingArray.length) {
            if (bindingArray[n].getType() == 1) {
                this.fBindingManager.removeBinding(bindingArray[n]);
            }
            ++n;
        }
        this.bindingModel.refresh(this.contextModel);
        this.saveBindings(iBindingService);
    }

    public void exportCSV(Shell shell) {
        FileDialog fileDialog = new FileDialog(shell, 0x10002000);
        fileDialog.setFilterExtensions(new String[]{"*.csv"});
        fileDialog.setFilterNames(new String[]{Util.translateString(RESOURCE_BUNDLE, "csvFilterName")});
        fileDialog.setOverwrite(true);
        final String string = fileDialog.open();
        if (string == null) {
            return;
        }
        SafeRunnable safeRunnable = new SafeRunnable(){

            public final void run() throws IOException {
                Writer writer = null;
                try {
                    writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string), "UTF-8"));
                    Object[] objectArray = KeyController.this.bindingModel.getBindings().toArray();
                    int n = 0;
                    while (n < objectArray.length) {
                        BindingElement bindingElement = (BindingElement)objectArray[n];
                        if (bindingElement.getTrigger() != null && !bindingElement.getTrigger().isEmpty() && bindingElement.getContext() != null && bindingElement.getContext().getName() != null) {
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append(KeyController.ESCAPED_QUOTE + Util.replaceAll(bindingElement.getCategory(), KeyController.ESCAPED_QUOTE, KeyController.REPLACEMENT) + KeyController.ESCAPED_QUOTE + KeyController.DELIMITER);
                            stringBuffer.append(KeyController.ESCAPED_QUOTE + bindingElement.getName() + KeyController.ESCAPED_QUOTE + KeyController.DELIMITER);
                            stringBuffer.append(KeyController.ESCAPED_QUOTE + bindingElement.getTrigger().format() + KeyController.ESCAPED_QUOTE + KeyController.DELIMITER);
                            stringBuffer.append(KeyController.ESCAPED_QUOTE + bindingElement.getContext().getName() + KeyController.ESCAPED_QUOTE);
                            stringBuffer.append(System.getProperty("line.separator"));
                            writer.write(stringBuffer.toString());
                        }
                        ++n;
                    }
                }
                catch (Throwable throwable) {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        };
        SafeRunner.run((ISafeRunnable)safeRunnable);
    }
}

