/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.keys.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.commands.contexts.Context;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.internal.keys.model.CommonModel;
import org.eclipse.ui.internal.keys.model.ContextElement;
import org.eclipse.ui.internal.keys.model.KeyController;
import org.eclipse.ui.services.IServiceLocator;

public class ContextModel
extends CommonModel {
    private static final String CONTEXT_ID_ACTION_SETS = "org.eclipse.ui.contexts.actionSet";
    private static final String CONTEXT_ID_INTERNAL = ".internal.";
    public static final String PROP_CONTEXTS = "contexts";
    public static final String PROP_CONTEXT_MAP = "contextIdElementMap";
    private List contexts;
    private Map contextIdToFilteredContexts;
    private Map contextIdToElement;
    private IContextService contextService;

    public ContextModel(KeyController keyController) {
        super(keyController);
    }

    public void init(IServiceLocator iServiceLocator) {
        this.contextService = (IContextService)iServiceLocator.getService(IContextService.class);
        this.contexts = new ArrayList();
        this.contextIdToFilteredContexts = new HashMap();
        this.contextIdToElement = new HashMap();
        Context[] contextArray = this.contextService.getDefinedContexts();
        int n = 0;
        while (n < contextArray.length) {
            ContextElement contextElement = new ContextElement(this.controller);
            contextElement.init(contextArray[n]);
            contextElement.setParent(this);
            this.contexts.add(contextElement);
            this.contextIdToElement.put(contextArray[n].getId(), contextElement);
            ++n;
        }
    }

    public List getContexts() {
        return this.contexts;
    }

    public void setContexts(List list) {
        List list2 = this.contexts;
        this.contexts = list;
        this.controller.firePropertyChange(this, PROP_CONTEXTS, list2, list);
    }

    public Map getContextIdToElement() {
        return this.contextIdToElement;
    }

    public void setContextIdToElement(Map map) {
        Map map2 = this.contextIdToElement;
        this.contextIdToElement = map;
        this.controller.firePropertyChange(this, PROP_CONTEXT_MAP, map2, map);
    }

    public void filterContexts(boolean bl, boolean bl2, boolean bl3) {
        String string;
        ContextElement contextElement;
        boolean bl4;
        int n = 0;
        while (n < this.contexts.size()) {
            bl4 = false;
            contextElement = (ContextElement)this.contexts.get(n);
            if (bl && contextElement.getId().equalsIgnoreCase(CONTEXT_ID_ACTION_SETS)) {
                bl4 = true;
            } else {
                try {
                    string = ((Context)contextElement.getModelObject()).getParentId();
                    while (string != null) {
                        if (string.equalsIgnoreCase(CONTEXT_ID_ACTION_SETS)) {
                            bl4 = true;
                        }
                        string = this.contextService.getContext(string).getParentId();
                    }
                }
                catch (NotDefinedException notDefinedException) {}
            }
            if (bl2 && contextElement.getId().indexOf(CONTEXT_ID_INTERNAL) != -1) {
                bl4 = true;
            }
            if (bl3 && contextElement.getId().equals("org.eclipse.ui.contexts.workbenchMenu")) {
                bl4 = true;
            }
            if (bl4) {
                this.contextIdToFilteredContexts.put(contextElement.getId(), contextElement);
                this.contextIdToElement.remove(contextElement);
            }
            ++n;
        }
        this.contexts.removeAll(this.contextIdToFilteredContexts.values());
        Iterator iterator = this.contextIdToFilteredContexts.keySet().iterator();
        while (iterator.hasNext()) {
            bl4 = false;
            contextElement = (ContextElement)this.contextIdToFilteredContexts.get(iterator.next());
            try {
                if (!bl) {
                    if (contextElement.getId().equalsIgnoreCase(CONTEXT_ID_ACTION_SETS)) {
                        bl4 = true;
                    } else {
                        string = ((Context)contextElement.getModelObject()).getParentId();
                        if (string != null && string.equalsIgnoreCase(CONTEXT_ID_ACTION_SETS)) {
                            bl4 = true;
                        }
                    }
                }
            }
            catch (NotDefinedException notDefinedException) {}
            if (!bl2 && contextElement.getId().indexOf(CONTEXT_ID_INTERNAL) != -1) {
                bl4 = true;
            }
            if (!bl3 && contextElement.getId().equals("org.eclipse.ui.contexts.workbenchMenu")) {
                bl4 = true;
            }
            if (!bl4) continue;
            this.contexts.add(contextElement);
            this.contextIdToElement.put(contextElement.getId(), contextElement);
            iterator.remove();
        }
    }
}

