/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.keys.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.BindingManager;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.internal.keys.model.BindingElement;
import org.eclipse.ui.internal.keys.model.BindingModel;
import org.eclipse.ui.internal.keys.model.CommonModel;
import org.eclipse.ui.internal.keys.model.KeyController;

public class ConflictModel
extends CommonModel {
    public static final String PROP_CONFLICTS = "conflicts";
    public static final String PROP_CONFLICTS_ADD = "conflictsAdd";
    public static final String PROP_CONFLICTS_REMOVE = "conflictsRemove";
    private Collection conflicts;
    private BindingManager bindingManager;
    private BindingModel bindingModel;
    private Map conflictsMap;

    public ConflictModel(KeyController keyController) {
        super(keyController);
    }

    public Collection getConflicts() {
        return this.conflicts;
    }

    public void setConflicts(Collection collection) {
        Collection collection2 = this.conflicts;
        this.conflicts = collection;
        if (this.conflicts != null) {
            Iterator iterator = this.conflicts.iterator();
            Map map = this.bindingModel.getBindingToElement();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (map.containsValue(e) || e.equals(this.getSelectedElement())) continue;
                iterator.remove();
            }
        }
        this.controller.firePropertyChange(this, PROP_CONFLICTS, collection2, collection);
    }

    public void updateConflictsFor(BindingElement bindingElement) {
        this.updateConflictsFor(bindingElement, false);
    }

    public void updateConflictsFor(BindingElement bindingElement, BindingElement bindingElement2) {
        this.updateConflictsFor(bindingElement, bindingElement2, false);
    }

    public void updateConflictsFor(BindingElement bindingElement, boolean bl) {
        this.updateConflictsFor(null, bindingElement, bl);
    }

    private void updateConflictsFor(BindingElement bindingElement, BindingElement bindingElement2, boolean bl) {
        this.updateConflictsFor(bindingElement2, bindingElement == null ? null : bindingElement.getTrigger(), bindingElement2 == null ? null : bindingElement2.getTrigger(), bl);
    }

    public void updateConflictsFor(BindingElement bindingElement, TriggerSequence triggerSequence, TriggerSequence triggerSequence2, boolean bl) {
        BindingElement bindingElement2;
        Object object;
        Collection collection = (Collection)this.conflictsMap.get(bindingElement);
        if (collection != null) {
            if (triggerSequence2 == null || bl) {
                collection.remove(bindingElement);
                this.conflictsMap.remove(bindingElement);
                if (collection == this.conflicts) {
                    this.controller.firePropertyChange(this, PROP_CONFLICTS_REMOVE, null, bindingElement);
                }
                if (collection.size() == 1) {
                    BindingElement bindingElement3 = (BindingElement)collection.iterator().next();
                    this.conflictsMap.remove(bindingElement3);
                    bindingElement3.setConflict(Boolean.FALSE);
                    if (collection == this.conflicts) {
                        this.setConflicts(null);
                    }
                }
                return;
            }
            if (triggerSequence != null && !triggerSequence2.equals((Object)triggerSequence)) {
                collection.remove(bindingElement);
                this.conflictsMap.remove(bindingElement);
                if (collection == this.conflicts) {
                    this.controller.firePropertyChange(this, PROP_CONFLICTS_REMOVE, null, bindingElement);
                }
                if (collection.size() == 1) {
                    object = (BindingElement)collection.iterator().next();
                    this.conflictsMap.remove(object);
                    ((BindingElement)object).setConflict(Boolean.FALSE);
                    if (collection == this.conflicts) {
                        this.setConflicts(null);
                    }
                }
            } else {
                return;
            }
        }
        if (bindingElement.getTrigger() == null || !(bindingElement.getModelObject() instanceof Binding)) {
            return;
        }
        object = (Binding)bindingElement.getModelObject();
        TriggerSequence triggerSequence3 = object.getTriggerSequence();
        collection = (Collection)this.bindingManager.getActiveBindingsDisregardingContext().get(triggerSequence3);
        ArrayList<BindingElement> arrayList = new ArrayList<BindingElement>();
        if (collection != null) {
            arrayList.add(bindingElement);
            for (Object object2 : collection) {
                if (object == object2 || !object2.getContextId().equals(object.getContextId()) || !object2.getSchemeId().equals(object.getSchemeId()) || (bindingElement2 = this.bindingModel.getBindingToElement().get(object2)) == null) continue;
                arrayList.add(bindingElement2);
            }
        }
        if (arrayList.size() > 1) {
            Object object2;
            Object object3 = null;
            object2 = arrayList.iterator();
            while (object2.hasNext() && object3 == null) {
                bindingElement2 = (BindingElement)object2.next();
                object3 = (Collection)this.conflictsMap.get(bindingElement2);
            }
            if (object3 != null) {
                object3.add((BindingElement)bindingElement);
                this.conflictsMap.put(bindingElement, object3);
                bindingElement.setConflict(Boolean.TRUE);
                if (object3 == this.conflicts) {
                    this.controller.firePropertyChange(this, PROP_CONFLICTS_ADD, null, bindingElement);
                } else if (bindingElement == this.getSelectedElement()) {
                    this.setConflicts((Collection)object3);
                }
                return;
            }
            boolean bl2 = false;
            for (BindingElement bindingElement4 : arrayList) {
                if (bindingElement4 != null) {
                    this.conflictsMap.put(bindingElement4, arrayList);
                    bindingElement4.setConflict(Boolean.TRUE);
                }
                if (bindingElement4 != this.getSelectedElement()) continue;
                bl2 = true;
            }
            if (bl2) {
                this.setConflicts(arrayList);
            }
        }
    }

    public void init(BindingManager bindingManager, BindingModel bindingModel) {
        this.bindingManager = bindingManager;
        this.bindingModel = bindingModel;
        this.conflictsMap = new HashMap();
        for (BindingElement bindingElement : this.bindingModel.getBindings()) {
            if (!(bindingElement.getModelObject() instanceof Binding)) continue;
            this.updateConflictsFor(bindingElement);
        }
        this.controller.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getSource() == ConflictModel.this && "selectedElement".equals(propertyChangeEvent.getProperty())) {
                    if (propertyChangeEvent.getNewValue() != null) {
                        ConflictModel.this.updateConflictsFor((BindingElement)propertyChangeEvent.getOldValue(), (BindingElement)propertyChangeEvent.getNewValue());
                        ConflictModel.this.setConflicts((Collection)ConflictModel.this.conflictsMap.get(propertyChangeEvent.getNewValue()));
                    } else {
                        ConflictModel.this.setConflicts(null);
                    }
                } else if ("bindingRemove".equals(propertyChangeEvent.getProperty())) {
                    ConflictModel.this.updateConflictsFor((BindingElement)propertyChangeEvent.getOldValue(), (BindingElement)propertyChangeEvent.getNewValue(), true);
                }
            }
        });
    }
}

