/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.keys.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.BindingManager;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeyBinding;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.internal.keys.model.BindingElement;
import org.eclipse.ui.internal.keys.model.CommonModel;
import org.eclipse.ui.internal.keys.model.ConflictModel;
import org.eclipse.ui.internal.keys.model.ContextModel;
import org.eclipse.ui.internal.keys.model.KeyController;
import org.eclipse.ui.internal.keys.model.ModelElement;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.services.IServiceLocator;

public class BindingModel
extends CommonModel {
    public static final String PROP_BINDING_ADD = "bindingAdd";
    public static final String PROP_BINDING_ELEMENT_MAP = "bindingElementMap";
    public static final String PROP_BINDING_FILTER = "bindingFilter";
    public static final String PROP_BINDING_REMOVE = "bindingRemove";
    public static final String PROP_BINDINGS = "bindings";
    public static final String PROP_CONFLICT_ELEMENT_MAP = "bindingConfictMap";
    private Collection allParameterizedCommands;
    private BindingManager bindingManager;
    private HashSet bindingElements;
    private Map bindingToElement;
    private Map commandToElement;

    static final boolean deletes(Binding binding, Binding binding2) {
        boolean bl = true;
        bl &= Util.equals(binding.getContextId(), binding2.getContextId());
        bl &= Util.equals(binding.getTriggerSequence(), binding2.getTriggerSequence());
        if (binding.getLocale() != null) {
            bl &= Util.equals(binding.getLocale(), binding2.getLocale());
        }
        if (binding.getPlatform() != null) {
            bl &= Util.equals(binding.getPlatform(), binding2.getPlatform());
        }
        bl &= binding2.getType() == 0;
        return bl &= Util.equals(binding.getParameterizedCommand(), null);
    }

    public BindingModel(KeyController keyController) {
        super(keyController);
    }

    public void copy() {
        BindingElement bindingElement = (BindingElement)this.getSelectedElement();
        this.copy(bindingElement);
    }

    public void copy(BindingElement bindingElement) {
        if (bindingElement == null || !(bindingElement.getModelObject() instanceof Binding)) {
            return;
        }
        BindingElement bindingElement2 = new BindingElement(this.controller);
        ParameterizedCommand parameterizedCommand = ((Binding)bindingElement.getModelObject()).getParameterizedCommand();
        bindingElement2.init(parameterizedCommand);
        bindingElement2.setParent(this);
        this.bindingElements.add(bindingElement2);
        this.commandToElement.put(parameterizedCommand, bindingElement2);
        this.controller.firePropertyChange(this, PROP_BINDING_ADD, null, bindingElement2);
        this.setSelectedElement(bindingElement2);
    }

    public HashSet getBindings() {
        return this.bindingElements;
    }

    public Map getBindingToElement() {
        return this.bindingToElement;
    }

    public Map getCommandToElement() {
        return this.commandToElement;
    }

    public void init(IServiceLocator iServiceLocator, BindingManager bindingManager, ContextModel contextModel) {
        Object object;
        Object object2;
        Object object32;
        HashSet<ParameterizedCommand> hashSet = new HashSet<ParameterizedCommand>();
        this.bindingToElement = new HashMap();
        this.commandToElement = new HashMap();
        this.bindingElements = new HashSet();
        this.bindingManager = bindingManager;
        for (Object object32 : bindingManager.getActiveBindingsDisregardingContextFlat()) {
            object2 = new BindingElement(this.controller);
            ((BindingElement)object2).init((Binding)object32, contextModel);
            ((ModelElement)object2).setParent(this);
            this.bindingElements.add(object2);
            this.bindingToElement.put(object32, object2);
            hashSet.add(object32.getParameterizedCommand());
        }
        object32 = (ICommandService)iServiceLocator.getService(ICommandService.class);
        object2 = object32.getDefinedCommandIds();
        this.allParameterizedCommands = new HashSet();
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            object = object32.getCommand(string);
            try {
                this.allParameterizedCommands.addAll(ParameterizedCommand.generateCombinations((Command)object));
            }
            catch (NotDefinedException notDefinedException) {}
        }
        for (String string : this.allParameterizedCommands) {
            if (hashSet.contains(string)) continue;
            object = new BindingElement(this.controller);
            ((BindingElement)object).init((ParameterizedCommand)string);
            ((ModelElement)object).setParent(this);
            this.bindingElements.add(object);
            this.commandToElement.put(string, object);
        }
    }

    public void refresh(ContextModel contextModel) {
        Object object;
        Object object2;
        Object object3;
        HashSet<ParameterizedCommand> hashSet = new HashSet<ParameterizedCommand>();
        Collection collection = this.bindingManager.getActiveBindingsDisregardingContextFlat();
        for (Object object4 : collection) {
            object3 = object4.getParameterizedCommand();
            hashSet.add((ParameterizedCommand)object3);
            if (this.bindingToElement.containsKey(object4)) continue;
            object2 = new BindingElement(this.controller);
            ((BindingElement)object2).init((Binding)object4, contextModel);
            ((ModelElement)object2).setParent(this);
            this.bindingElements.add(object2);
            this.bindingToElement.put(object4, object2);
            this.controller.firePropertyChange(this, PROP_BINDING_ADD, null, object2);
            if (!this.commandToElement.containsKey(object3) || ((BindingElement)object2).getUserDelta() != 0) continue;
            object = this.commandToElement.remove(object3);
            this.bindingElements.remove(object);
            this.controller.firePropertyChange(this, PROP_BINDING_REMOVE, null, object);
        }
        Iterator iterator = this.bindingElements.iterator();
        while (iterator.hasNext()) {
            Object object4;
            object4 = (BindingElement)iterator.next();
            object3 = ((ModelElement)object4).getModelObject();
            if (object3 instanceof Binding) {
                object2 = (Binding)object3;
                if (collection.contains(object2)) continue;
                object = object2.getParameterizedCommand();
                if (object != null) {
                    this.commandToElement.remove(object);
                }
                this.bindingToElement.remove(object2);
                iterator.remove();
                this.controller.firePropertyChange(this, PROP_BINDING_REMOVE, null, object4);
                continue;
            }
            hashSet.add((ParameterizedCommand)object3);
        }
        for (Object object4 : this.allParameterizedCommands) {
            if (hashSet.contains(object4)) continue;
            object3 = new BindingElement(this.controller);
            ((BindingElement)object3).init((ParameterizedCommand)object4);
            ((ModelElement)object3).setParent(this);
            this.bindingElements.add(object3);
            this.commandToElement.put(object4, object3);
            this.controller.firePropertyChange(this, PROP_BINDING_ADD, null, object3);
        }
    }

    public void remove() {
        BindingElement bindingElement = (BindingElement)this.getSelectedElement();
        this.remove(bindingElement);
    }

    public void remove(BindingElement bindingElement) {
        KeySequence keySequence;
        if (bindingElement == null || !(bindingElement.getModelObject() instanceof Binding)) {
            return;
        }
        KeyBinding keyBinding = (KeyBinding)bindingElement.getModelObject();
        if (keyBinding.getType() == 1) {
            this.bindingManager.removeBinding((Binding)keyBinding);
        } else {
            keySequence = keyBinding.getKeySequence();
            this.bindingManager.addBinding((Binding)new KeyBinding(keySequence, null, keyBinding.getSchemeId(), keyBinding.getContextId(), null, null, null, 1));
            ConflictModel conflictModel = this.controller.getConflictModel();
            conflictModel.updateConflictsFor(bindingElement);
            Collection collection = conflictModel.getConflicts();
            if (collection != null) {
                Object[] objectArray = collection.toArray();
                int n = 0;
                while (n < objectArray.length) {
                    Binding binding;
                    Object object;
                    BindingElement bindingElement2 = (BindingElement)objectArray[n];
                    if (bindingElement2 != bindingElement && (object = bindingElement2.getModelObject()) instanceof Binding && (binding = (Binding)object).getType() == 0) {
                        ParameterizedCommand parameterizedCommand = binding.getParameterizedCommand();
                        bindingElement2.fill(parameterizedCommand);
                        this.commandToElement.put(parameterizedCommand, bindingElement2);
                    }
                    ++n;
                }
            }
        }
        keySequence = keyBinding.getParameterizedCommand();
        bindingElement.fill((ParameterizedCommand)keySequence);
        this.commandToElement.put(keySequence, bindingElement);
        this.controller.firePropertyChange(this, PROP_CONFLICT_ELEMENT_MAP, null, bindingElement);
    }

    public void restoreBinding(BindingElement bindingElement) {
        Binding binding;
        TriggerSequence triggerSequence;
        if (bindingElement == null) {
            return;
        }
        Object object = bindingElement.getModelObject();
        ParameterizedCommand parameterizedCommand = null;
        if (object instanceof ParameterizedCommand) {
            parameterizedCommand = (ParameterizedCommand)object;
            triggerSequence = this.bindingManager.getBestActiveBindingFor(parameterizedCommand.getId());
            binding = this.bindingManager.getPerfectMatch(triggerSequence);
            if (binding != null && binding.getType() == 0) {
                return;
            }
        } else if (object instanceof KeyBinding) {
            parameterizedCommand = ((KeyBinding)object).getParameterizedCommand();
        }
        triggerSequence = this.bindingManager.getBindings();
        binding = new ArrayList();
        ArrayList<TriggerSequence> arrayList = new ArrayList<TriggerSequence>();
        int n = 0;
        while (n < ((TriggerSequence)triggerSequence).length) {
            if (triggerSequence[n].getParameterizedCommand() == null) {
                arrayList.add(triggerSequence[n]);
            } else if (triggerSequence[n].getParameterizedCommand().equals((Object)parameterizedCommand)) {
                if (triggerSequence[n].getType() == 1) {
                    this.bindingManager.removeBinding((Binding)triggerSequence[n]);
                } else if (triggerSequence[n].getType() == 0) {
                    binding.add(triggerSequence[n]);
                }
            }
            ++n;
        }
        for (Binding binding2 : binding) {
            for (Binding binding3 : arrayList) {
                if (!BindingModel.deletes(binding3, binding2) || binding3.getType() != 1) continue;
                this.bindingManager.removeBinding(binding3);
            }
        }
        this.setSelectedElement(null);
        this.bindingElements.remove(bindingElement);
        this.bindingToElement.remove(object);
        this.commandToElement.remove(object);
        this.controller.firePropertyChange(this, PROP_BINDING_REMOVE, null, bindingElement);
    }

    public void restoreBinding(ContextModel contextModel) {
        BindingElement bindingElement = (BindingElement)this.getSelectedElement();
        if (bindingElement == null) {
            return;
        }
        this.restoreBinding(bindingElement);
        this.refresh(contextModel);
        Object object = bindingElement.getModelObject();
        ParameterizedCommand parameterizedCommand = null;
        if (object instanceof ParameterizedCommand) {
            parameterizedCommand = (ParameterizedCommand)object;
        } else if (object instanceof KeyBinding) {
            parameterizedCommand = ((KeyBinding)object).getParameterizedCommand();
        }
        boolean bl = false;
        Iterator iterator = this.bindingElements.iterator();
        while (iterator.hasNext() && !bl) {
            BindingElement bindingElement2 = (BindingElement)iterator.next();
            object = bindingElement2.getModelObject();
            ParameterizedCommand parameterizedCommand2 = null;
            if (object instanceof ParameterizedCommand) {
                parameterizedCommand2 = (ParameterizedCommand)object;
            } else if (object instanceof KeyBinding) {
                parameterizedCommand2 = ((KeyBinding)object).getParameterizedCommand();
            }
            if (!parameterizedCommand.equals((Object)parameterizedCommand2)) continue;
            bl = true;
            this.setSelectedElement(bindingElement2);
        }
    }

    public void setBindings(HashSet hashSet) {
        HashSet hashSet2 = this.bindingElements;
        this.bindingElements = hashSet;
        this.controller.firePropertyChange(this, PROP_BINDINGS, hashSet2, hashSet);
    }

    public void setBindingToElement(Map map) {
        Map map2 = this.bindingToElement;
        this.bindingToElement = map;
        this.controller.firePropertyChange(this, PROP_BINDING_ELEMENT_MAP, map2, map);
    }
}

