/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.keys.model;

import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeyBinding;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.internal.keys.NewKeysPreferenceMessages;
import org.eclipse.ui.internal.keys.model.ContextElement;
import org.eclipse.ui.internal.keys.model.ContextModel;
import org.eclipse.ui.internal.keys.model.KeyController;
import org.eclipse.ui.internal.keys.model.ModelElement;

public class BindingElement
extends ModelElement {
    public static final String PROP_TRIGGER = "trigger";
    public static final String PROP_CONTEXT = "bindingContext";
    public static final String PROP_CATEGORY = "category";
    public static final String PROP_USER_DELTA = "userDelta";
    private static final String PROP_IMAGE = "image";
    public static final String PROP_CONFLICT = "bindingConflict";
    private TriggerSequence trigger;
    private ContextElement context;
    private String category;
    private Integer userDelta;
    private Image image;
    private Boolean conflict;

    public BindingElement(KeyController keyController) {
        super(keyController);
    }

    public void init(Binding binding, ContextModel contextModel) {
        this.setCommandInfo(binding.getParameterizedCommand());
        this.setTrigger(binding.getTriggerSequence());
        this.setContext((ContextElement)contextModel.getContextIdToElement().get(binding.getContextId()));
        this.setUserDelta(new Integer(binding.getType()));
        this.setModelObject(binding);
    }

    private void setCommandInfo(ParameterizedCommand parameterizedCommand) {
        this.setId(parameterizedCommand.getId());
        try {
            this.setName(parameterizedCommand.getName());
        }
        catch (NotDefinedException notDefinedException) {
            this.setName(NewKeysPreferenceMessages.Undefined_Command);
        }
        try {
            this.setDescription(parameterizedCommand.getCommand().getDescription());
        }
        catch (NotDefinedException notDefinedException) {
            this.setDescription("");
        }
        try {
            this.setCategory(parameterizedCommand.getCommand().getCategory().getName());
        }
        catch (NotDefinedException notDefinedException) {
            this.setCategory(NewKeysPreferenceMessages.Unavailable_Category);
        }
        this.setConflict(Boolean.FALSE);
    }

    public void init(ParameterizedCommand parameterizedCommand) {
        this.setCommandInfo(parameterizedCommand);
        this.setTrigger(null);
        this.setContext(null);
        this.setUserDelta(new Integer(0));
        this.setModelObject(parameterizedCommand);
    }

    public TriggerSequence getTrigger() {
        return this.trigger;
    }

    public void setTrigger(TriggerSequence triggerSequence) {
        TriggerSequence triggerSequence2 = this.trigger;
        this.trigger = triggerSequence;
        this.controller.firePropertyChange(this, PROP_TRIGGER, triggerSequence2, triggerSequence);
    }

    public ContextElement getContext() {
        return this.context;
    }

    public void setContext(ContextElement contextElement) {
        ContextElement contextElement2 = this.context;
        this.context = contextElement;
        this.controller.firePropertyChange(this, PROP_CONTEXT, contextElement2, contextElement);
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String string) {
        String string2 = this.category;
        this.category = string;
        this.controller.firePropertyChange(this, PROP_CATEGORY, string2, string);
    }

    public Integer getUserDelta() {
        return this.userDelta;
    }

    public void setUserDelta(Integer n) {
        Integer n2 = this.userDelta;
        this.userDelta = n;
        this.controller.firePropertyChange(this, PROP_USER_DELTA, n2, n);
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        Image image2 = this.image;
        this.image = image;
        this.controller.firePropertyChange(this, PROP_IMAGE, image2, image);
    }

    public Boolean getConflict() {
        return this.conflict;
    }

    public void setConflict(Boolean bl) {
        Boolean bl2 = this.conflict;
        this.conflict = bl;
        this.controller.firePropertyChange(this, PROP_CONFLICT, bl2, bl);
    }

    public void fill(KeyBinding keyBinding, ContextModel contextModel) {
        this.setCommandInfo(keyBinding.getParameterizedCommand());
        this.setTrigger(keyBinding.getTriggerSequence());
        this.setContext((ContextElement)contextModel.getContextIdToElement().get(keyBinding.getContextId()));
        this.setUserDelta(new Integer(keyBinding.getType()));
        this.setModelObject(keyBinding);
    }

    public void fill(ParameterizedCommand parameterizedCommand) {
        this.setCommandInfo(parameterizedCommand);
        this.setTrigger(null);
        this.setContext(null);
        this.setUserDelta(new Integer(0));
        this.setModelObject(parameterizedCommand);
    }
}

