/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.keys;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.CommandException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.commands.util.Tracing;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.contexts.ContextService;
import org.eclipse.ui.internal.handlers.HandlerService;
import org.eclipse.ui.internal.keys.KeyAssistDialog;
import org.eclipse.ui.internal.keys.KeyBindingState;
import org.eclipse.ui.internal.keys.OutOfOrderListener;
import org.eclipse.ui.internal.keys.OutOfOrderVerifyListener;
import org.eclipse.ui.internal.misc.Policy;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.keys.IBindingService;

public final class WorkbenchKeyboard {
    private static final boolean DEBUG = Policy.DEBUG_KEY_BINDINGS;
    private static final boolean DEBUG_VERBOSE = Policy.DEBUG_KEY_BINDINGS_VERBOSE;
    private static final int DELAY = 1000;
    static KeySequence outOfOrderKeys;
    private static final ResourceBundle RESOURCE_BUNDLE;
    private IBindingService bindingService = null;
    private KeyAssistDialog keyAssistDialog = null;
    private final KeyDownFilter keyDownFilter = new KeyDownFilter();
    private final OutOfOrderListener outOfOrderListener = new OutOfOrderListener(this);
    private final OutOfOrderVerifyListener outOfOrderVerifyListener = new OutOfOrderVerifyListener(this.outOfOrderListener);
    private long startTime = Long.MAX_VALUE;
    private final KeyBindingState state;
    private final IWindowListener windowListener = new IWindowListener(){

        @Override
        public void windowActivated(IWorkbenchWindow iWorkbenchWindow) {
            WorkbenchKeyboard.this.checkActiveWindow(iWorkbenchWindow);
        }

        @Override
        public void windowClosed(IWorkbenchWindow iWorkbenchWindow) {
        }

        @Override
        public void windowDeactivated(IWorkbenchWindow iWorkbenchWindow) {
        }

        @Override
        public void windowOpened(IWorkbenchWindow iWorkbenchWindow) {
        }
    };
    private final IWorkbench workbench;

    static {
        RESOURCE_BUNDLE = ResourceBundle.getBundle(WorkbenchKeyboard.class.getName());
        try {
            outOfOrderKeys = KeySequence.getInstance((String)"ESC DEL");
        }
        catch (ParseException parseException) {
            outOfOrderKeys = KeySequence.getInstance();
            String string = "Could not parse out-of-order keys definition: 'ESC DEL'.  Continuing with no out-of-order keys.";
            WorkbenchPlugin.log(string, (IStatus)new Status(4, WorkbenchPlugin.PI_WORKBENCH, 0, string, (Throwable)parseException));
        }
    }

    public static List generatePossibleKeyStrokes(Event event) {
        int n;
        ArrayList<KeyStroke> arrayList = new ArrayList<KeyStroke>(3);
        if (event.stateMask == 0 && event.keyCode == 0 && event.character == '\u0000') {
            return arrayList;
        }
        int n2 = SWTKeySupport.convertEventToUnmodifiedAccelerator((Event)event);
        arrayList.add(SWTKeySupport.convertAcceleratorToKeyStroke((int)n2));
        if (event.character == '\u007f') {
            return arrayList;
        }
        int n3 = SWTKeySupport.convertEventToUnshiftedModifiedAccelerator((Event)event);
        if (n3 != n2) {
            arrayList.add(SWTKeySupport.convertAcceleratorToKeyStroke((int)n3));
        }
        if ((n = SWTKeySupport.convertEventToModifiedAccelerator((Event)event)) != n3 && n != n2) {
            arrayList.add(SWTKeySupport.convertAcceleratorToKeyStroke((int)n));
        }
        return arrayList;
    }

    private static boolean isOutOfOrderKey(List list) {
        KeyStroke[] keyStrokeArray = outOfOrderKeys.getKeyStrokes();
        int n = keyStrokeArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (list.contains(keyStrokeArray[n2])) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public WorkbenchKeyboard(IWorkbench iWorkbench) {
        this.workbench = iWorkbench;
        this.state = new KeyBindingState(iWorkbench);
        this.workbench.addWindowListener(this.windowListener);
    }

    private void checkActiveWindow(IWorkbenchWindow iWorkbenchWindow) {
        if (!iWorkbenchWindow.equals(this.state.getAssociatedWindow())) {
            this.resetState(true);
            this.state.setAssociatedWindow(iWorkbenchWindow);
        }
    }

    private void closeMultiKeyAssistShell() {
        Shell shell;
        if (this.keyAssistDialog != null && (shell = this.keyAssistDialog.getShell()) != null && !shell.isDisposed() && shell.isVisible()) {
            this.keyAssistDialog.close(true);
        }
    }

    final boolean executeCommand(Binding binding, Event event) throws CommandException {
        ParameterizedCommand parameterizedCommand = binding.getParameterizedCommand();
        if (DEBUG) {
            Tracing.printTrace((String)"KEYS", (String)("WorkbenchKeyboard.executeCommand(commandId = '" + parameterizedCommand.getId() + "', parameters = " + parameterizedCommand.getParameterMap() + ')'));
        }
        this.resetState(false);
        IHandlerService iHandlerService = (IHandlerService)this.workbench.getService(IHandlerService.class);
        Command command = parameterizedCommand.getCommand();
        boolean bl = command.isDefined();
        boolean bl2 = command.isHandled();
        command.setEnabled((Object)iHandlerService.getCurrentState());
        boolean bl3 = command.isEnabled();
        if (DEBUG && DEBUG_VERBOSE) {
            if (!bl) {
                Tracing.printTrace((String)"KEYS", (String)"    not defined");
            } else if (!bl2) {
                Tracing.printTrace((String)"KEYS", (String)"    not handled");
            } else if (!bl3) {
                Tracing.printTrace((String)"KEYS", (String)"    not enabled");
            }
        }
        try {
            iHandlerService.executeCommand(parameterizedCommand, event);
        }
        catch (NotDefinedException notDefinedException) {
        }
        catch (NotEnabledException notEnabledException) {
        }
        catch (NotHandledException notHandledException) {}
        if (this.keyAssistDialog != null) {
            this.keyAssistDialog.clearRememberedState();
        }
        return bl && bl2;
    }

    private void filterKeySequenceBindings(Event event) {
        if ((event.keyCode & SWT.MODIFIER_MASK) != 0) {
            return;
        }
        List list = WorkbenchKeyboard.generatePossibleKeyStrokes(event);
        if (WorkbenchKeyboard.isOutOfOrderKey(list)) {
            Widget widget = event.widget;
            if (event.character == '\u007f' && (event.stateMask & SWT.MODIFIER_MASK) == 0 && (widget instanceof Text || widget instanceof Combo || widget instanceof Browser)) {
                return;
            }
            if (widget instanceof StyledText) {
                if (event.type == 1 && !this.outOfOrderVerifyListener.isActive(event.time)) {
                    ((StyledText)widget).addVerifyKeyListener((VerifyKeyListener)this.outOfOrderVerifyListener);
                    this.outOfOrderVerifyListener.setActive(event.time);
                }
            } else if (!this.outOfOrderListener.isActive(event.time)) {
                widget.addListener(1, (Listener)this.outOfOrderListener);
                this.outOfOrderListener.setActive(event.time);
            }
        } else {
            this.processKeyEvent(list, event);
        }
    }

    public KeyDownFilter getKeyDownFilter() {
        return this.keyDownFilter;
    }

    private Binding getPerfectMatch(KeySequence keySequence) {
        return this.getBindingService().getPerfectMatch((TriggerSequence)keySequence);
    }

    private IBindingService getBindingService() {
        if (this.bindingService == null) {
            this.bindingService = (IBindingService)this.workbench.getService(IBindingService.class);
        }
        return this.bindingService;
    }

    final KeySequence getBuffer() {
        return this.state.getCurrentSequence();
    }

    private void incrementState(KeySequence keySequence) {
        final long l = this.startTime = System.currentTimeMillis();
        this.state.setCurrentSequence(keySequence);
        this.state.setAssociatedWindow(this.workbench.getActiveWorkbenchWindow());
        Display display = this.workbench.getDisplay();
        display.timerExec(1000, new Runnable(){

            @Override
            public void run() {
                if (System.currentTimeMillis() > l - 1000L && WorkbenchKeyboard.this.startTime == l) {
                    WorkbenchKeyboard.this.openMultiKeyAssistShell();
                }
            }
        });
    }

    private boolean isPartialMatch(KeySequence keySequence) {
        return this.getBindingService().isPartialMatch((TriggerSequence)keySequence);
    }

    private boolean isPerfectMatch(KeySequence keySequence) {
        return this.getBindingService().isPerfectMatch((TriggerSequence)keySequence);
    }

    final void logException(CommandException commandException, ParameterizedCommand parameterizedCommand) {
        String string;
        Throwable throwable = commandException.getCause();
        Throwable throwable2 = throwable == null ? commandException : throwable;
        String string2 = null;
        if (parameterizedCommand != null) {
            try {
                string = parameterizedCommand.getCommand().getName();
                string2 = MessageFormat.format((String)org.eclipse.ui.internal.util.Util.translateString(RESOURCE_BUNDLE, "ExecutionError.MessageCommandName"), (Object[])new Object[]{string});
            }
            catch (NotDefinedException notDefinedException) {}
        }
        if (string2 == null) {
            string2 = org.eclipse.ui.internal.util.Util.translateString(RESOURCE_BUNDLE, "ExecutionError.Message");
        }
        if ((string = throwable2.getMessage()) == null) {
            string = throwable2.getClass().getName();
        }
        Status status = new Status(4, WorkbenchPlugin.PI_WORKBENCH, 0, string, throwable2);
        WorkbenchPlugin.log(string2, (IStatus)status);
        StatusUtil.handleStatus(string2, throwable2, 2);
    }

    public final void openMultiKeyAssistShell() {
        if (this.keyAssistDialog == null) {
            this.keyAssistDialog = new KeyAssistDialog(this.workbench, this, this.state);
        }
        if (this.keyAssistDialog.getShell() == null) {
            this.keyAssistDialog.setParentShell(org.eclipse.ui.internal.util.Util.getShellToParentOn());
        }
        this.keyAssistDialog.open();
    }

    public final void openKeyAssistShell(Collection collection) {
        if (this.keyAssistDialog == null) {
            this.keyAssistDialog = new KeyAssistDialog(this.workbench, this, this.state);
        }
        if (this.keyAssistDialog.getShell() == null) {
            this.keyAssistDialog.setParentShell(org.eclipse.ui.internal.util.Util.getShellToParentOn());
        }
        this.keyAssistDialog.open(collection);
    }

    public boolean press(List list, Event event) {
        if (DEBUG && DEBUG_VERBOSE) {
            Tracing.printTrace((String)"KEYS", (String)("WorkbenchKeyboard.press(potentialKeyStrokes = " + list + ')'));
        }
        Widget widget = event.widget;
        this.updateShellKludge(widget);
        KeySequence keySequence = null;
        Object object = null;
        KeySequence keySequence2 = this.state.getCurrentSequence();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object object2;
            KeySequence keySequence3 = KeySequence.getInstance((KeySequence)keySequence2, (KeyStroke)((KeyStroke)iterator.next()));
            if (this.isPartialMatch(keySequence3)) {
                this.incrementState(keySequence3);
                return true;
            }
            if (this.isPerfectMatch(keySequence3)) {
                object2 = this.getPerfectMatch(keySequence3);
                try {
                    return this.executeCommand((Binding)object2, event) || !keySequence2.isEmpty();
                }
                catch (CommandException commandException) {
                    this.logException(commandException, object2.getParameterizedCommand());
                    return true;
                }
            }
            if (this.keyAssistDialog != null && this.keyAssistDialog.getShell() != null && (event.keyCode == 0x1000002 || event.keyCode == 0x1000001 || event.keyCode == 0x1000003 || event.keyCode == 0x1000004 || event.keyCode == 13 || event.keyCode == 0x1000005 || event.keyCode == 0x1000006)) {
                return false;
            }
            object2 = this.getBindingService().getConflictsFor((TriggerSequence)keySequence3);
            if (object2 == null) continue;
            keySequence = keySequence3;
            object = object2;
        }
        this.resetState(true);
        if (keySequence2.isEmpty() && keySequence != null) {
            this.openKeyAssistShell((Collection)object);
        }
        return !keySequence2.isEmpty();
    }

    void updateShellKludge(Widget widget) {
        if (Util.isGtk()) {
            Object object;
            ContextService contextService = (ContextService)this.workbench.getService(IContextService.class);
            if (widget instanceof Control && !widget.isDisposed()) {
                object = ((Control)widget).getShell();
                contextService.updateShellKludge((Shell)object);
            } else {
                contextService.updateShellKludge();
            }
            object = this.workbench.getService(IHandlerService.class);
            if (object instanceof HandlerService) {
                HandlerService handlerService = (HandlerService)object;
                if (widget instanceof Control && !widget.isDisposed()) {
                    Shell shell = ((Control)widget).getShell();
                    handlerService.updateShellKludge(shell);
                } else {
                    handlerService.updateShellKludge();
                }
            }
        }
    }

    void processKeyEvent(List list, Event event) {
        boolean bl = false;
        if (!list.isEmpty()) {
            bl = this.press(list, event);
        }
        if (bl) {
            switch (event.type) {
                case 1: {
                    event.doit = false;
                    break;
                }
                case 31: {
                    event.detail = 0;
                    event.doit = true;
                }
            }
            event.type = 0;
        }
    }

    private final void resetState(boolean bl) {
        this.startTime = Long.MAX_VALUE;
        this.state.reset();
        this.closeMultiKeyAssistShell();
        if (this.keyAssistDialog != null && bl) {
            this.keyAssistDialog.clearRememberedState();
        }
    }

    public final class KeyDownFilter
    implements Listener {
        private transient boolean enabled = true;

        public final void handleEvent(Event event) {
            if (!this.enabled) {
                return;
            }
            if (DEBUG && DEBUG_VERBOSE) {
                StringBuffer stringBuffer = new StringBuffer("Listener.handleEvent(type = ");
                switch (event.type) {
                    case 1: {
                        stringBuffer.append("KeyDown");
                        break;
                    }
                    case 31: {
                        stringBuffer.append("Traverse");
                        break;
                    }
                    default: {
                        stringBuffer.append(event.type);
                    }
                }
                stringBuffer.append(", stateMask = 0x" + Integer.toHexString(event.stateMask) + ", keyCode = 0x" + Integer.toHexString(event.keyCode) + ", time = " + event.time + ", character = 0x" + Integer.toHexString(event.character) + ")");
                Tracing.printTrace((String)"KEYS", (String)stringBuffer.toString());
            }
            WorkbenchKeyboard.this.filterKeySequenceBindings(event);
        }

        public final boolean isEnabled() {
            return this.enabled;
        }

        public final void setEnabled(boolean bl) {
            this.enabled = bl;
        }
    }
}

