/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.keys;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.util.Tracing;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeySequenceText;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandImageService;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.keys.CategoryPatternFilter;
import org.eclipse.ui.internal.keys.KeysPreferenceFiltersDialog;
import org.eclipse.ui.internal.keys.NewKeysPreferenceMessages;
import org.eclipse.ui.internal.keys.model.BindingElement;
import org.eclipse.ui.internal.keys.model.BindingModel;
import org.eclipse.ui.internal.keys.model.ContextElement;
import org.eclipse.ui.internal.keys.model.ContextModel;
import org.eclipse.ui.internal.keys.model.KeyController;
import org.eclipse.ui.internal.keys.model.ModelElement;
import org.eclipse.ui.internal.keys.model.SchemeElement;
import org.eclipse.ui.internal.keys.model.SchemeModel;
import org.eclipse.ui.internal.misc.Policy;
import org.eclipse.ui.keys.IBindingService;

public class NewKeysPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static boolean DEBUG = Policy.DEBUG_KEY_BINDINGS;
    private static final String TRACING_COMPONENT = "NewKeysPref";
    public static final String TAG_DIALOG_SECTION = "org.eclipse.ui.preferences.keysPreferencePage";
    private static final String TAG_FILTER_ACTION_SETS = "actionSetFilter";
    private static final String TAG_FILTER_INTERNAL = "internalFilter";
    private static final String TAG_FILTER_UNCAT = "uncategorizedFilter";
    private static final int ITEMS_TO_SHOW = 7;
    private static final int COMMAND_NAME_COLUMN = 0;
    private static final int KEY_SEQUENCE_COLUMN = 1;
    private static final int CONTEXT_COLUMN = 2;
    private static final int CATEGORY_COLUMN = 3;
    private static final int USER_DELTA_COLUMN = 4;
    private static int NUM_OF_COLUMNS = 5;
    private ComboViewer fSchemeCombo;
    private CategoryPatternFilter fPatternFilter;
    private CategoryFilterTree fFilteredTree;
    private boolean fFilterActionSetContexts = true;
    private boolean fFilterInternalContexts = true;
    private boolean fFilterWorkbenchMenuContext = !Workbench.getInstance().hasAppMenu();
    private KeyController keyController;
    private Category fDefaultCategory;
    private Label commandNameValueLabel;
    private Text fBindingText;
    private Text fDescriptionText;
    private ComboViewer fWhenCombo;
    private IBindingService fBindingService;
    private KeySequenceText fKeySequenceText;
    private TableViewer conflictViewer;
    private ICommandImageService commandImageService;
    private ICommandService commandService;

    protected Control createContents(Composite composite) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.ui.keys_preference_page_context");
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        IDialogSettings iDialogSettings = this.getDialogSettings();
        this.fPatternFilter = new CategoryPatternFilter(true, this.commandService.getCategory(null));
        if (iDialogSettings.get(TAG_FILTER_UNCAT) != null) {
            this.fPatternFilter.filterCategories(iDialogSettings.getBoolean(TAG_FILTER_UNCAT));
        }
        this.createSchemeControls(composite2);
        this.createTree(composite2);
        this.createTreeControls(composite2);
        this.createDataControls(composite2);
        this.createButtonBar(composite2);
        this.fill();
        this.applyDialogFont(composite2);
        GC gC = new GC((Drawable)this.fDescriptionText);
        gC.setFont(this.fDescriptionText.getFont());
        FontMetrics fontMetrics = gC.getFontMetrics();
        gC.dispose();
        int n = fontMetrics.getHeight() * 4;
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 2;
        gridData.heightHint = n;
        this.fDescriptionText.setLayoutData((Object)gridData);
        return composite2;
    }

    private final Control createButtonBar(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 0x1000008;
        composite2.setLayoutData((Object)gridData);
        Button button = new Button(composite2, 8);
        gridData = new GridData();
        int n = this.convertHorizontalDLUsToPixels(61);
        button.setText(NewKeysPreferenceMessages.FiltersButton_Text);
        gridData.widthHint = Math.max(n, button.computeSize((int)-1, (int)-1, (boolean)true).x) + 5;
        button.setLayoutData((Object)gridData);
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                KeysPreferenceFiltersDialog keysPreferenceFiltersDialog = new KeysPreferenceFiltersDialog(NewKeysPreferencePage.this.getShell());
                keysPreferenceFiltersDialog.setFilterActionSet(NewKeysPreferencePage.this.fFilterActionSetContexts);
                keysPreferenceFiltersDialog.setFilterInternal(NewKeysPreferencePage.this.fFilterInternalContexts);
                keysPreferenceFiltersDialog.setFilterWorkbenchMenu(NewKeysPreferencePage.this.fFilterWorkbenchMenuContext);
                keysPreferenceFiltersDialog.setFilterUncategorized(NewKeysPreferencePage.this.fFilteredTree.isFilteringCategories());
                if (keysPreferenceFiltersDialog.open() == 0) {
                    NewKeysPreferencePage.this.fFilterActionSetContexts = keysPreferenceFiltersDialog.getFilterActionSet();
                    NewKeysPreferencePage.this.fFilterInternalContexts = keysPreferenceFiltersDialog.getFilterInternal();
                    NewKeysPreferencePage.this.fFilterWorkbenchMenuContext = keysPreferenceFiltersDialog.getFilterWorkbenchMenu();
                    NewKeysPreferencePage.this.fFilteredTree.filterCategories(keysPreferenceFiltersDialog.getFilterUncategorized());
                    NewKeysPreferencePage.this.keyController.filterContexts(NewKeysPreferencePage.this.fFilterActionSetContexts, NewKeysPreferencePage.this.fFilterInternalContexts, NewKeysPreferencePage.this.fFilterWorkbenchMenuContext);
                    ISelection iSelection = NewKeysPreferencePage.this.fWhenCombo.getSelection();
                    NewKeysPreferencePage.this.fWhenCombo.setInput((Object)NewKeysPreferencePage.this.keyController.getContextModel());
                    NewKeysPreferencePage.this.fWhenCombo.setSelection(iSelection);
                }
            }
        });
        Button button2 = new Button(composite2, 8);
        n = this.convertHorizontalDLUsToPixels(61);
        button2.setText(NewKeysPreferenceMessages.ExportButton_Text);
        gridData.widthHint = Math.max(n, button2.computeSize((int)-1, (int)-1, (boolean)true).x) + 5;
        button2.setLayoutData((Object)gridData);
        button2.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                NewKeysPreferencePage.this.keyController.exportCSV(((Button)selectionEvent.getSource()).getShell());
            }
        });
        return composite2;
    }

    private final void createDataControls(Composite composite) {
        MenuItem menuItem;
        KeyStroke keyStroke2;
        Control control;
        final Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(2, true);
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        composite2.setLayoutData((Object)gridData);
        Composite composite3 = new Composite(composite2, 0);
        gridLayout = new GridLayout(3, false);
        composite3.setLayout((Layout)gridLayout);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 128;
        gridData.horizontalAlignment = 4;
        composite3.setLayoutData((Object)gridData);
        Label label = new Label(composite3, 0);
        label.setText(NewKeysPreferenceMessages.CommandNameLabel_Text);
        this.commandNameValueLabel = new Label(composite3, 0);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        this.commandNameValueLabel.setLayoutData((Object)gridData);
        Label label2 = new Label(composite3, 16384);
        label2.setText(NewKeysPreferenceMessages.CommandDescriptionLabel_Text);
        gridData = new GridData();
        gridData.verticalAlignment = 1;
        label2.setLayoutData((Object)gridData);
        this.fDescriptionText = new Text(composite3, 2122);
        Label label3 = new Label(composite3, 0);
        label3.setText(NewKeysPreferenceMessages.BindingLabel_Text);
        this.fBindingText = new Text(composite3, 2048);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.widthHint = 200;
        this.fBindingText.setLayoutData((Object)gridData);
        this.fBindingText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                NewKeysPreferencePage.this.fBindingService.setKeyFilterEnabled(false);
            }

            public void focusLost(FocusEvent focusEvent) {
                NewKeysPreferencePage.this.fBindingService.setKeyFilterEnabled(true);
            }
        });
        this.fBindingText.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (!NewKeysPreferencePage.this.fBindingService.isKeyFilterEnabled()) {
                    NewKeysPreferencePage.this.fBindingService.setKeyFilterEnabled(true);
                }
            }
        });
        this.fKeySequenceText = new KeySequenceText(this.fBindingText);
        this.fKeySequenceText.setKeyStrokeLimit(4);
        this.fKeySequenceText.addPropertyChangeListener(new IPropertyChangeListener(){

            public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (!propertyChangeEvent.getOldValue().equals(propertyChangeEvent.getNewValue())) {
                    KeySequence keySequence = NewKeysPreferencePage.this.fKeySequenceText.getKeySequence();
                    if (!keySequence.isComplete()) {
                        return;
                    }
                    BindingElement bindingElement = (BindingElement)NewKeysPreferencePage.this.keyController.getBindingModel().getSelectedElement();
                    if (bindingElement != null) {
                        bindingElement.setTrigger((TriggerSequence)keySequence);
                    }
                    NewKeysPreferencePage.this.fBindingText.setSelection(NewKeysPreferencePage.this.fBindingText.getTextLimit());
                }
            }
        });
        final Button button = new Button(composite3, 16388);
        button.setToolTipText(NewKeysPreferenceMessages.AddKeyButton_ToolTipText);
        gridData = new GridData();
        gridData.heightHint = this.fSchemeCombo.getCombo().getTextHeight();
        button.setLayoutData((Object)gridData);
        Control[] controlArray = composite2.getTabList();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n < controlArray.length) {
            control = controlArray[n];
            arrayList.add(control);
            if (this.fBindingText.equals(control)) {
                arrayList.add(button);
            }
            ++n;
        }
        Control[] controlArray2 = arrayList.toArray(new Control[arrayList.size()]);
        composite2.setTabList(controlArray2);
        control = new Menu((Control)button);
        for (final KeyStroke keyStroke2 : KeySequenceText.TRAPPED_KEYS) {
            menuItem = new MenuItem((Menu)control, 8);
            menuItem.setText(keyStroke2.format());
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    NewKeysPreferencePage.this.fKeySequenceText.insert(keyStroke2);
                    NewKeysPreferencePage.this.fBindingText.setFocus();
                    NewKeysPreferencePage.this.fBindingText.setSelection(NewKeysPreferencePage.this.fBindingText.getTextLimit());
                }
            });
        }
        button.addSelectionListener((SelectionListener)new SelectionAdapter((Menu)control){
            private final /* synthetic */ Menu val$addKeyMenu;
            {
                this.val$addKeyMenu = menu;
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                Point point = button.getLocation();
                point = composite2.toDisplay(point.x, point.y);
                Point point2 = button.getSize();
                this.val$addKeyMenu.setLocation(point.x, point.y + point2.y);
                this.val$addKeyMenu.setVisible(true);
            }
        });
        keyStroke2 = new Label(composite3, 0);
        keyStroke2.setText(NewKeysPreferenceMessages.WhenLabel_Text);
        this.fWhenCombo = new ComboViewer(composite3);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 2;
        menuItem = new ViewerComparator();
        this.fWhenCombo.setComparator((ViewerComparator)menuItem);
        this.fWhenCombo.getCombo().setVisibleItemCount(7);
        this.fWhenCombo.getCombo().setLayoutData((Object)gridData);
        this.fWhenCombo.setContentProvider((IContentProvider)new ModelContentProvider());
        this.fWhenCombo.setLabelProvider((IBaseLabelProvider)new ListLabelProvider());
        this.fWhenCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public final void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                ContextElement contextElement = (ContextElement)((IStructuredSelection)selectionChangedEvent.getSelection()).getFirstElement();
                if (contextElement != null) {
                    NewKeysPreferencePage.this.keyController.getContextModel().setSelectedElement(contextElement);
                }
            }
        });
        IPropertyChangeListener iPropertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getSource() == NewKeysPreferencePage.this.keyController.getContextModel() && "selectedElement".equals(propertyChangeEvent.getProperty())) {
                    Object object = propertyChangeEvent.getNewValue();
                    StructuredSelection structuredSelection = object == null ? null : new StructuredSelection(object);
                    NewKeysPreferencePage.this.fWhenCombo.setSelection((ISelection)structuredSelection, true);
                }
            }
        };
        this.keyController.addPropertyChangeListener(iPropertyChangeListener);
        Composite composite4 = new Composite(composite2, 0);
        gridLayout = new GridLayout(1, false);
        composite4.setLayout((Layout)gridLayout);
        gridData = new GridData(4, 4, true, true);
        composite4.setLayoutData((Object)gridData);
        new Label(composite4, 0);
        Label label4 = new Label(composite4, 0);
        label4.setText(NewKeysPreferenceMessages.ConflictsLabel_Text);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        label4.setLayoutData((Object)gridData);
        this.conflictViewer = new TableViewer(composite4, 68100);
        Table table = this.conflictViewer.getTable();
        table.setHeaderVisible(true);
        TableColumn tableColumn = new TableColumn(table, 16384);
        tableColumn.setText(NewKeysPreferenceMessages.CommandNameColumn_Text);
        tableColumn.setWidth(150);
        TableColumn tableColumn2 = new TableColumn(table, 16384);
        tableColumn2.setText(NewKeysPreferenceMessages.WhenColumn_Text);
        tableColumn2.setWidth(150);
        gridData = new GridData(4, 4, true, true);
        table.setLayoutData((Object)gridData);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(60));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(40));
        table.setLayout((Layout)tableLayout);
        this.conflictViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object object) {
                if (object instanceof Collection) {
                    return ((Collection)object).toArray();
                }
                return new Object[0];
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object object, Object object2) {
            }
        });
        this.conflictViewer.setLabelProvider((IBaseLabelProvider)new BindingElementLabelProvider(){

            @Override
            public String getColumnText(Object object, int n) {
                BindingElement bindingElement = (BindingElement)object;
                if (n == 0) {
                    return bindingElement.getName();
                }
                return bindingElement.getContext().getName();
            }
        });
        this.conflictViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                ModelElement modelElement = (ModelElement)((IStructuredSelection)selectionChangedEvent.getSelection()).getFirstElement();
                BindingModel bindingModel = NewKeysPreferencePage.this.keyController.getBindingModel();
                if (modelElement != null && modelElement != bindingModel.getSelectedElement()) {
                    StructuredSelection structuredSelection = new StructuredSelection((Object)modelElement);
                    bindingModel.setSelectedElement(modelElement);
                    NewKeysPreferencePage.this.conflictViewer.setSelection((ISelection)structuredSelection);
                    boolean bl = false;
                    TreeItem[] treeItemArray = NewKeysPreferencePage.this.fFilteredTree.getViewer().getTree().getItems();
                    int n = 0;
                    while (n < treeItemArray.length) {
                        if (treeItemArray[n].getData().equals(modelElement)) {
                            bl = true;
                            break;
                        }
                        ++n;
                    }
                    if (!bl) {
                        NewKeysPreferencePage.this.fFilteredTree.getFilterControl().setText("");
                        NewKeysPreferencePage.this.fFilteredTree.getViewer().refresh();
                        bindingModel.setSelectedElement(modelElement);
                        NewKeysPreferencePage.this.conflictViewer.setSelection((ISelection)structuredSelection);
                    }
                }
            }
        });
        IPropertyChangeListener iPropertyChangeListener2 = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getSource() == NewKeysPreferencePage.this.keyController.getConflictModel() && "selectedElement".equals(propertyChangeEvent.getProperty())) {
                    if (NewKeysPreferencePage.this.keyController.getConflictModel().getConflicts() != null) {
                        Object object = propertyChangeEvent.getNewValue();
                        StructuredSelection structuredSelection = object == null ? null : new StructuredSelection(object);
                        NewKeysPreferencePage.this.conflictViewer.setSelection((ISelection)structuredSelection, true);
                    }
                } else if ("conflicts".equals(propertyChangeEvent.getProperty())) {
                    NewKeysPreferencePage.this.conflictViewer.setInput(propertyChangeEvent.getNewValue());
                } else if ("conflictsAdd".equals(propertyChangeEvent.getProperty())) {
                    NewKeysPreferencePage.this.conflictViewer.add(propertyChangeEvent.getNewValue());
                } else if ("conflictsRemove".equals(propertyChangeEvent.getProperty())) {
                    NewKeysPreferencePage.this.conflictViewer.remove(propertyChangeEvent.getNewValue());
                }
            }
        };
        this.keyController.addPropertyChangeListener(iPropertyChangeListener2);
        IPropertyChangeListener iPropertyChangeListener3 = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                BindingElement bindingElement = null;
                boolean bl = false;
                if (propertyChangeEvent.getSource() == NewKeysPreferencePage.this.keyController.getBindingModel() && "selectedElement".equals(propertyChangeEvent.getProperty())) {
                    bindingElement = (BindingElement)propertyChangeEvent.getNewValue();
                    bl = true;
                } else if (propertyChangeEvent.getSource() == NewKeysPreferencePage.this.keyController.getBindingModel().getSelectedElement() && "modelObject".equals(propertyChangeEvent.getProperty())) {
                    bindingElement = (BindingElement)propertyChangeEvent.getSource();
                    bl = true;
                }
                if (bindingElement == null && bl) {
                    NewKeysPreferencePage.this.commandNameValueLabel.setText("");
                    NewKeysPreferencePage.this.fDescriptionText.setText("");
                    NewKeysPreferencePage.this.fBindingText.setText("");
                } else if (bindingElement != null) {
                    NewKeysPreferencePage.this.commandNameValueLabel.setText(bindingElement.getName());
                    String string = bindingElement.getDescription();
                    NewKeysPreferencePage.this.fDescriptionText.setText(string == null ? "" : string);
                    KeySequence keySequence = (KeySequence)bindingElement.getTrigger();
                    NewKeysPreferencePage.this.fKeySequenceText.setKeySequence(keySequence);
                }
            }
        };
        this.keyController.addPropertyChangeListener(iPropertyChangeListener3);
    }

    private void createTree(Composite composite) {
        this.fPatternFilter = new CategoryPatternFilter(true, this.fDefaultCategory);
        this.fPatternFilter.filterCategories(true);
        this.fFilteredTree = new CategoryFilterTree(composite, 67588, this.fPatternFilter);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        this.fFilteredTree.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.fFilteredTree.setLayoutData(gridData);
        final TreeViewer treeViewer = this.fFilteredTree.getViewer();
        Tree tree = treeViewer.getTree();
        tree.setHeaderVisible(true);
        Object object = tree.getLayoutData();
        if (object instanceof GridData) {
            gridData = (GridData)object;
            int n = tree.getItemHeight();
            if (n > 1) {
                gridData.heightHint = 7 * n;
            }
        }
        BindingModelComparator bindingModelComparator = new BindingModelComparator();
        treeViewer.setComparator((ViewerComparator)bindingModelComparator);
        TreeColumn treeColumn = new TreeColumn(tree, 16384, 0);
        treeColumn.setText(NewKeysPreferenceMessages.CommandNameColumn_Text);
        tree.setSortColumn(treeColumn);
        tree.setSortDirection(bindingModelComparator.isAscending() ? 128 : 1024);
        treeColumn.addSelectionListener((SelectionListener)new ResortColumn(bindingModelComparator, treeColumn, treeViewer, 0));
        TreeColumn treeColumn2 = new TreeColumn(tree, 16384, 1);
        treeColumn2.setText(NewKeysPreferenceMessages.TriggerSequenceColumn_Text);
        treeColumn2.addSelectionListener((SelectionListener)new ResortColumn(bindingModelComparator, treeColumn2, treeViewer, 1));
        TreeColumn treeColumn3 = new TreeColumn(tree, 16384, 2);
        treeColumn3.setText(NewKeysPreferenceMessages.WhenColumn_Text);
        treeColumn3.addSelectionListener((SelectionListener)new ResortColumn(bindingModelComparator, treeColumn3, treeViewer, 2));
        TreeColumn treeColumn4 = new TreeColumn(tree, 16384, 3);
        treeColumn4.setText(NewKeysPreferenceMessages.CategoryColumn_Text);
        treeColumn4.addSelectionListener((SelectionListener)new ResortColumn(bindingModelComparator, treeColumn4, treeViewer, 3));
        TreeColumn treeColumn5 = new TreeColumn(tree, 16384, 4);
        treeColumn5.setText(NewKeysPreferenceMessages.UserColumn_Text);
        treeColumn5.addSelectionListener((SelectionListener)new ResortColumn(bindingModelComparator, treeColumn5, treeViewer, 4));
        treeViewer.setContentProvider((IContentProvider)new ModelContentProvider());
        treeViewer.setLabelProvider((IBaseLabelProvider)new BindingElementLabelProvider(null, null));
        this.fFilteredTree.getPatternFilter().setIncludeLeadingWildcard(true);
        TreeColumn[] treeColumnArray = treeViewer.getTree().getColumns();
        treeColumnArray[0].setWidth(240);
        treeColumnArray[1].setWidth(130);
        treeColumnArray[2].setWidth(130);
        treeColumnArray[3].setWidth(130);
        treeColumnArray[4].setWidth(50);
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                ModelElement modelElement = (ModelElement)((IStructuredSelection)selectionChangedEvent.getSelection()).getFirstElement();
                NewKeysPreferencePage.this.keyController.getBindingModel().setSelectedElement(modelElement);
            }
        });
        IPropertyChangeListener iPropertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getSource() == NewKeysPreferencePage.this.keyController.getBindingModel() && "selectedElement".equals(propertyChangeEvent.getProperty())) {
                    Object object = propertyChangeEvent.getNewValue();
                    StructuredSelection structuredSelection = object == null ? null : new StructuredSelection(object);
                    treeViewer.setSelection((ISelection)structuredSelection, true);
                } else if (propertyChangeEvent.getSource() instanceof BindingElement && "modelObject".equals(propertyChangeEvent.getProperty())) {
                    treeViewer.update(propertyChangeEvent.getSource(), null);
                } else if ("bindingConflict".equals(propertyChangeEvent.getProperty())) {
                    treeViewer.update(propertyChangeEvent.getSource(), null);
                } else if ("bindings".equals(propertyChangeEvent.getProperty())) {
                    treeViewer.refresh();
                } else if ("bindingAdd".equals(propertyChangeEvent.getProperty())) {
                    treeViewer.add((Object)NewKeysPreferencePage.this.keyController.getBindingModel(), propertyChangeEvent.getNewValue());
                } else if ("bindingRemove".equals(propertyChangeEvent.getProperty())) {
                    treeViewer.remove(propertyChangeEvent.getNewValue());
                } else if ("bindingFilter".equals(propertyChangeEvent.getProperty())) {
                    treeViewer.refresh();
                }
            }
        };
        this.keyController.addPropertyChangeListener(iPropertyChangeListener);
    }

    private final Control createTreeControls(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        composite2.setLayoutData((Object)gridData);
        Button button = new Button(composite2, 8);
        gridData = new GridData();
        int n = this.convertHorizontalDLUsToPixels(61);
        button.setText(NewKeysPreferenceMessages.AddBindingButton_Text);
        gridData.widthHint = Math.max(n, button.computeSize((int)-1, (int)-1, (boolean)true).x) + 5;
        button.setLayoutData((Object)gridData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public final void widgetSelected(SelectionEvent selectionEvent) {
                NewKeysPreferencePage.this.keyController.getBindingModel().copy();
            }
        });
        Button button2 = new Button(composite2, 8);
        gridData = new GridData();
        n = this.convertHorizontalDLUsToPixels(61);
        button2.setText(NewKeysPreferenceMessages.RemoveBindingButton_Text);
        gridData.widthHint = Math.max(n, button2.computeSize((int)-1, (int)-1, (boolean)true).x) + 5;
        button2.setLayoutData((Object)gridData);
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public final void widgetSelected(SelectionEvent selectionEvent) {
                NewKeysPreferencePage.this.keyController.getBindingModel().remove();
            }
        });
        Button button3 = new Button(composite2, 8);
        gridData = new GridData();
        n = this.convertHorizontalDLUsToPixels(61);
        button3.setText(NewKeysPreferenceMessages.RestoreBindingButton_Text);
        gridData.widthHint = Math.max(n, button3.computeSize((int)-1, (int)-1, (boolean)true).x) + 5;
        button3.setLayoutData((Object)gridData);
        button3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public final void widgetSelected(SelectionEvent selectionEvent) {
                try {
                    NewKeysPreferencePage.this.fFilteredTree.setRedraw(false);
                    BindingModel bindingModel = NewKeysPreferencePage.this.keyController.getBindingModel();
                    bindingModel.restoreBinding(NewKeysPreferencePage.this.keyController.getContextModel());
                }
                finally {
                    NewKeysPreferencePage.this.fFilteredTree.setRedraw(true);
                }
            }
        });
        return composite2;
    }

    private void fill() {
        this.fSchemeCombo.setInput((Object)this.keyController.getSchemeModel());
        this.fSchemeCombo.setSelection((ISelection)new StructuredSelection((Object)this.keyController.getSchemeModel().getSelectedElement()));
        this.keyController.filterContexts(this.fFilterActionSetContexts, this.fFilterInternalContexts, this.fFilterWorkbenchMenuContext);
        this.fWhenCombo.setInput((Object)this.keyController.getContextModel());
        this.fFilteredTree.filterCategories(this.fPatternFilter.isFilteringCategories());
        this.fFilteredTree.getViewer().setInput((Object)this.keyController.getBindingModel());
    }

    private void createSchemeControls(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText(NewKeysPreferenceMessages.SchemeLabel_Text);
        this.fSchemeCombo = new ComboViewer(composite2);
        this.fSchemeCombo.setLabelProvider((IBaseLabelProvider)new ListLabelProvider());
        this.fSchemeCombo.setContentProvider((IContentProvider)new ModelContentProvider());
        GridData gridData = new GridData();
        gridData.widthHint = 150;
        gridData.horizontalAlignment = 4;
        this.fSchemeCombo.getCombo().setLayoutData((Object)gridData);
        this.fSchemeCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public final void selectionChanged(final SelectionChangedEvent selectionChangedEvent) {
                BusyIndicator.showWhile((Display)NewKeysPreferencePage.this.fFilteredTree.getViewer().getTree().getDisplay(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        SchemeElement schemeElement = (SchemeElement)((IStructuredSelection)selectionChangedEvent.getSelection()).getFirstElement();
                        NewKeysPreferencePage.this.keyController.getSchemeModel().setSelectedElement(schemeElement);
                    }
                });
            }
        });
        IPropertyChangeListener iPropertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getSource() == NewKeysPreferencePage.this.keyController.getSchemeModel() && "selectedElement".equals(propertyChangeEvent.getProperty())) {
                    Object object = propertyChangeEvent.getNewValue();
                    StructuredSelection structuredSelection = object == null ? null : new StructuredSelection(object);
                    NewKeysPreferencePage.this.fSchemeCombo.setSelection((ISelection)structuredSelection, true);
                }
            }
        };
        this.keyController.addPropertyChangeListener(iPropertyChangeListener);
    }

    @Override
    public void init(IWorkbench iWorkbench) {
        this.keyController = new KeyController();
        this.keyController.init(iWorkbench);
        this.commandService = (ICommandService)iWorkbench.getService(ICommandService.class);
        this.fDefaultCategory = this.commandService.getCategory(null);
        this.fBindingService = (IBindingService)iWorkbench.getService(IBindingService.class);
        this.commandImageService = (ICommandImageService)iWorkbench.getService(ICommandImageService.class);
    }

    public void applyData(Object object) {
        BindingElement bindingElement;
        Object object2;
        if (object instanceof ModelElement) {
            this.keyController.getBindingModel().setSelectedElement((ModelElement)object);
        }
        if (object instanceof Binding && this.fFilteredTree != null) {
            object2 = (BindingElement)this.keyController.getBindingModel().getBindingToElement().get(object);
            this.fFilteredTree.getViewer().setSelection((ISelection)new StructuredSelection(object2), true);
        }
        if (object instanceof ParameterizedCommand && (bindingElement = (BindingElement)(object2 = this.keyController.getBindingModel().getCommandToElement()).get(object)) != null) {
            this.fFilteredTree.getViewer().setSelection((ISelection)new StructuredSelection((Object)bindingElement), true);
        }
    }

    public boolean performOk() {
        this.keyController.saveBindings(this.fBindingService);
        this.saveState(this.getDialogSettings());
        return super.performOk();
    }

    public void saveState(IDialogSettings iDialogSettings) {
        if (iDialogSettings == null) {
            return;
        }
        iDialogSettings.put(TAG_FILTER_ACTION_SETS, this.fFilterActionSetContexts);
        iDialogSettings.put(TAG_FILTER_INTERNAL, this.fFilterInternalContexts);
        iDialogSettings.put(TAG_FILTER_UNCAT, this.fFilteredTree.isFilteringCategories());
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings iDialogSettings = WorkbenchPlugin.getDefault().getDialogSettings();
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection(TAG_DIALOG_SECTION);
        if (iDialogSettings2 == null) {
            iDialogSettings2 = iDialogSettings.addNewSection(TAG_DIALOG_SECTION);
        }
        return iDialogSettings2;
    }

    protected final void performDefaults() {
        String string = NewKeysPreferenceMessages.RestoreDefaultsMessageBoxText;
        String string2 = NewKeysPreferenceMessages.RestoreDefaultsMessageBoxMessage;
        boolean bl = MessageDialog.open((int)5, (Shell)this.getShell(), (String)string, (String)string2, (int)0x10000000);
        if (bl) {
            long l = 0L;
            if (DEBUG) {
                l = System.currentTimeMillis();
            }
            this.fFilteredTree.setRedraw(false);
            BusyIndicator.showWhile((Display)this.fFilteredTree.getViewer().getTree().getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    NewKeysPreferencePage.this.keyController.setDefaultBindings(NewKeysPreferencePage.this.fBindingService);
                }
            });
            this.fFilteredTree.setRedraw(true);
            if (DEBUG) {
                long l2 = System.currentTimeMillis() - l;
                Tracing.printTrace((String)TRACING_COMPONENT, (String)("performDefaults:model in " + l2 + "ms"));
            }
        }
        super.performDefaults();
    }

    public void performHelp() {
        Program.launch((String)"http://www.deltawalker.com/preferences/general-keys.jsp");
    }

    private class BindingElementLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private final LocalResourceManager localResourceManager = new LocalResourceManager(JFaceResources.getResources());

        private BindingElementLabelProvider() {
        }

        public final void dispose() {
            super.dispose();
            this.localResourceManager.dispose();
        }

        public String getText(Object object) {
            String string = this.getColumnText(object, 0);
            if (string == null) {
                super.getText(object);
            }
            StringBuffer stringBuffer = new StringBuffer(string);
            int n = 1;
            while (n < 4) {
                String string2 = this.getColumnText(object, n);
                if (string2 != null) {
                    stringBuffer.append(' ');
                    stringBuffer.append(string2);
                }
                ++n;
            }
            return stringBuffer.toString();
        }

        public String getColumnText(Object object, int n) {
            BindingElement bindingElement = (BindingElement)object;
            switch (n) {
                case 0: {
                    return bindingElement.getName();
                }
                case 1: {
                    TriggerSequence triggerSequence = bindingElement.getTrigger();
                    return triggerSequence == null ? "" : triggerSequence.format();
                }
                case 2: {
                    ContextElement contextElement = bindingElement.getContext();
                    return contextElement == null ? "" : contextElement.getName();
                }
                case 3: {
                    return bindingElement.getCategory();
                }
                case 4: {
                    if (bindingElement.getUserDelta() == 1) {
                        if (bindingElement.getConflict().equals(Boolean.TRUE)) {
                            return "CU";
                        }
                        return " U";
                    }
                    if (bindingElement.getConflict().equals(Boolean.TRUE)) {
                        return "C ";
                    }
                    return "  ";
                }
            }
            return null;
        }

        public Image getColumnImage(Object object, int n) {
            BindingElement bindingElement = (BindingElement)object;
            switch (n) {
                case 0: {
                    String string = bindingElement.getId();
                    ImageDescriptor imageDescriptor = NewKeysPreferencePage.this.commandImageService.getImageDescriptor(string);
                    if (imageDescriptor == null) {
                        return null;
                    }
                    try {
                        return this.localResourceManager.createImage(imageDescriptor);
                    }
                    catch (DeviceResourceException deviceResourceException) {
                        String string2 = "Problem retrieving image for a command '" + string + '\'';
                        Status status = new Status(4, WorkbenchPlugin.PI_WORKBENCH, 0, string2, (Throwable)deviceResourceException);
                        WorkbenchPlugin.log(string2, (IStatus)status);
                        return null;
                    }
                }
            }
            return null;
        }

        /* synthetic */ BindingElementLabelProvider(BindingElementLabelProvider bindingElementLabelProvider, BindingElementLabelProvider bindingElementLabelProvider2) {
            this();
        }
    }

    private final class BindingModelComparator
    extends ViewerComparator {
        private LinkedList sortColumns = new LinkedList();
        private boolean ascending = true;

        public BindingModelComparator() {
            int n = 0;
            while (n < NUM_OF_COLUMNS) {
                this.sortColumns.add(new Integer(n));
                ++n;
            }
        }

        public int getSortColumn() {
            return (Integer)this.sortColumns.getFirst();
        }

        public void setSortColumn(int n) {
            if (n == this.getSortColumn()) {
                return;
            }
            Integer n2 = new Integer(n);
            this.sortColumns.remove(n2);
            this.sortColumns.addFirst(n2);
        }

        public boolean isAscending() {
            return this.ascending;
        }

        public void setAscending(boolean bl) {
            this.ascending = bl;
        }

        public final int compare(Viewer viewer, Object object, Object object2) {
            int n = 0;
            Iterator iterator = this.sortColumns.iterator();
            while (iterator.hasNext() && n == 0) {
                int n2 = (Integer)iterator.next();
                n = this.compareColumn(viewer, object, object2, n2);
            }
            return this.ascending ? n : -1 * n;
        }

        private int compareColumn(Viewer viewer, Object object, Object object2, int n) {
            if (n == 4) {
                return this.sortUser(object, object2);
            }
            IBaseLabelProvider iBaseLabelProvider = ((TreeViewer)viewer).getLabelProvider();
            if (iBaseLabelProvider instanceof ITableLabelProvider) {
                ITableLabelProvider iTableLabelProvider = (ITableLabelProvider)iBaseLabelProvider;
                String string = iTableLabelProvider.getColumnText(object, n);
                String string2 = iTableLabelProvider.getColumnText(object2, n);
                if (string != null && string2 != null) {
                    return this.getComparator().compare(string, string2);
                }
            }
            return 0;
        }

        private int sortUser(Object object, Object object2) {
            int n = ((BindingElement)object).getUserDelta();
            int n2 = ((BindingElement)object2).getUserDelta();
            int n3 = n - n2;
            return n3;
        }
    }

    protected class CategoryFilterTree
    extends FilteredTree {
        private CategoryPatternFilter filter;

        protected CategoryFilterTree(Composite composite, int n, CategoryPatternFilter categoryPatternFilter) {
            super(composite, n, categoryPatternFilter, true);
            this.filter = categoryPatternFilter;
        }

        public void filterCategories(boolean bl) {
            this.filter.filterCategories(bl);
            this.textChanged();
        }

        public boolean isFilteringCategories() {
            return this.filter.isFilteringCategories();
        }
    }

    private static class ListLabelProvider
    extends LabelProvider {
        private ListLabelProvider() {
        }

        public String getText(Object object) {
            return ((ModelElement)object).getName();
        }
    }

    class ModelContentProvider
    implements ITreeContentProvider {
        ModelContentProvider() {
        }

        public Object[] getChildren(Object object) {
            if (object instanceof BindingModel) {
                return ((BindingModel)object).getBindings().toArray();
            }
            if (object instanceof ContextModel) {
                return ((ContextModel)object).getContexts().toArray();
            }
            if (object instanceof SchemeModel) {
                return ((SchemeModel)object).getSchemes().toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object object) {
            return ((ModelElement)object).getParent();
        }

        public boolean hasChildren(Object object) {
            return object instanceof BindingModel || object instanceof ContextModel || object instanceof SchemeModel;
        }

        public Object[] getElements(Object object) {
            return this.getChildren(object);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    private final class ResortColumn
    extends SelectionAdapter {
        private final BindingModelComparator comparator;
        private final TreeColumn treeColumn;
        private final TreeViewer viewer;
        private final int column;

        private ResortColumn(BindingModelComparator bindingModelComparator, TreeColumn treeColumn, TreeViewer treeViewer, int n) {
            this.comparator = bindingModelComparator;
            this.treeColumn = treeColumn;
            this.viewer = treeViewer;
            this.column = n;
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            if (this.comparator.getSortColumn() == this.column) {
                this.comparator.setAscending(!this.comparator.isAscending());
                this.viewer.getTree().setSortDirection(this.comparator.isAscending() ? 128 : 1024);
            } else {
                this.viewer.getTree().setSortColumn(this.treeColumn);
                this.comparator.setSortColumn(this.column);
            }
            try {
                this.viewer.getTree().setRedraw(false);
                this.viewer.refresh();
            }
            finally {
                this.viewer.getTree().setRedraw(true);
            }
        }
    }
}

