/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.keys;

import java.util.Comparator;
import org.eclipse.jface.util.Util;
import org.eclipse.ui.keys.ModifierKey;

class NativeModifierKeyComparator
implements Comparator {
    private static final int UNKNOWN_KEY = Integer.MAX_VALUE;

    NativeModifierKeyComparator() {
    }

    public int compare(Object object, Object object2) {
        int n;
        ModifierKey modifierKey = (ModifierKey)object;
        ModifierKey modifierKey2 = (ModifierKey)object2;
        int n2 = this.rank(modifierKey);
        if (n2 != (n = this.rank(modifierKey2))) {
            return n2 - n;
        }
        return modifierKey.compareTo(modifierKey2);
    }

    private int rank(ModifierKey modifierKey) {
        if (Util.isWindows()) {
            return this.rankWindows(modifierKey);
        }
        if (Util.isGtk()) {
            return this.rankGNOME(modifierKey);
        }
        if (Util.isMac()) {
            return this.rankMacOSX(modifierKey);
        }
        if (Util.isMotif()) {
            return this.rankGNOME(modifierKey);
        }
        return Integer.MAX_VALUE;
    }

    private final int rankGNOME(ModifierKey modifierKey) {
        if (ModifierKey.SHIFT.equals(modifierKey)) {
            return 0;
        }
        if (ModifierKey.CTRL.equals(modifierKey)) {
            return 1;
        }
        if (ModifierKey.ALT.equals(modifierKey)) {
            return 2;
        }
        return Integer.MAX_VALUE;
    }

    private final int rankMacOSX(ModifierKey modifierKey) {
        if (ModifierKey.SHIFT.equals(modifierKey)) {
            return 0;
        }
        if (ModifierKey.CTRL.equals(modifierKey)) {
            return 1;
        }
        if (ModifierKey.ALT.equals(modifierKey)) {
            return 2;
        }
        if (ModifierKey.COMMAND.equals(modifierKey)) {
            return 3;
        }
        return Integer.MAX_VALUE;
    }

    private final int rankWindows(ModifierKey modifierKey) {
        if (ModifierKey.CTRL.equals(modifierKey)) {
            return 0;
        }
        if (ModifierKey.ALT.equals(modifierKey)) {
            return 1;
        }
        if (ModifierKey.SHIFT.equals(modifierKey)) {
            return 2;
        }
        return Integer.MAX_VALUE;
    }
}

