/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.keys;

import org.eclipse.jface.bindings.BindingManager;
import org.eclipse.jface.bindings.ISchemeListener;
import org.eclipse.jface.bindings.SchemeEvent;
import org.eclipse.ui.commands.IKeyConfigurationListener;
import org.eclipse.ui.commands.KeyConfigurationEvent;
import org.eclipse.ui.internal.keys.SchemeLegacyWrapper;

final class LegacySchemeListenerWrapper
implements ISchemeListener {
    private final BindingManager bindingManager;
    private final IKeyConfigurationListener listener;

    LegacySchemeListenerWrapper(IKeyConfigurationListener iKeyConfigurationListener, BindingManager bindingManager) {
        if (iKeyConfigurationListener == null) {
            throw new NullPointerException("Cannot wrap a null listener");
        }
        if (bindingManager == null) {
            throw new NullPointerException("Cannot wrap a listener without a binding manager");
        }
        this.listener = iKeyConfigurationListener;
        this.bindingManager = bindingManager;
    }

    public final boolean equals(Object object) {
        if (object instanceof LegacySchemeListenerWrapper) {
            LegacySchemeListenerWrapper legacySchemeListenerWrapper = (LegacySchemeListenerWrapper)object;
            return this.listener.equals(legacySchemeListenerWrapper.listener);
        }
        if (object instanceof IKeyConfigurationListener) {
            IKeyConfigurationListener iKeyConfigurationListener = (IKeyConfigurationListener)object;
            return this.listener.equals(iKeyConfigurationListener);
        }
        return false;
    }

    public final int hashCode() {
        return this.listener.hashCode();
    }

    public final void schemeChanged(SchemeEvent schemeEvent) {
        SchemeLegacyWrapper schemeLegacyWrapper = new SchemeLegacyWrapper(schemeEvent.getScheme(), this.bindingManager);
        boolean bl = schemeEvent.isDefinedChanged();
        boolean bl2 = schemeEvent.isNameChanged();
        boolean bl3 = schemeEvent.isParentIdChanged();
        this.listener.keyConfigurationChanged(new KeyConfigurationEvent(schemeLegacyWrapper, false, bl, bl2, bl3));
    }
}

