/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.keys;

import com.ibm.icu.text.Collator;
import com.ibm.icu.text.MessageFormat;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.CommandManager;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.commands.contexts.Context;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.BindingManager;
import org.eclipse.jface.bindings.Scheme;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeyBinding;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeySequenceText;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.keys.ImageFactory;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.keys.IBindingService;

public final class KeysPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String BINDING_KEY = "Binding.bindings.jface.eclipse.org";
    private static final Image IMAGE_BLANK = ImageFactory.getImage("blank");
    private static final Image IMAGE_CHANGE = ImageFactory.getImage("change");
    private static final String ITEM_DATA_KEY = "org.eclipse.jface.bindings";
    private static final int ITEMS_TO_SHOW = 9;
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle(KeysPreferencePage.class.getName());
    private static final int VIEW_TOTAL_COLUMNS = 4;
    private static final String[] SORTED_COLUMN_NAMES = new String[4];
    private static final int TAB_INDEX_MODIFY = 1;
    private static final String[] UNSORTED_COLUMN_NAMES = new String[4];
    private static final int VIEW_CATEGORY_COLUMN_INDEX = 0;
    private static final int VIEW_COMMAND_COLUMN_INDEX = 1;
    private static final int VIEW_CONTEXT_COLUMN_INDEX = 3;
    private static final int VIEW_KEY_SEQUENCE_COLUMN_INDEX = 2;
    private IActivityManager activityManager;
    private IBindingService bindingService;
    private Button buttonAdd;
    private Button buttonRemove;
    private Button buttonRestore;
    private Map categoryIdsByUniqueName;
    private Map categoryUniqueNamesById;
    private Combo comboCategory;
    private Combo comboCommand;
    private Combo comboContext;
    private Combo comboScheme;
    private Map commandIdsByCategoryId;
    private ParameterizedCommand[] commands = null;
    private ICommandService commandService;
    private Map contextIdsByUniqueName;
    private IContextService contextService;
    private Map contextUniqueNamesById;
    private Label labelBindingsForCommand;
    private Label labelBindingsForTriggerSequence;
    private Label labelContextExtends;
    private Label labelSchemeExtends;
    private final BindingManager localChangeManager = new BindingManager(new ContextManager(), new CommandManager());
    private Map schemeIdsByUniqueName;
    private Map schemeUniqueNamesById;
    private int[] sortOrder;
    private TabFolder tabFolder;
    private Table tableBindings;
    private Table tableBindingsForCommand;
    private Table tableBindingsForTriggerSequence;
    private Text textTriggerSequence;
    private KeySequenceText textTriggerSequenceManager;

    static {
        KeysPreferencePage.UNSORTED_COLUMN_NAMES[0] = org.eclipse.ui.internal.util.Util.translateString(RESOURCE_BUNDLE, "tableColumnCategory");
        KeysPreferencePage.UNSORTED_COLUMN_NAMES[1] = org.eclipse.ui.internal.util.Util.translateString(RESOURCE_BUNDLE, "tableColumnCommand");
        KeysPreferencePage.UNSORTED_COLUMN_NAMES[2] = org.eclipse.ui.internal.util.Util.translateString(RESOURCE_BUNDLE, "tableColumnKeySequence");
        KeysPreferencePage.UNSORTED_COLUMN_NAMES[3] = org.eclipse.ui.internal.util.Util.translateString(RESOURCE_BUNDLE, "tableColumnContext");
        KeysPreferencePage.SORTED_COLUMN_NAMES[0] = org.eclipse.ui.internal.util.Util.translateString(RESOURCE_BUNDLE, "tableColumnCategorySorted");
        KeysPreferencePage.SORTED_COLUMN_NAMES[1] = org.eclipse.ui.internal.util.Util.translateString(RESOURCE_BUNDLE, "tableColumnCommandSorted");
        KeysPreferencePage.SORTED_COLUMN_NAMES[2] = org.eclipse.ui.internal.util.Util.translateString(RESOURCE_BUNDLE, "tableColumnKeySequenceSorted");
        KeysPreferencePage.SORTED_COLUMN_NAMES[3] = org.eclipse.ui.internal.util.Util.translateString(RESOURCE_BUNDLE, "tableColumnContextSorted");
    }

    public KeysPreferencePage() {
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        this.sortOrder = nArray;
    }

    public void applyData(Object object) {
        if (object instanceof Binding) {
            this.editBinding((Binding)object);
        }
    }

    protected final Control createContents(Composite composite) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.ui.keys_preference_page_context");
        this.tabFolder = new TabFolder(composite, 0);
        TabItem tabItem = new TabItem(this.tabFolder, 0);
        tabItem.setText(org.eclipse.ui.internal.util.Util.translateString(RESOURCE_BUNDLE, "viewTab.Text"));
        tabItem.setControl((Control)this.createViewTab(this.tabFolder));
        TabItem tabItem2 = new TabItem(this.tabFolder, 0);
        tabItem2.setText(org.eclipse.ui.internal.util.Util.translateString(RESOURCE_BUNDLE, "modifyTab.Text"));
        tabItem2.setControl((Control)this.createModifyTab(this.tabFolder));
        this.applyDialogFont((Composite)this.tabFolder);
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        int n = iPreferenceStore.getInt("KEYS_PREFERENCE_SELECTED_TAB");
        if (this.tabFolder.getItemCount() > n && n > 0) {
            this.tabFolder.setSelection(n);
        }
        return this.tabFolder;
    }

    private final Composite createModifyTab(TabFolder tabFolder) {
        MenuItem menuItem;
        KeyStroke keyStroke2;
        Control control;
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(1808);
        composite.setLayoutData((Object)gridData);
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite2.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        composite2.setLayoutData((Object)gridData);
        Label label = new Label(composite2, 16384);
        label.setText(org.eclipse.ui.internal.util.Util.translateString(RESOURCE_BUNDLE, "labelScheme"));
        this.comboScheme = new Combo(composite2, 8);
        gridData = new GridData();
        gridData.widthHint = 200;
        this.comboScheme.setLayoutData((Object)gridData);
        this.comboScheme.setVisibleItemCount(9);
        this.comboScheme.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public final void widgetSelected(SelectionEvent selectionEvent) {
                KeysPreferencePage.this.selectedComboScheme();
            }
        });
        this.labelSchemeExtends = new Label(composite2, 16384);
        gridData = new GridData(768);
        this.labelSchemeExtends.setLayoutData((Object)gridData);
        Composite composite3 = new Composite(composite, 0);
        gridData = new GridData();
        gridData.heightHint = 10;
        gridData.widthHint = 10;
        composite3.setLayoutData((Object)gridData);
        Group group = new Group(composite, 32);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        group.setLayout((Layout)gridLayout);
        gridData = new GridData(1808);
        group.setLayoutData((Object)gridData);
        group.setText(org.eclipse.ui.internal.util.Util.translateString(RESOURCE_BUNDLE, "groupCommand"));
        Label label2 = new Label((Composite)group, 16384);
        gridData = new GridData();
        label2.setLayoutData((Object)gridData);
        label2.setText(org.eclipse.ui.internal.util.Util.translateString(RESOURCE_BUNDLE, "labelCategory"));
        this.comboCategory = new Combo((Composite)group, 8);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.widthHint = 200;
        this.comboCategory.setLayoutData((Object)gridData);
        this.comboCategory.setVisibleItemCount(9);
        this.comboCategory.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public final void widgetSelected(SelectionEvent selectionEvent) {
                KeysPreferencePage.this.update();
            }
        });
        Label label3 = new Label((Composite)group, 16384);
        gridData = new GridData();
        label3.setLayoutData((Object)gridData);
        label3.setText(org.eclipse.ui.internal.util.Util.translateString(RESOURCE_BUNDLE, "labelCommand"));
        this.comboCommand = new Combo((Composite)group, 8);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.widthHint = 300;
        this.comboCommand.setLayoutData((Object)gridData);
        this.comboCommand.setVisibleItemCount(9);
        this.comboCommand.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public final void widgetSelected(SelectionEvent selectionEvent) {
                KeysPreferencePage.this.update();
            }
        });
        this.labelBindingsForCommand = new Label((Composite)group, 16384);
        gridData = new GridData(2);
        gridData.verticalAlignment = 1040;
        this.labelBindingsForCommand.setLayoutData((Object)gridData);
        this.labelBindingsForCommand.setText(org.eclipse.ui.internal.util.Util.translateString(RESOURCE_BUNDLE, "labelAssignmentsForCommand"));
        this.tableBindingsForCommand = new Table((Composite)group, 68352);
        this.tableBindingsForCommand.setHeaderVisible(true);
        gridData = new GridData(1808);
        gridData.heightHint = 60;
        gridData.horizontalSpan = 2;
        boolean bl = Util.isMac();
        gridData.widthHint = bl ? 620 : 520;
        this.tableBindingsForCommand.setLayoutData((Object)gridData);
        TableColumn tableColumn = new TableColumn(this.tableBindingsForCommand, 0, 0);
        tableColumn.setResizable(false);
        tableColumn.setText("");
        tableColumn.setWidth(20);
        TableColumn tableColumn2 = new TableColumn(this.tableBindingsForCommand, 0, 1);
        tableColumn2.setResizable(true);
        tableColumn2.setText(org.eclipse.ui.internal.util.Util.translateString(RESOURCE_BUNDLE, "tableColumnContext"));
        tableColumn2.pack();
        tableColumn2.setWidth(200);
        TableColumn tableColumn3 = new TableColumn(this.tableBindingsForCommand, 0, 2);
        tableColumn3.setResizable(true);
        tableColumn3.setText(org.eclipse.ui.internal.util.Util.translateString(RESOURCE_BUNDLE, "tableColumnKeySequence"));
        tableColumn3.pack();
        tableColumn3.setWidth(300);
        this.tableBindingsForCommand.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                KeysPreferencePage.this.update();
            }
        });
        this.tableBindingsForCommand.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                KeysPreferencePage.this.selectedTableBindingsForCommand();
            }
        });
        final Group group2 = new Group(composite, 32);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        group2.setLayout((Layout)gridLayout);
        gridData = new GridData(1808);
        group2.setLayoutData((Object)gridData);
        group2.setText(org.eclipse.ui.internal.util.Util.translateString(RESOURCE_BUNDLE, "groupKeySequence"));
        Label label4 = new Label((Composite)group2, 16384);
        gridData = new GridData();
        label4.setLayoutData((Object)gridData);
        label4.setText(org.eclipse.ui.internal.util.Util.translateString(RESOURCE_BUNDLE, "labelKeySequence"));
        this.textTriggerSequence = new Text((Composite)group2, 2048);
        this.textTriggerSequence.setFont(group2.getFont());
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.widthHint = 300;
        this.textTriggerSequence.setLayoutData((Object)gridData);
        this.textTriggerSequence.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                KeysPreferencePage.this.update();
            }
        });
        this.textTriggerSequence.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                KeysPreferencePage.this.bindingService.setKeyFilterEnabled(false);
            }

            public void focusLost(FocusEvent focusEvent) {
                KeysPreferencePage.this.bindingService.setKeyFilterEnabled(true);
            }
        });
        this.textTriggerSequence.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (!KeysPreferencePage.this.bindingService.isKeyFilterEnabled()) {
                    KeysPreferencePage.this.bindingService.setKeyFilterEnabled(true);
                }
            }
        });
        this.textTriggerSequenceManager = new KeySequenceText(this.textTriggerSequence);
        this.textTriggerSequenceManager.setKeyStrokeLimit(4);
        final Button button = new Button((Composite)group2, 16388);
        button.setToolTipText(org.eclipse.ui.internal.util.Util.translateString(RESOURCE_BUNDLE, "buttonAddKey.ToolTipText"));
        gridData = new GridData();
        gridData.heightHint = this.comboCategory.getTextHeight();
        button.setLayoutData((Object)gridData);
        Control[] controlArray = group2.getTabList();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n < controlArray.length) {
            control = controlArray[n];
            arrayList.add(control);
            if (this.textTriggerSequence.equals(control)) {
                arrayList.add(button);
            }
            ++n;
        }
        Control[] controlArray2 = arrayList.toArray(new Control[arrayList.size()]);
        group2.setTabList(controlArray2);
        control = new Menu((Control)button);
        for (final KeyStroke keyStroke2 : KeySequenceText.TRAPPED_KEYS) {
            menuItem = new MenuItem((Menu)control, 8);
            menuItem.setText(keyStroke2.format());
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    KeysPreferencePage.this.textTriggerSequenceManager.insert(keyStroke2);
                    KeysPreferencePage.this.textTriggerSequence.setFocus();
                    KeysPreferencePage.this.textTriggerSequence.setSelection(KeysPreferencePage.this.textTriggerSequence.getTextLimit());
                }
            });
        }
        button.addSelectionListener((SelectionListener)new SelectionAdapter((Menu)control){
            private final /* synthetic */ Menu val$menuButtonAddKey;
            {
                this.val$menuButtonAddKey = menu;
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                Point point = button.getLocation();
                point = group2.toDisplay(point.x, point.y);
                Point point2 = button.getSize();
                this.val$menuButtonAddKey.setLocation(point.x, point.y + point2.y);
                this.val$menuButtonAddKey.setVisible(true);
            }
        });
        this.labelBindingsForTriggerSequence = new Label((Composite)group2, 16384);
        gridData = new GridData(2);
        gridData.verticalAlignment = 1040;
        this.labelBindingsForTriggerSequence.setLayoutData((Object)gridData);
        this.labelBindingsForTriggerSequence.setText(org.eclipse.ui.internal.util.Util.translateString(RESOURCE_BUNDLE, "labelAssignmentsForKeySequence"));
        this.tableBindingsForTriggerSequence = new Table((Composite)group2, 68352);
        this.tableBindingsForTriggerSequence.setHeaderVisible(true);
        gridData = new GridData(1808);
        gridData.heightHint = 60;
        gridData.horizontalSpan = 3;
        gridData.widthHint = bl ? 620 : 520;
        this.tableBindingsForTriggerSequence.setLayoutData((Object)gridData);
        tableColumn = new TableColumn(this.tableBindingsForTriggerSequence, 0, 0);
        tableColumn.setResizable(false);
        tableColumn.setText("");
        tableColumn.setWidth(20);
        tableColumn2 = new TableColumn(this.tableBindingsForTriggerSequence, 0, 1);
        tableColumn2.setResizable(true);
        tableColumn2.setText(org.eclipse.ui.internal.util.Util.translateString(RESOURCE_BUNDLE, "tableColumnContext"));
        tableColumn2.pack();
        tableColumn2.setWidth(200);
        keyStroke2 = new TableColumn(this.tableBindingsForTriggerSequence, 0, 2);
        keyStroke2.setResizable(true);
        keyStroke2.setText(org.eclipse.ui.internal.util.Util.translateString(RESOURCE_BUNDLE, "tableColumnCommand"));
        keyStroke2.pack();
        keyStroke2.setWidth(300);
        this.tableBindingsForTriggerSequence.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                KeysPreferencePage.this.update();
            }
        });
        this.tableBindingsForTriggerSequence.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                KeysPreferencePage.this.selectedTableBindingsForTriggerSequence();
            }
        });
        menuItem = new Composite(composite, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        menuItem.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        menuItem.setLayoutData((Object)gridData);
        Label label5 = new Label((Composite)menuItem, 16384);
        label5.setText(org.eclipse.ui.internal.util.Util.translateString(RESOURCE_BUNDLE, "labelContext"));
        this.comboContext = new Combo((Composite)menuItem, 8);
        gridData = new GridData();
        gridData.widthHint = 250;
        this.comboContext.setLayoutData((Object)gridData);
        this.comboContext.setVisibleItemCount(9);
        this.comboContext.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public final void widgetSelected(SelectionEvent selectionEvent) {
                KeysPreferencePage.this.update();
            }
        });
        this.labelContextExtends = new Label((Composite)menuItem, 16384);
        gridData = new GridData(768);
        this.labelContextExtends.setLayoutData((Object)gridData);
        Composite composite4 = new Composite(composite, 0);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 20;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 3;
        composite4.setLayout((Layout)gridLayout);
        gridData = new GridData();
        composite4.setLayoutData((Object)gridData);
        this.buttonAdd = new Button(composite4, 0x1000008);
        gridData = new GridData();
        int n2 = this.convertHorizontalDLUsToPixels(61);
        this.buttonAdd.setText(org.eclipse.ui.internal.util.Util.translateString(RESOURCE_BUNDLE, "buttonAdd"));
        gridData.widthHint = Math.max(n2, this.buttonAdd.computeSize((int)-1, (int)-1, (boolean)true).x) + 5;
        this.buttonAdd.setLayoutData((Object)gridData);
        this.buttonAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                KeysPreferencePage.this.selectedButtonAdd();
            }
        });
        this.buttonRemove = new Button(composite4, 0x1000008);
        gridData = new GridData();
        n2 = this.convertHorizontalDLUsToPixels(61);
        this.buttonRemove.setText(org.eclipse.ui.internal.util.Util.translateString(RESOURCE_BUNDLE, "buttonRemove"));
        gridData.widthHint = Math.max(n2, this.buttonRemove.computeSize((int)-1, (int)-1, (boolean)true).x) + 5;
        this.buttonRemove.setLayoutData((Object)gridData);
        this.buttonRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                KeysPreferencePage.this.selectedButtonRemove();
            }
        });
        this.buttonRestore = new Button(composite4, 0x1000008);
        gridData = new GridData();
        n2 = this.convertHorizontalDLUsToPixels(61);
        this.buttonRestore.setText(org.eclipse.ui.internal.util.Util.translateString(RESOURCE_BUNDLE, "buttonRestore"));
        gridData.widthHint = Math.max(n2, this.buttonRestore.computeSize((int)-1, (int)-1, (boolean)true).x) + 5;
        this.buttonRestore.setLayoutData((Object)gridData);
        this.buttonRestore.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                KeysPreferencePage.this.selectedButtonRestore();
            }
        });
        return composite;
    }

    private final Composite createViewTab(TabFolder tabFolder) {
        GridData gridData = null;
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout());
        this.tableBindings = new Table(composite, 68352);
        this.tableBindings.setHeaderVisible(true);
        gridData = new GridData(1808);
        gridData.heightHint = 400;
        gridData.horizontalSpan = 2;
        this.tableBindings.setLayoutData((Object)gridData);
        TableColumn tableColumn = new TableColumn(this.tableBindings, 0, 0);
        tableColumn.setText(SORTED_COLUMN_NAMES[0]);
        tableColumn.addSelectionListener((SelectionListener)new SortOrderSelectionListener(0));
        TableColumn tableColumn2 = new TableColumn(this.tableBindings, 0, 1);
        tableColumn2.setText(UNSORTED_COLUMN_NAMES[1]);
        tableColumn2.addSelectionListener((SelectionListener)new SortOrderSelectionListener(1));
        TableColumn tableColumn3 = new TableColumn(this.tableBindings, 0, 2);
        tableColumn3.setText(UNSORTED_COLUMN_NAMES[2]);
        tableColumn3.addSelectionListener((SelectionListener)new SortOrderSelectionListener(2));
        TableColumn tableColumn4 = new TableColumn(this.tableBindings, 0, 3);
        tableColumn4.setText(UNSORTED_COLUMN_NAMES[3]);
        tableColumn4.addSelectionListener((SelectionListener)new SortOrderSelectionListener(3));
        this.tableBindings.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public final void widgetDefaultSelected(SelectionEvent selectionEvent) {
                KeysPreferencePage.this.selectedTableKeyBindings();
            }
        });
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        gridData = new GridData();
        gridData.horizontalAlignment = 3;
        composite2.setLayoutData((Object)gridData);
        Button button = new Button(composite2, 8);
        gridData = new GridData();
        int n = this.convertHorizontalDLUsToPixels(61);
        button.setText(org.eclipse.ui.internal.util.Util.translateString(RESOURCE_BUNDLE, "buttonEdit"));
        gridData.widthHint = Math.max(n, button.computeSize((int)-1, (int)-1, (boolean)true).x) + 5;
        button.setLayoutData((Object)gridData);
        button.addSelectionListener(new SelectionListener(){

            public final void widgetDefaultSelected(SelectionEvent selectionEvent) {
                KeysPreferencePage.this.selectedTableKeyBindings();
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                this.widgetDefaultSelected(selectionEvent);
            }
        });
        Button button2 = new Button(composite2, 8);
        gridData = new GridData();
        n = this.convertHorizontalDLUsToPixels(61);
        button2.setText(org.eclipse.ui.internal.util.Util.translateString(RESOURCE_BUNDLE, "buttonExport"));
        gridData.widthHint = Math.max(n, button2.computeSize((int)-1, (int)-1, (boolean)true).x) + 5;
        button2.setLayoutData((Object)gridData);
        button2.addSelectionListener(new SelectionListener(){

            public final void widgetDefaultSelected(SelectionEvent selectionEvent) {
                KeysPreferencePage.this.selectedButtonExport();
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                this.widgetDefaultSelected(selectionEvent);
            }
        });
        return composite;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return PrefUtil.getInternalPreferenceStore();
    }

    public final void editBinding(Binding binding) {
        this.tabFolder.setSelection(1);
        if (binding == null) {
            return;
        }
        ParameterizedCommand parameterizedCommand = binding.getParameterizedCommand();
        String string = null;
        String string2 = null;
        try {
            string = parameterizedCommand.getCommand().getCategory().getName();
            string2 = parameterizedCommand.getName();
        }
        catch (NotDefinedException notDefinedException) {
            return;
        }
        String[] stringArray = this.comboCategory.getItems();
        int n = 0;
        while (n < stringArray.length) {
            if (string.equals(stringArray[n])) break;
            ++n;
        }
        if (n >= this.comboCategory.getItemCount()) {
            return;
        }
        this.comboCategory.select(n);
        this.updateComboCommand();
        String[] stringArray2 = this.comboCommand.getItems();
        int n2 = 0;
        while (n2 < stringArray2.length) {
            if (string2.equals(stringArray2[n2])) {
                if (this.comboCommand.getSelectionIndex() == n2) break;
                this.comboCommand.select(n2);
                break;
            }
            ++n2;
        }
        if (n2 >= this.comboCommand.getItemCount()) {
            if (this.comboCommand.getSelectionIndex() != 0) {
                this.comboCommand.select(0);
            }
            this.update();
            return;
        }
        this.update();
        TableItem[] tableItemArray = this.tableBindingsForCommand.getItems();
        int n3 = 0;
        while (n3 < tableItemArray.length) {
            String string3 = tableItemArray[n3].getText(2);
            if (binding.getTriggerSequence().format().equals(string3)) break;
            ++n3;
        }
        if (n3 < this.tableBindingsForCommand.getItemCount()) {
            this.tableBindingsForCommand.select(n3);
            this.tableBindingsForCommand.notifyListeners(13, null);
            this.textTriggerSequence.setFocus();
        }
    }

    private final String getCategoryId() {
        return !this.commandIdsByCategoryId.containsKey(null) || this.comboCategory.getSelectionIndex() > 0 ? (String)this.categoryIdsByUniqueName.get(this.comboCategory.getText()) : null;
    }

    private final String getContextId() {
        return this.comboContext.getSelectionIndex() >= 0 ? (String)this.contextIdsByUniqueName.get(this.comboContext.getText()) : null;
    }

    private final KeySequence getKeySequence() {
        return this.textTriggerSequenceManager.getKeySequence();
    }

    private final ParameterizedCommand getParameterizedCommand() {
        int n = this.comboCommand.getSelectionIndex();
        if (n >= 0 && this.commands != null && n < this.commands.length) {
            return this.commands[n];
        }
        return null;
    }

    private final String getSchemeId() {
        return this.comboScheme.getSelectionIndex() >= 0 ? (String)this.schemeIdsByUniqueName.get(this.comboScheme.getText()) : null;
    }

    @Override
    public final void init(IWorkbench iWorkbench) {
        this.activityManager = iWorkbench.getActivitySupport().getActivityManager();
        this.bindingService = (IBindingService)iWorkbench.getService(IBindingService.class);
        this.commandService = (ICommandService)iWorkbench.getService(ICommandService.class);
        this.contextService = (IContextService)iWorkbench.getService(IContextService.class);
    }

    private final boolean isActive(Command command) {
        return this.activityManager.getIdentifier(command.getId()).isEnabled();
    }

    private final void logPreferenceStoreException(Throwable throwable) {
        String string = org.eclipse.ui.internal.util.Util.translateString(RESOURCE_BUNDLE, "PreferenceStoreError.Message");
        String string2 = throwable.getMessage();
        if (string2 == null) {
            string2 = string;
        }
        Status status = new Status(4, WorkbenchPlugin.PI_WORKBENCH, 0, string2, throwable);
        WorkbenchPlugin.log(string, (IStatus)status);
        StatusUtil.handleStatus(string, throwable, 2);
    }

    public final boolean performCancel() {
        this.persistSelectedTab();
        return super.performCancel();
    }

    protected final void performDefaults() {
        String string = org.eclipse.ui.internal.util.Util.translateString(RESOURCE_BUNDLE, "restoreDefaultsMessageBoxText");
        String string2 = org.eclipse.ui.internal.util.Util.translateString(RESOURCE_BUNDLE, "restoreDefaultsMessageBoxMessage");
        boolean bl = MessageDialog.open((int)5, (Shell)this.getShell(), (String)string, (String)string2, (int)0x10000000);
        if (bl) {
            String string3 = this.bindingService.getDefaultSchemeId();
            Scheme scheme = this.localChangeManager.getScheme(string3);
            try {
                this.localChangeManager.setActiveScheme(scheme);
            }
            catch (NotDefinedException notDefinedException) {}
            Binding[] bindingArray = this.localChangeManager.getBindings();
            int n = bindingArray.length;
            HashSet<Binding> hashSet = new HashSet<Binding>();
            int n2 = 0;
            while (n2 < n) {
                Binding binding = bindingArray[n2];
                if (binding.getType() != 1) {
                    hashSet.add(binding);
                }
                ++n2;
            }
            Binding[] bindingArray2 = hashSet.toArray(new Binding[hashSet.size()]);
            this.localChangeManager.setBindings(bindingArray2);
            try {
                this.bindingService.savePreferences(scheme, bindingArray2);
            }
            catch (IOException iOException) {
                this.logPreferenceStoreException(iOException);
            }
        }
        this.setScheme(this.localChangeManager.getActiveScheme());
        this.update(true);
        super.performDefaults();
    }

    public final boolean performOk() {
        try {
            this.bindingService.savePreferences(this.localChangeManager.getActiveScheme(), this.localChangeManager.getBindings());
        }
        catch (IOException iOException) {
            this.logPreferenceStoreException(iOException);
        }
        this.persistSelectedTab();
        return super.performOk();
    }

    private final void persistSelectedTab() {
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        iPreferenceStore.setValue("KEYS_PREFERENCE_SELECTED_TAB", this.tabFolder.getSelectionIndex());
    }

    private final void selectedButtonAdd() {
        ParameterizedCommand parameterizedCommand = this.getParameterizedCommand();
        String string = this.getContextId();
        String string2 = this.getSchemeId();
        KeySequence keySequence = this.getKeySequence();
        this.localChangeManager.removeBindings((TriggerSequence)keySequence, string2, string, null, null, null, 1);
        this.localChangeManager.addBinding((Binding)new KeyBinding(keySequence, parameterizedCommand, string2, string, null, null, null, 1));
        this.update(true);
    }

    private final void selectedButtonExport() {
        FileDialog fileDialog = new FileDialog(this.getShell(), 0x10002000);
        fileDialog.setFilterExtensions(new String[]{"*.csv"});
        fileDialog.setFilterNames(new String[]{org.eclipse.ui.internal.util.Util.translateString(RESOURCE_BUNDLE, "csvFilterName")});
        final String string = fileDialog.open();
        if (string == null) {
            return;
        }
        SafeRunnable safeRunnable = new SafeRunnable(){

            public final void run() throws IOException {
                Writer writer = null;
                try {
                    writer = new BufferedWriter(new FileWriter(string));
                    TableItem[] tableItemArray = KeysPreferencePage.this.tableBindings.getItems();
                    int n = KeysPreferencePage.this.tableBindings.getColumnCount();
                    int n2 = 0;
                    while (n2 < tableItemArray.length) {
                        TableItem tableItem = tableItemArray[n2];
                        int n3 = 0;
                        while (n3 < n) {
                            String string2 = org.eclipse.ui.internal.util.Util.replaceAll(tableItem.getText(n3), "\"", "\"\"");
                            writer.write("\"" + string2 + "\"");
                            if (n3 < n - 1) {
                                writer.write(44);
                            }
                            ++n3;
                        }
                        writer.write(System.getProperty("line.separator"));
                        ++n2;
                    }
                }
                catch (Throwable throwable) {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        };
        SafeRunner.run((ISafeRunnable)safeRunnable);
    }

    private final void selectedButtonRemove() {
        String string = this.getContextId();
        String string2 = this.getSchemeId();
        KeySequence keySequence = this.getKeySequence();
        this.localChangeManager.removeBindings((TriggerSequence)keySequence, string2, string, null, null, null, 1);
        this.localChangeManager.addBinding((Binding)new KeyBinding(keySequence, null, string2, string, null, null, null, 1));
        this.update(true);
    }

    private final void selectedButtonRestore() {
        String string = this.getContextId();
        String string2 = this.getSchemeId();
        KeySequence keySequence = this.getKeySequence();
        this.localChangeManager.removeBindings((TriggerSequence)keySequence, string2, string, null, null, null, 1);
        this.update(true);
    }

    private final void selectedComboScheme() {
        String string = this.getSchemeId();
        Scheme scheme = this.localChangeManager.getScheme(string);
        try {
            this.localChangeManager.setActiveScheme(scheme);
        }
        catch (NotDefinedException notDefinedException) {}
        this.update(true);
    }

    private final void selectedTableBindingsForCommand() {
        int n = this.tableBindingsForCommand.getSelectionIndex();
        if (n >= 0 && n < this.tableBindingsForCommand.getItemCount()) {
            TableItem tableItem = this.tableBindingsForCommand.getItem(n);
            KeyBinding keyBinding = (KeyBinding)tableItem.getData(ITEM_DATA_KEY);
            this.setContextId(keyBinding.getContextId());
            this.setKeySequence(keyBinding.getKeySequence());
        }
        this.update();
    }

    private final void selectedTableBindingsForTriggerSequence() {
        int n = this.tableBindingsForTriggerSequence.getSelectionIndex();
        if (n >= 0 && n < this.tableBindingsForTriggerSequence.getItemCount()) {
            TableItem tableItem = this.tableBindingsForTriggerSequence.getItem(n);
            Binding binding = (Binding)tableItem.getData(ITEM_DATA_KEY);
            this.setContextId(binding.getContextId());
        }
        this.update();
    }

    private final void selectedTableKeyBindings() {
        int n = this.tableBindings.getSelectionIndex();
        if (n != -1) {
            TableItem tableItem = this.tableBindings.getItem(n);
            Binding binding = (Binding)tableItem.getData(BINDING_KEY);
            this.editBinding(binding);
        } else {
            this.editBinding(null);
        }
    }

    private final void setContextId(String string) {
        this.comboContext.clearSelection();
        this.comboContext.deselectAll();
        String string2 = (String)this.contextUniqueNamesById.get(string);
        if (string2 == null) {
            string2 = (String)this.contextUniqueNamesById.get("org.eclipse.ui.contexts.window");
        }
        if (string2 == null) {
            string2 = "";
        }
        String[] stringArray = this.comboContext.getItems();
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length) {
            if (string2.equals(stringArray[n])) {
                this.comboContext.select(n);
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl && stringArray.length > 0) {
            this.comboContext.select(0);
        }
    }

    private final void setKeySequence(KeySequence keySequence) {
        this.textTriggerSequenceManager.setKeySequence(keySequence);
    }

    private final void setParameterizedCommand(ParameterizedCommand parameterizedCommand) {
        int n = 0;
        if (this.commands != null) {
            int n2 = this.commands.length;
            while (n < n2) {
                if (this.commands[n].equals((Object)parameterizedCommand)) {
                    if (this.comboCommand.getSelectionIndex() == n || n >= this.comboCommand.getItemCount()) break;
                    this.comboCommand.select(n);
                    break;
                }
                ++n;
            }
            if (n >= this.comboCommand.getItemCount() && this.comboCommand.getSelectionIndex() != 0) {
                this.comboCommand.select(0);
            }
        }
    }

    private final void setScheme(Scheme scheme) {
        this.comboScheme.clearSelection();
        this.comboScheme.deselectAll();
        String string = (String)this.schemeUniqueNamesById.get(scheme.getId());
        if (string != null) {
            String[] stringArray = this.comboScheme.getItems();
            int n = 0;
            while (n < stringArray.length) {
                if (string.equals(stringArray[n])) {
                    this.comboScheme.select(n);
                    break;
                }
                ++n;
            }
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public final void setVisible(boolean var1_1) {
        block31: {
            if (!var1_1) break block31;
            var2_2 = new HashMap<String, HashSet<Object>>();
            var3_3 = this.contextService.getDefinedContextIds().iterator();
            while (var3_3.hasNext()) {
                var4_4 = this.contextService.getContext((String)var3_3.next());
                try {
                    var5_5 = var4_4.getName();
                    var6_6 = (HashSet<Object>)var2_2.get(var5_5);
                    if (var6_6 == null) {
                        var6_6 = new HashSet<Object>();
                        var2_2.put((String)var5_5, (HashSet<Object>)var6_6);
                    }
                    var6_6.add(var4_4);
                }
                catch (NotDefinedException v0) {}
            }
            var3_3 = new HashMap<K, V>();
            var4_4 = this.commandService.getDefinedCommandIds().iterator();
            while (var4_4.hasNext()) {
                var5_5 = this.commandService.getCommand((String)var4_4.next());
                if (!this.isActive(var5_5)) continue;
                try {
                    var6_6 = var5_5.getName();
                    var7_7 = (HashSet<HashMap<K, V>>)var3_3.get(var6_6);
                    if (var7_7 == null) {
                        var7_7 = new HashSet<HashMap<K, V>>();
                        var3_3.put(var6_6, var7_7);
                    }
                    var7_7.add(var5_5);
                }
                catch (NotDefinedException v1) {}
            }
            this.commandIdsByCategoryId = new HashMap<K, V>();
            var4_4 = this.commandService.getDefinedCommandIds().iterator();
            while (var4_4.hasNext()) {
                var5_5 = this.commandService.getCommand((String)var4_4.next());
                if (!this.isActive(var5_5)) continue;
                try {
                    var6_6 = var5_5.getCategory().getId();
                    var7_7 = (Collection)this.commandIdsByCategoryId.get(var6_6);
                    if (var7_7 == null) {
                        var7_7 = new HashSet<E>();
                        this.commandIdsByCategoryId.put(var6_6, var7_7);
                    }
                    var7_7.add(var5_5.getId());
                }
                catch (NotDefinedException v2) {}
            }
            var4_4 = new HashMap<K, V>();
            var5_5 = this.commandService.getDefinedCategoryIds().iterator();
            while (var5_5.hasNext()) {
                var6_6 = this.commandService.getCategory((String)var5_5.next());
                try {
                    if (!this.commandIdsByCategoryId.containsKey(var6_6.getId())) continue;
                    var7_7 = var6_6.getName();
                    var8_10 = (Collection)var4_4.get(var7_7);
                    if (var8_10 == null) {
                        var8_10 = new HashSet<E>();
                        var4_4.put(var7_7, var8_10);
                    }
                    var8_10.add(var6_6);
                }
                catch (NotDefinedException v3) {}
            }
            var5_5 = new Command();
            var6_6 = this.bindingService.getDefinedSchemes();
            var7_8 = 0;
            while (var7_8 < var6_6.length) {
                var8_10 = var6_6[var7_8];
                try {
                    var9_13 = var8_10.getName();
                    var10_14 = (HashSet<Object>)var5_5.get(var9_13);
                    if (var10_14 == null) {
                        var10_14 = new HashSet<Object>();
                        var5_5.put(var9_13, var10_14);
                    }
                    var10_14.add(var8_10);
                }
                catch (NotDefinedException v4) {}
                ++var7_8;
            }
            this.contextIdsByUniqueName = new HashMap<K, V>();
            this.contextUniqueNamesById = new HashMap<K, V>();
            for (Object var8_10 : var2_2.entrySet()) {
                var9_13 = (String)var8_10.getKey();
                var10_14 = (Set)var8_10.getValue();
                var11_15 = var10_14.iterator();
                if (var10_14.size() != 1) ** GOTO lbl106
                var12_16 = (Context)var11_15.next();
                this.contextIdsByUniqueName.put(var9_13, var12_16.getId());
                this.contextUniqueNamesById.put(var12_16.getId(), var9_13);
                continue;
lbl-1000:
                // 1 sources

                {
                    var12_16 = (Context)var11_15.next();
                    var13_17 = MessageFormat.format((String)org.eclipse.ui.internal.util.Util.translateString(KeysPreferencePage.RESOURCE_BUNDLE, "uniqueName"), (Object[])new Object[]{var9_13, var12_16.getId()});
                    this.contextIdsByUniqueName.put(var13_17, var12_16.getId());
                    this.contextUniqueNamesById.put(var12_16.getId(), var13_17);
lbl106:
                    // 2 sources

                    ** while (var11_15.hasNext())
                }
lbl107:
                // 1 sources

            }
            this.categoryIdsByUniqueName = new HashMap<K, V>();
            this.categoryUniqueNamesById = new HashMap<K, V>();
            for (Object var8_10 : var4_4.entrySet()) {
                var9_13 = (String)var8_10.getKey();
                var10_14 = (Set)var8_10.getValue();
                var11_15 = var10_14.iterator();
                if (var10_14.size() != 1) ** GOTO lbl127
                var12_16 = (Category)var11_15.next();
                this.categoryIdsByUniqueName.put(var9_13, var12_16.getId());
                this.categoryUniqueNamesById.put(var12_16.getId(), var9_13);
                continue;
lbl-1000:
                // 1 sources

                {
                    var12_16 = (Category)var11_15.next();
                    var13_17 = MessageFormat.format((String)org.eclipse.ui.internal.util.Util.translateString(KeysPreferencePage.RESOURCE_BUNDLE, "uniqueName"), (Object[])new Object[]{var9_13, var12_16.getId()});
                    this.categoryIdsByUniqueName.put(var13_17, var12_16.getId());
                    this.categoryUniqueNamesById.put(var12_16.getId(), var13_17);
lbl127:
                    // 2 sources

                    ** while (var11_15.hasNext())
                }
lbl128:
                // 1 sources

            }
            this.schemeIdsByUniqueName = new HashMap<K, V>();
            this.schemeUniqueNamesById = new HashMap<K, V>();
            for (Object var8_10 : var5_5.entrySet()) {
                var9_13 = (String)var8_10.getKey();
                var10_14 = (Set)var8_10.getValue();
                var11_15 = var10_14.iterator();
                if (var10_14.size() != 1) ** GOTO lbl148
                var12_16 = (Scheme)var11_15.next();
                this.schemeIdsByUniqueName.put(var9_13, var12_16.getId());
                this.schemeUniqueNamesById.put(var12_16.getId(), var9_13);
                continue;
lbl-1000:
                // 1 sources

                {
                    var12_16 = (Scheme)var11_15.next();
                    var13_17 = MessageFormat.format((String)org.eclipse.ui.internal.util.Util.translateString(KeysPreferencePage.RESOURCE_BUNDLE, "uniqueName"), (Object[])new Object[]{var9_13, var12_16.getId()});
                    this.schemeIdsByUniqueName.put(var13_17, var12_16.getId());
                    this.schemeUniqueNamesById.put(var12_16.getId(), var13_17);
lbl148:
                    // 2 sources

                    ** while (var11_15.hasNext())
                }
lbl149:
                // 1 sources

            }
            var7_9 = this.bindingService.getActiveScheme();
            try {
                var8_11 = 0;
                while (var8_11 < var6_6.length) {
                    var9_13 = var6_6[var8_11];
                    var10_14 = this.localChangeManager.getScheme(var9_13.getId());
                    var10_14.define(var9_13.getName(), var9_13.getDescription(), var9_13.getParentId());
                    ++var8_11;
                }
                this.localChangeManager.setActiveScheme(this.bindingService.getActiveScheme());
            }
            catch (NotDefinedException v5) {
                throw new Error("There is a programmer error in the keys preference page");
            }
            this.localChangeManager.setLocale(this.bindingService.getLocale());
            this.localChangeManager.setPlatform(this.bindingService.getPlatform());
            this.localChangeManager.setBindings(this.bindingService.getBindings());
            var8_12 = new ArrayList<K>(this.categoryIdsByUniqueName.keySet());
            Collections.sort(var8_12, Collator.getInstance());
            if (this.commandIdsByCategoryId.containsKey(null)) {
                var8_12.add(0, org.eclipse.ui.internal.util.Util.translateString(KeysPreferencePage.RESOURCE_BUNDLE, "other"));
            }
            this.comboCategory.setItems(var8_12.toArray(new String[var8_12.size()]));
            this.comboCategory.clearSelection();
            this.comboCategory.deselectAll();
            if (this.commandIdsByCategoryId.containsKey(null) || !var8_12.isEmpty()) {
                this.comboCategory.select(0);
            }
            var9_13 = new ArrayList<K>(this.schemeIdsByUniqueName.keySet());
            Collections.sort(var9_13, Collator.getInstance());
            this.comboScheme.setItems(var9_13.toArray(new String[var9_13.size()]));
            this.setScheme(var7_9);
            this.update(true);
        }
        super.setVisible(var1_1);
    }

    private final void update() {
        this.update(false);
    }

    private final void update(boolean bl) {
        if (bl) {
            this.updateViewTab();
        }
        this.updateComboCommand();
        this.updateComboContext();
        KeySequence keySequence = this.getKeySequence();
        this.updateTableBindingsForTriggerSequence((TriggerSequence)keySequence);
        ParameterizedCommand parameterizedCommand = this.getParameterizedCommand();
        this.updateTableBindingsForCommand(parameterizedCommand);
        String string = this.getContextId();
        this.updateSelection(this.tableBindingsForTriggerSequence, string, (TriggerSequence)keySequence);
        this.updateSelection(this.tableBindingsForCommand, string, (TriggerSequence)keySequence);
        this.updateLabelSchemeExtends();
        this.updateLabelContextExtends();
        this.updateEnabled((TriggerSequence)keySequence, parameterizedCommand);
    }

    private final void updateComboCommand() {
        Object[] objectArray;
        ParameterizedCommand parameterizedCommand = this.getParameterizedCommand();
        String string = this.getCategoryId();
        Set set = (Set)this.commandIdsByCategoryId.get(string);
        if (set == null) {
            set = Collections.EMPTY_SET;
        }
        List list = new ArrayList();
        for (String string2 : set) {
            objectArray = this.commandService.getCommand(string2);
            try {
                list.addAll(ParameterizedCommand.generateCombinations((Command)objectArray));
            }
            catch (NotDefinedException notDefinedException) {}
        }
        list = this.sortParameterizedCommands(list);
        int n = list.size();
        this.commands = list.toArray(new ParameterizedCommand[n]);
        objectArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            try {
                objectArray[n2] = this.commands[n2].getName();
            }
            catch (NotDefinedException notDefinedException) {
                throw new Error("Concurrent modification of the command's defined state");
            }
            ++n2;
        }
        Object[] objectArray2 = this.comboCommand.getItems();
        if (!Arrays.equals(objectArray2, objectArray)) {
            this.comboCommand.setItems((String[])objectArray);
        }
        this.setParameterizedCommand(parameterizedCommand);
        if (this.comboCommand.getSelectionIndex() == -1 && n > 0) {
            this.comboCommand.select(0);
        }
    }

    private List sortParameterizedCommands(List list) {
        final Collator collator = Collator.getInstance();
        Comparator comparator = new Comparator(){

            public int compare(Object object, Object object2) {
                String string = null;
                String string2 = null;
                try {
                    string = ((ParameterizedCommand)object).getName();
                }
                catch (NotDefinedException notDefinedException) {
                    return -1;
                }
                try {
                    string2 = ((ParameterizedCommand)object2).getName();
                }
                catch (NotDefinedException notDefinedException) {
                    return 1;
                }
                int n = collator.compare(string, string2);
                if (n != 0) {
                    return n;
                }
                String string3 = ((ParameterizedCommand)object).getId();
                String string4 = ((ParameterizedCommand)object2).getId();
                return collator.compare(string3, string4);
            }
        };
        Collections.sort(list, comparator);
        return list;
    }

    private final void updateComboContext() {
        String string = this.getContextId();
        HashMap hashMap = new HashMap(this.contextIdsByUniqueName);
        ArrayList arrayList = new ArrayList(hashMap.keySet());
        Collections.sort(arrayList, Collator.getInstance());
        this.comboContext.setItems(arrayList.toArray(new String[arrayList.size()]));
        this.setContextId(string);
        if (this.comboContext.getSelectionIndex() == -1 && !arrayList.isEmpty()) {
            this.comboContext.select(0);
        }
    }

    private final void updateEnabled(TriggerSequence triggerSequence, ParameterizedCommand parameterizedCommand) {
        boolean bl = parameterizedCommand != null;
        this.labelBindingsForCommand.setEnabled(bl);
        this.tableBindingsForCommand.setEnabled(bl);
        boolean bl2 = !triggerSequence.isEmpty();
        this.labelBindingsForTriggerSequence.setEnabled(bl2);
        this.tableBindingsForTriggerSequence.setEnabled(bl2);
        boolean bl3 = bl && bl2;
        this.buttonAdd.setEnabled(bl3);
        this.buttonRemove.setEnabled(bl3);
        this.buttonRestore.setEnabled(bl3);
    }

    private final void updateLabelContextExtends() {
        Context context;
        String string = this.getContextId();
        if (string != null && (context = this.contextService.getContext(this.getContextId())).isDefined()) {
            try {
                String string2;
                String string3 = context.getParentId();
                if (string3 != null && (string2 = (String)this.contextUniqueNamesById.get(string3)) != null) {
                    this.labelContextExtends.setText(MessageFormat.format((String)org.eclipse.ui.internal.util.Util.translateString(RESOURCE_BUNDLE, "extends"), (Object[])new Object[]{string2}));
                    return;
                }
            }
            catch (NotDefinedException notDefinedException) {}
        }
        this.labelContextExtends.setText("");
    }

    private final void updateLabelSchemeExtends() {
        String string = this.getSchemeId();
        if (string != null) {
            Scheme scheme = this.bindingService.getScheme(string);
            try {
                String string2 = (String)this.schemeUniqueNamesById.get(scheme.getParentId());
                if (string2 != null) {
                    this.labelSchemeExtends.setText(MessageFormat.format((String)org.eclipse.ui.internal.util.Util.translateString(RESOURCE_BUNDLE, "extends"), (Object[])new Object[]{string2}));
                    return;
                }
            }
            catch (NotDefinedException notDefinedException) {}
        }
        this.labelSchemeExtends.setText("");
    }

    private final void updateSelection(Table table, String string, TriggerSequence triggerSequence) {
        if (table.getSelectionCount() > 1) {
            table.deselectAll();
        }
        TableItem[] tableItemArray = table.getItems();
        int n = -1;
        int n2 = 0;
        while (n2 < tableItemArray.length) {
            Binding binding = (Binding)tableItemArray[n2].getData(ITEM_DATA_KEY);
            if (org.eclipse.ui.internal.util.Util.equals(string, binding.getContextId()) && org.eclipse.ui.internal.util.Util.equals(triggerSequence, binding.getTriggerSequence())) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n != -1) {
            table.select(n);
        }
    }

    private final void updateTableBindingsForCommand(ParameterizedCommand parameterizedCommand) {
        this.tableBindingsForCommand.removeAll();
        Collection collection = this.localChangeManager.getActiveBindingsDisregardingContextFlat();
        for (Binding binding : collection) {
            if (!org.eclipse.ui.internal.util.Util.equals(parameterizedCommand, binding.getParameterizedCommand())) continue;
            TableItem tableItem = new TableItem(this.tableBindingsForCommand, 0);
            tableItem.setData(ITEM_DATA_KEY, (Object)binding);
            if (binding.getType() == 0) {
                tableItem.setImage(0, IMAGE_BLANK);
            } else {
                tableItem.setImage(0, IMAGE_CHANGE);
            }
            String string = (String)this.contextUniqueNamesById.get(binding.getContextId());
            if (string == null) {
                string = "";
            }
            tableItem.setText(1, string);
            tableItem.setText(2, binding.getTriggerSequence().format());
        }
    }

    private final void updateTableBindingsForTriggerSequence(TriggerSequence triggerSequence) {
        this.tableBindingsForTriggerSequence.removeAll();
        Map map = this.localChangeManager.getActiveBindingsDisregardingContext();
        Collection collection = (Collection)map.get(triggerSequence);
        if (collection == null) {
            return;
        }
        for (Binding binding : collection) {
            Context context = this.contextService.getContext(binding.getContextId());
            ParameterizedCommand parameterizedCommand = binding.getParameterizedCommand();
            Command command = parameterizedCommand.getCommand();
            if (!context.isDefined() && !command.isDefined()) continue;
            TableItem tableItem = new TableItem(this.tableBindingsForTriggerSequence, 0);
            tableItem.setData(ITEM_DATA_KEY, (Object)binding);
            if (binding.getType() == 0) {
                tableItem.setImage(0, IMAGE_BLANK);
            } else {
                tableItem.setImage(0, IMAGE_CHANGE);
            }
            try {
                tableItem.setText(1, context.getName());
                tableItem.setText(2, parameterizedCommand.getName());
            }
            catch (NotDefinedException notDefinedException) {
                throw new Error("Context or command became undefined on a non-UI thread while the UI thread was processing.");
            }
        }
    }

    private final void updateViewTab() {
        this.tableBindings.removeAll();
        ArrayList arrayList = new ArrayList(this.localChangeManager.getActiveBindingsDisregardingContextFlat());
        Collections.sort(arrayList, new Comparator(){

            public final int compare(Object object, Object object2) {
                Command command;
                Binding binding = (Binding)object;
                Binding binding2 = (Binding)object2;
                Command command2 = binding.getParameterizedCommand().getCommand();
                String string = "";
                String string2 = "";
                try {
                    string2 = command2.getName();
                    string = command2.getCategory().getName();
                }
                catch (NotDefinedException notDefinedException) {}
                String string3 = binding.getTriggerSequence().format();
                String string4 = binding.getContextId();
                String string5 = "";
                if (string4 != null) {
                    command = KeysPreferencePage.this.contextService.getContext(string4);
                    try {
                        string5 = command.getName();
                    }
                    catch (NotDefinedException notDefinedException) {}
                }
                command = binding2.getParameterizedCommand().getCommand();
                String string6 = "";
                String string7 = "";
                try {
                    string7 = command.getName();
                    string6 = command.getCategory().getName();
                }
                catch (NotDefinedException notDefinedException) {}
                String string8 = binding2.getTriggerSequence().format();
                String string9 = binding2.getContextId();
                String string10 = "";
                if (string9 != null) {
                    Context context = KeysPreferencePage.this.contextService.getContext(string9);
                    try {
                        string10 = context.getName();
                    }
                    catch (NotDefinedException notDefinedException) {}
                }
                int n = 0;
                int n2 = 0;
                while (n2 < KeysPreferencePage.this.sortOrder.length) {
                    switch (KeysPreferencePage.this.sortOrder[n2]) {
                        case 0: {
                            n = org.eclipse.ui.internal.util.Util.compare((Comparable)((Object)string), (Comparable)((Object)string6));
                            if (n == 0) break;
                            return n;
                        }
                        case 1: {
                            n = org.eclipse.ui.internal.util.Util.compare((Comparable)((Object)string2), (Comparable)((Object)string7));
                            if (n == 0) break;
                            return n;
                        }
                        case 2: {
                            n = org.eclipse.ui.internal.util.Util.compare((Comparable)((Object)string3), (Comparable)((Object)string8));
                            if (n == 0) break;
                            return n;
                        }
                        case 3: {
                            n = org.eclipse.ui.internal.util.Util.compare((Comparable)((Object)string5), (Comparable)((Object)string10));
                            if (n == 0) break;
                            return n;
                        }
                        default: {
                            throw new Error("Programmer error: added another sort column without modifying the comparator.");
                        }
                    }
                    ++n2;
                }
                return n;
            }

            @Override
            public final boolean equals(Object object) {
                return super.equals(object);
            }
        });
        for (Binding binding : arrayList) {
            Context context;
            ParameterizedCommand parameterizedCommand = binding.getParameterizedCommand();
            String string = "";
            String string2 = "";
            try {
                string = parameterizedCommand.getName();
                string2 = parameterizedCommand.getCommand().getCategory().getName();
            }
            catch (NotDefinedException notDefinedException) {}
            if (string == null || string.length() == 0) continue;
            String string3 = binding.getContextId();
            String string4 = "";
            if (string3 != null) {
                context = this.contextService.getContext(string3);
                try {
                    string4 = context.getName();
                }
                catch (NotDefinedException notDefinedException) {}
            }
            context = new TableItem(this.tableBindings, 0);
            context.setText(0, string2);
            context.setText(1, string);
            context.setText(2, binding.getTriggerSequence().format());
            context.setText(3, string4);
            context.setData(BINDING_KEY, (Object)binding);
        }
        int n = 0;
        while (n < this.tableBindings.getColumnCount()) {
            this.tableBindings.getColumn(n).pack();
            ++n;
        }
    }

    private class SortOrderSelectionListener
    extends SelectionAdapter {
        private final int columnSelected;

        private SortOrderSelectionListener(int n) {
            this.columnSelected = n;
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            int n = KeysPreferencePage.this.sortOrder[0];
            TableColumn tableColumn = KeysPreferencePage.this.tableBindings.getColumn(n);
            tableColumn.setText(UNSORTED_COLUMN_NAMES[n]);
            TableColumn tableColumn2 = KeysPreferencePage.this.tableBindings.getColumn(this.columnSelected);
            tableColumn2.setText(SORTED_COLUMN_NAMES[this.columnSelected]);
            boolean bl = false;
            boolean bl2 = false;
            int n2 = -1;
            int n3 = 0;
            while (n3 < KeysPreferencePage.this.sortOrder.length) {
                if (KeysPreferencePage.this.sortOrder[n3] == this.columnSelected) {
                    bl2 = true;
                    if (n2 != -1) {
                        ((KeysPreferencePage)KeysPreferencePage.this).sortOrder[n3] = n2;
                        break;
                    }
                    bl = true;
                    break;
                }
                if (bl) {
                    int n4 = KeysPreferencePage.this.sortOrder[n3];
                    ((KeysPreferencePage)KeysPreferencePage.this).sortOrder[n3] = n2;
                    n2 = n4;
                } else {
                    n2 = KeysPreferencePage.this.sortOrder[n3];
                    ((KeysPreferencePage)KeysPreferencePage.this).sortOrder[n3] = this.columnSelected;
                    bl = true;
                }
                ++n3;
            }
            if (!bl2) {
                int[] nArray = new int[KeysPreferencePage.this.sortOrder.length + 1];
                System.arraycopy(KeysPreferencePage.this.sortOrder, 0, nArray, 0, KeysPreferencePage.this.sortOrder.length);
                nArray[((KeysPreferencePage)KeysPreferencePage.this).sortOrder.length] = n2;
                KeysPreferencePage.this.sortOrder = nArray;
            }
            KeysPreferencePage.this.updateViewTab();
        }
    }
}

