/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.keys;

import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.StatusLineContributionItem;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.WorkbenchWindow;

class KeyBindingState {
    private IWorkbenchWindow associatedWindow;
    private KeySequence currentSequence = KeySequence.getInstance();
    private final IWorkbench workbench;

    KeyBindingState(IWorkbench iWorkbench) {
        this.workbench = iWorkbench;
        this.associatedWindow = this.workbench.getActiveWorkbenchWindow();
    }

    IWorkbenchWindow getAssociatedWindow() {
        return this.associatedWindow;
    }

    KeySequence getCurrentSequence() {
        return this.currentSequence;
    }

    StatusLineContributionItem getStatusLine() {
        IContributionItem iContributionItem;
        WorkbenchWindow workbenchWindow;
        StatusLineManager statusLineManager;
        if (this.associatedWindow instanceof WorkbenchWindow && (statusLineManager = (workbenchWindow = (WorkbenchWindow)this.associatedWindow).getStatusLineManager()) != null && (iContributionItem = statusLineManager.find("ModeContributionItem")) instanceof StatusLineContributionItem) {
            return (StatusLineContributionItem)iContributionItem;
        }
        return null;
    }

    void reset() {
        this.currentSequence = KeySequence.getInstance();
        this.updateStatusLines();
    }

    void setAssociatedWindow(IWorkbenchWindow iWorkbenchWindow) {
        this.associatedWindow = iWorkbenchWindow;
    }

    void setCurrentSequence(KeySequence keySequence) {
        this.currentSequence = keySequence;
        this.updateStatusLines();
    }

    private void updateStatusLines() {
        StatusLineContributionItem statusLineContributionItem = this.getStatusLine();
        if (statusLineContributionItem != null) {
            statusLineContributionItem.setText(this.getCurrentSequence().format());
        }
    }
}

