/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.keys;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.CommandException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.internal.keys.KeyAssistMessages;
import org.eclipse.ui.internal.keys.KeyBindingState;
import org.eclipse.ui.internal.keys.WorkbenchKeyboard;
import org.eclipse.ui.keys.IBindingService;

final class KeyAssistDialog
extends PopupDialog {
    private static final String BINDING_KEY = "Binding.bindings.jface.eclipse.org";
    private static final int NO_REMEMBERED_WIDTH = -1;
    private final IActivityManager activityManager;
    private final IBindingService bindingService;
    private Binding binding = null;
    private final List bindings = new ArrayList();
    private final ICommandService commandService;
    private Table completionsTable = null;
    private boolean hasRememberedState = false;
    private final KeyBindingState keyBindingState;
    private int previousWidth = -1;
    private final WorkbenchKeyboard workbenchKeyboard;
    private SortedMap conflictMatches;

    KeyAssistDialog(IWorkbench iWorkbench, WorkbenchKeyboard workbenchKeyboard, KeyBindingState keyBindingState) {
        super(null, 4, true, false, false, false, null, null);
        this.activityManager = iWorkbench.getActivitySupport().getActivityManager();
        this.bindingService = (IBindingService)iWorkbench.getService(IBindingService.class);
        this.commandService = (ICommandService)iWorkbench.getService(ICommandService.class);
        this.keyBindingState = keyBindingState;
        this.workbenchKeyboard = workbenchKeyboard;
        this.setInfoText(this.getKeySequenceString());
    }

    final void clearRememberedState() {
        this.previousWidth = -1;
        this.binding = null;
        this.hasRememberedState = false;
    }

    public final boolean close() {
        return this.close(false);
    }

    public final boolean close(boolean bl) {
        return this.close(bl, true);
    }

    private final boolean close(boolean bl, boolean bl2) {
        Shell shell = this.getShell();
        if (bl) {
            Binding binding;
            int n = shell != null && !shell.isDisposed() ? this.getShell().getSize().x : -1;
            if (this.completionsTable != null && !this.completionsTable.isDisposed()) {
                int n2 = this.completionsTable.getSelectionIndex();
                if (n2 != -1) {
                    TableItem tableItem = this.completionsTable.getItem(n2);
                    binding = (Binding)tableItem.getData(BINDING_KEY);
                } else {
                    binding = null;
                }
            } else {
                binding = null;
            }
            this.rememberState(n, binding);
            this.completionsTable = null;
        }
        if (bl2) {
            this.keyBindingState.reset();
        }
        return super.close();
    }

    private final void configureLocation(Point point) {
        int n;
        int n2;
        Rectangle rectangle;
        Shell shell = this.getShell();
        Shell shell2 = this.keyBindingState.getAssociatedWindow().getShell();
        if (shell2 != null) {
            rectangle = shell2.getBounds();
            n2 = rectangle.x + rectangle.width - point.x - 10;
            n = rectangle.y + rectangle.height - point.y - 10;
        } else {
            n2 = 0;
            n = 0;
        }
        rectangle = new Rectangle(n2, n, point.x, point.y);
        shell.setBounds(this.getConstrainedShellBounds(rectangle));
    }

    private final Point configureSize() {
        Shell shell;
        Shell shell2 = this.getShell();
        shell2.pack();
        Point point = shell2.getSize();
        if (this.previousWidth != -1 && this.previousWidth > point.x) {
            point.x = this.previousWidth;
        }
        if ((shell = this.keyBindingState.getAssociatedWindow().getShell()) != null) {
            Point point2 = shell.getSize();
            int n = point2.x * 2 / 5;
            int n2 = point2.y / 2;
            if (point.x > n) {
                point.x = n;
            }
            if (point.y > n2) {
                point.y = n2;
            }
        }
        shell2.setSize(point);
        return point;
    }

    private String getKeySequenceString() {
        Command command = this.commandService.getCommand("org.eclipse.ui.window.showKeyAssist");
        TriggerSequence[] triggerSequenceArray = this.bindingService.getActiveBindingsFor(new ParameterizedCommand(command, null));
        int n = triggerSequenceArray.length;
        KeySequence keySequence = this.keyBindingState.getCurrentSequence();
        int n2 = keySequence.getKeyStrokes().length;
        KeySequence keySequence2 = null;
        int n3 = 0;
        while (n3 < n) {
            keySequence2 = (KeySequence)triggerSequenceArray[n3];
            if (n2 <= 0) break;
            if (keySequence2.startsWith((TriggerSequence)keySequence, false)) {
                KeyStroke[] keyStrokeArray = keySequence2.getKeyStrokes();
                int n4 = keyStrokeArray.length - n2;
                KeyStroke[] keyStrokeArray2 = new KeyStroke[n4];
                System.arraycopy(keyStrokeArray, n2, keyStrokeArray2, 0, n4);
                keySequence2 = KeySequence.getInstance((KeyStroke[])keyStrokeArray2);
                break;
            }
            keySequence2 = null;
            ++n3;
        }
        if (keySequence2 == null) {
            return null;
        }
        return NLS.bind((String)KeyAssistMessages.openPreferencePage, (Object)keySequence2.format());
    }

    protected final Control createDialogArea(Composite composite) {
        SortedMap sortedMap;
        this.registerShellType();
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(1808));
        composite2.setBackground(composite.getBackground());
        if (this.conflictMatches != null) {
            sortedMap = this.conflictMatches;
            this.conflictMatches = null;
        } else {
            sortedMap = this.getPartialMatches();
        }
        if (sortedMap.isEmpty()) {
            this.createEmptyDialogArea(composite2);
        } else {
            this.createTableDialogArea(composite2, sortedMap);
        }
        return composite2;
    }

    private final void createEmptyDialogArea(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(KeyAssistMessages.NoMatches_Message);
        label.setLayoutData((Object)new GridData(1808));
        label.setBackground(composite.getBackground());
    }

    private final void createTableDialogArea(Composite composite, SortedMap sortedMap) {
        this.completionsTable = new Table(composite, 65540);
        GridData gridData = new GridData(1808);
        this.completionsTable.setLayoutData((Object)gridData);
        this.completionsTable.setBackground(composite.getBackground());
        this.completionsTable.setLinesVisible(true);
        this.bindings.clear();
        TableColumn tableColumn = new TableColumn(this.completionsTable, 16384, 0);
        TableColumn tableColumn2 = new TableColumn(this.completionsTable, 16384, 1);
        for (Map.Entry entry : sortedMap.entrySet()) {
            String string = (String)entry.getValue();
            Binding binding = (Binding)entry.getKey();
            ParameterizedCommand parameterizedCommand = binding.getParameterizedCommand();
            try {
                String[] stringArray = new String[]{parameterizedCommand.getName(), string};
                TableItem tableItem = new TableItem(this.completionsTable, 0);
                tableItem.setText(stringArray);
                tableItem.setData(BINDING_KEY, (Object)binding);
                this.bindings.add(binding);
            }
            catch (NotDefinedException notDefinedException) {}
        }
        Dialog.applyDialogFont((Control)composite);
        tableColumn2.pack();
        if (this.previousWidth != -1) {
            tableColumn2.setWidth(this.previousWidth);
        }
        tableColumn.pack();
        if (this.completionsTable.getItems().length > 0) {
            this.completionsTable.setSelection(0);
        }
        this.completionsTable.addListener(14, new Listener(){

            public final void handleEvent(Event event) {
                KeyAssistDialog.this.executeKeyBinding(event);
            }
        });
    }

    private final void editKeyBinding() {
        PreferenceDialog preferenceDialog = PreferencesUtil.createPreferenceDialogOn(this.getShell(), "org.eclipse.ui.preferencePages.Keys", null, this.binding);
        this.clearRememberedState();
        preferenceDialog.open();
    }

    private final void executeKeyBinding(Event event) {
        int n = this.completionsTable.getSelectionIndex();
        if (n >= 0) {
            Binding binding = (Binding)this.bindings.get(n);
            try {
                this.workbenchKeyboard.updateShellKludge(null);
                this.workbenchKeyboard.executeCommand(binding, event);
            }
            catch (CommandException commandException) {
                this.workbenchKeyboard.logException(commandException, binding.getParameterizedCommand());
            }
        }
    }

    private final SortedMap getPartialMatches() {
        Map map = this.bindingService.getPartialMatches((TriggerSequence)this.keyBindingState.getCurrentSequence());
        TreeMap<Binding, String> treeMap = new TreeMap<Binding, String>(new Comparator(){

            public final int compare(Object object, Object object2) {
                Binding binding = (Binding)object;
                Binding binding2 = (Binding)object2;
                ParameterizedCommand parameterizedCommand = binding.getParameterizedCommand();
                ParameterizedCommand parameterizedCommand2 = binding2.getParameterizedCommand();
                try {
                    return parameterizedCommand.getName().compareTo(parameterizedCommand2.getName());
                }
                catch (NotDefinedException notDefinedException) {
                    return 0;
                }
            }
        });
        for (Map.Entry entry : map.entrySet()) {
            Binding binding = (Binding)entry.getValue();
            Command command = binding.getParameterizedCommand().getCommand();
            if (!command.isDefined() || !this.activityManager.getIdentifier(command.getId()).isEnabled()) continue;
            TriggerSequence triggerSequence = this.bindingService.getBestActiveBindingFor(binding.getParameterizedCommand());
            treeMap.put(binding, triggerSequence == null ? null : triggerSequence.format());
        }
        return treeMap;
    }

    private final boolean hasRememberedState() {
        return this.hasRememberedState;
    }

    public final int open() {
        if (this.hasRememberedState()) {
            this.editKeyBinding();
            this.clearRememberedState();
            return 0;
        }
        Shell shell = this.getShell();
        if (shell != null) {
            this.close(false, false);
        }
        this.create();
        Point point = this.configureSize();
        this.configureLocation(point);
        return super.open();
    }

    public final int open(Collection collection) {
        Point point;
        Shell shell;
        this.conflictMatches = new TreeMap(new Comparator(){

            public final int compare(Object object, Object object2) {
                Binding binding = (Binding)object;
                Binding binding2 = (Binding)object2;
                ParameterizedCommand parameterizedCommand = binding.getParameterizedCommand();
                ParameterizedCommand parameterizedCommand2 = binding2.getParameterizedCommand();
                try {
                    return parameterizedCommand.getName().compareTo(parameterizedCommand2.getName());
                }
                catch (NotDefinedException notDefinedException) {
                    return 0;
                }
            }
        });
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            point = this.bindingService.getBestActiveBindingFor((shell = (Binding)iterator.next()).getParameterizedCommand());
            this.conflictMatches.put(shell, point == null ? null : point.format());
        }
        shell = this.getShell();
        if (shell != null) {
            this.close(false, false);
        }
        this.create();
        point = this.configureSize();
        this.configureLocation(point);
        return super.open();
    }

    private final void registerShellType() {
        Shell shell = this.getShell();
        IContextService iContextService = (IContextService)this.keyBindingState.getAssociatedWindow().getWorkbench().getService(IContextService.class);
        iContextService.registerShell(shell, iContextService.getShellType((Shell)shell.getParent()));
    }

    private final void rememberState(int n, Binding binding) {
        this.previousWidth = n;
        this.binding = binding;
        this.hasRememberedState = true;
    }

    protected final void setParentShell(Shell shell) {
        super.setParentShell(shell);
    }
}

