/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.keys;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.util.ImageSupport;

final class ImageFactory {
    private static ImageRegistry imageRegistry = new ImageRegistry();
    private static Map map = new HashMap();

    static {
        ImageFactory.put("blank", "$nl$/icons/full/obj16/blank.gif");
        ImageFactory.put("change", "$nl$/icons/full/obj16/change_obj.gif");
        ImageFactory.put("minus", "$nl$/icons/full/obj16/delete_obj.gif");
        ImageFactory.put("plus", "$nl$/icons/full/obj16/add_obj.gif");
    }

    ImageFactory() {
    }

    static Image getImage(String string) {
        ImageDescriptor imageDescriptor;
        Image image = imageRegistry.get(string);
        if (image == null && (imageDescriptor = ImageFactory.getImageDescriptor(string)) != null) {
            image = imageDescriptor.createImage(false);
            if (image == null) {
                WorkbenchPlugin.log(ImageFactory.class + ": error creating image for " + string);
            }
            imageRegistry.put(string, image);
        }
        return image;
    }

    static ImageDescriptor getImageDescriptor(String string) {
        ImageDescriptor imageDescriptor = (ImageDescriptor)map.get(string);
        if (imageDescriptor == null) {
            WorkbenchPlugin.log(ImageFactory.class + ": no image descriptor for " + string);
        }
        return imageDescriptor;
    }

    private static void put(String string, String string2) {
        map.put(string, ImageSupport.getImageDescriptor(string2));
    }
}

