/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.keys;

import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.internal.keys.model.BindingElement;

class CategoryPatternFilter
extends PatternFilter {
    private boolean filterCategories;
    final Category uncategorized;

    public CategoryPatternFilter(boolean bl, Category category) {
        this.uncategorized = category;
        this.filterCategories(bl);
    }

    public void filterCategories(boolean bl) {
        this.filterCategories = bl;
        if (this.filterCategories) {
            this.setPattern("org.eclipse.ui.keys.optimization.false");
        } else {
            this.setPattern("org.eclipse.ui.keys.optimization.true");
        }
    }

    public boolean isFilteringCategories() {
        return this.filterCategories;
    }

    @Override
    protected boolean isLeafMatch(Viewer viewer, Object object) {
        if (this.filterCategories) {
            ParameterizedCommand parameterizedCommand = this.getCommand(object);
            try {
                if (parameterizedCommand != null && parameterizedCommand.getCommand().getCategory() == this.uncategorized) {
                    return false;
                }
            }
            catch (NotDefinedException notDefinedException) {
                return false;
            }
        }
        return super.isLeafMatch(viewer, object);
    }

    private ParameterizedCommand getCommand(Object object) {
        if (object instanceof BindingElement) {
            Object object2 = ((BindingElement)object).getModelObject();
            if (object2 instanceof Binding) {
                return ((Binding)object2).getParameterizedCommand();
            }
            if (object2 instanceof ParameterizedCommand) {
                return (ParameterizedCommand)object2;
            }
        }
        return null;
    }
}

