/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.keys;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.BindingManager;
import org.eclipse.jface.bindings.IBindingManagerListener;
import org.eclipse.jface.bindings.Scheme;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.jface.bindings.keys.formatting.IKeyFormatter;
import org.eclipse.jface.bindings.keys.formatting.KeyFormatterFactory;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.keys.BindingPersistence;
import org.eclipse.ui.internal.keys.WorkbenchKeyboard;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.keys.IBindingService;

public final class BindingService
implements IBindingService {
    private final BindingManager bindingManager;
    private final BindingPersistence bindingPersistence;
    private WorkbenchKeyboard keyboard;
    private IWorkbench workbench;
    private Listener backForwardListener;

    public BindingService(BindingManager bindingManager, ICommandService iCommandService, final IWorkbench iWorkbench) {
        if (bindingManager == null) {
            throw new NullPointerException("Cannot create a binding service with a null manager");
        }
        if (iCommandService == null) {
            throw new NullPointerException("Cannot create a binding service with a null command service");
        }
        this.bindingManager = bindingManager;
        this.bindingPersistence = new BindingPersistence(bindingManager, iCommandService);
        this.workbench = iWorkbench;
        this.keyboard = new WorkbenchKeyboard(iWorkbench);
        Display display = iWorkbench.getDisplay();
        WorkbenchKeyboard.KeyDownFilter keyDownFilter = this.keyboard.getKeyDownFilter();
        keyDownFilter.setEnabled(false);
        display.addFilter(1, (Listener)keyDownFilter);
        display.addFilter(31, (Listener)keyDownFilter);
        KeyFormatterFactory.setDefault((IKeyFormatter)SWTKeySupport.getKeyFormatterForPlatform());
        this.backForwardListener = new Listener(){

            public void handleEvent(Event event) {
                String string;
                switch (event.button) {
                    case 4: 
                    case 8: {
                        string = "org.eclipse.ui.navigate.backwardHistory";
                        break;
                    }
                    case 5: 
                    case 9: {
                        string = "org.eclipse.ui.navigate.forwardHistory";
                        break;
                    }
                    default: {
                        return;
                    }
                }
                IHandlerService iHandlerService = (IHandlerService)iWorkbench.getService(IHandlerService.class);
                try {
                    iHandlerService.executeCommand(string, event);
                    event.doit = false;
                }
                catch (NotDefinedException notDefinedException) {
                }
                catch (NotEnabledException notEnabledException) {
                }
                catch (NotHandledException notHandledException) {
                }
                catch (ExecutionException executionException) {
                    StatusUtil.handleStatus(executionException, 3);
                }
            }
        };
        display.addFilter(3, this.backForwardListener);
    }

    public final void addBinding(Binding binding) {
        this.bindingManager.addBinding(binding);
    }

    @Override
    public final void dispose() {
        WorkbenchKeyboard.KeyDownFilter keyDownFilter = this.keyboard.getKeyDownFilter();
        Display display = this.workbench.getDisplay();
        if (display != null) {
            display.removeFilter(1, (Listener)keyDownFilter);
            display.removeFilter(31, (Listener)keyDownFilter);
            display.removeFilter(3, this.backForwardListener);
        }
        this.workbench = null;
        this.keyboard = null;
        this.bindingPersistence.dispose();
        this.backForwardListener = null;
    }

    @Override
    public final TriggerSequence[] getActiveBindingsFor(ParameterizedCommand parameterizedCommand) {
        return this.bindingManager.getActiveBindingsFor(parameterizedCommand);
    }

    @Override
    public final TriggerSequence[] getActiveBindingsFor(String string) {
        return this.bindingManager.getActiveBindingsFor(string);
    }

    @Override
    public final Scheme getActiveScheme() {
        return this.bindingManager.getActiveScheme();
    }

    @Override
    public final TriggerSequence getBestActiveBindingFor(String string) {
        return this.bindingManager.getBestActiveBindingFor(string);
    }

    @Override
    public TriggerSequence getBestActiveBindingFor(ParameterizedCommand parameterizedCommand) {
        return this.bindingManager.getBestActiveBindingFor(parameterizedCommand);
    }

    @Override
    public final String getBestActiveBindingFormattedFor(String string) {
        return this.bindingManager.getBestActiveBindingFormattedFor(string);
    }

    @Override
    public final Binding[] getBindings() {
        return this.bindingManager.getBindings();
    }

    @Override
    public final TriggerSequence getBuffer() {
        return this.keyboard.getBuffer();
    }

    @Override
    public final String getDefaultSchemeId() {
        return BindingPersistence.getDefaultSchemeId();
    }

    @Override
    public final Scheme[] getDefinedSchemes() {
        return this.bindingManager.getDefinedSchemes();
    }

    public final WorkbenchKeyboard getKeyboard() {
        return this.keyboard;
    }

    @Override
    public final String getLocale() {
        return this.bindingManager.getLocale();
    }

    @Override
    public final Map getPartialMatches(TriggerSequence triggerSequence) {
        return this.bindingManager.getPartialMatches(triggerSequence);
    }

    @Override
    public final Binding getPerfectMatch(TriggerSequence triggerSequence) {
        return this.bindingManager.getPerfectMatch(triggerSequence);
    }

    @Override
    public final String getPlatform() {
        return this.bindingManager.getPlatform();
    }

    @Override
    public final Scheme getScheme(String string) {
        return this.bindingManager.getScheme(string);
    }

    @Override
    public final boolean isKeyFilterEnabled() {
        return this.keyboard.getKeyDownFilter().isEnabled();
    }

    @Override
    public final boolean isPartialMatch(TriggerSequence triggerSequence) {
        return this.bindingManager.isPartialMatch(triggerSequence);
    }

    @Override
    public final boolean isPerfectMatch(TriggerSequence triggerSequence) {
        return this.bindingManager.isPerfectMatch(triggerSequence);
    }

    @Override
    public final void openKeyAssistDialog() {
        this.keyboard.openMultiKeyAssistShell();
    }

    @Override
    public final void readRegistryAndPreferences(ICommandService iCommandService) {
        this.bindingPersistence.read();
    }

    public final void removeBinding(Binding binding) {
        this.bindingManager.removeBinding(binding);
    }

    @Override
    public final void savePreferences(Scheme scheme, Binding[] bindingArray) throws IOException {
        BindingPersistence.write(scheme, bindingArray);
        try {
            this.bindingManager.setActiveScheme(scheme);
        }
        catch (NotDefinedException notDefinedException) {
            WorkbenchPlugin.log("The active scheme is not currently defined.", WorkbenchPlugin.getStatus(notDefinedException));
        }
        this.bindingManager.setBindings(bindingArray);
    }

    @Override
    public final void setKeyFilterEnabled(boolean bl) {
        this.keyboard.getKeyDownFilter().setEnabled(bl);
    }

    public BindingPersistence getBindingPersistence() {
        return this.bindingPersistence;
    }

    public BindingManager getBindingManager() {
        return this.bindingManager;
    }

    @Override
    public void addBindingManagerListener(IBindingManagerListener iBindingManagerListener) {
        this.bindingManager.addBindingManagerListener(iBindingManagerListener);
    }

    @Override
    public void removeBindingManagerListener(IBindingManagerListener iBindingManagerListener) {
        this.bindingManager.removeBindingManagerListener(iBindingManagerListener);
    }

    @Override
    public Collection getConflictsFor(TriggerSequence triggerSequence) {
        return this.bindingManager.getConflictsFor(triggerSequence);
    }
}

