/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.keys;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.commands.util.Tracing;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.BindingManager;
import org.eclipse.jface.bindings.Scheme;
import org.eclipse.jface.bindings.keys.IKeyLookup;
import org.eclipse.jface.bindings.keys.KeyBinding;
import org.eclipse.jface.bindings.keys.KeyLookupFactory;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.SWT;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.misc.Policy;
import org.eclipse.ui.internal.services.PreferencePersistence;
import org.eclipse.ui.views.IViewRegistry;

public final class BindingPersistence
extends PreferencePersistence {
    private static final boolean DEBUG = Policy.DEBUG_KEY_BINDINGS;
    private static final int INDEX_ACTIVE_SCHEME = 0;
    private static final int INDEX_BINDING_DEFINITIONS = 1;
    private static final int INDEX_SCHEME_DEFINITIONS = 2;
    private static final String LEGACY_DEFAULT_SCOPE = "org.eclipse.ui.globalScope";
    private static final Map r2_1KeysByName = new HashMap();
    private final BindingManager bindingManager;
    private final ICommandService commandService;

    static {
        IKeyLookup iKeyLookup = KeyLookupFactory.getDefault();
        r2_1KeysByName.put("BACKSPACE", iKeyLookup.formalKeyLookupInteger("BACKSPACE"));
        r2_1KeysByName.put("TAB", iKeyLookup.formalKeyLookupInteger("TAB"));
        r2_1KeysByName.put("RETURN", iKeyLookup.formalKeyLookupInteger("RETURN"));
        r2_1KeysByName.put("ENTER", iKeyLookup.formalKeyLookupInteger("ENTER"));
        r2_1KeysByName.put("ESCAPE", iKeyLookup.formalKeyLookupInteger("ESCAPE"));
        r2_1KeysByName.put("ESC", iKeyLookup.formalKeyLookupInteger("ESC"));
        r2_1KeysByName.put("DELETE", iKeyLookup.formalKeyLookupInteger("DELETE"));
        r2_1KeysByName.put("SPACE", iKeyLookup.formalKeyLookupInteger("SPACE"));
        r2_1KeysByName.put("ARROW_UP", iKeyLookup.formalKeyLookupInteger("ARROW_UP"));
        r2_1KeysByName.put("ARROW_DOWN", iKeyLookup.formalKeyLookupInteger("ARROW_DOWN"));
        r2_1KeysByName.put("ARROW_LEFT", iKeyLookup.formalKeyLookupInteger("ARROW_LEFT"));
        r2_1KeysByName.put("ARROW_RIGHT", iKeyLookup.formalKeyLookupInteger("ARROW_RIGHT"));
        r2_1KeysByName.put("PAGE_UP", iKeyLookup.formalKeyLookupInteger("PAGE_UP"));
        r2_1KeysByName.put("PAGE_DOWN", iKeyLookup.formalKeyLookupInteger("PAGE_DOWN"));
        r2_1KeysByName.put("HOME", iKeyLookup.formalKeyLookupInteger("HOME"));
        r2_1KeysByName.put("END", iKeyLookup.formalKeyLookupInteger("END"));
        r2_1KeysByName.put("INSERT", iKeyLookup.formalKeyLookupInteger("INSERT"));
        r2_1KeysByName.put("F1", iKeyLookup.formalKeyLookupInteger("F1"));
        r2_1KeysByName.put("F2", iKeyLookup.formalKeyLookupInteger("F2"));
        r2_1KeysByName.put("F3", iKeyLookup.formalKeyLookupInteger("F3"));
        r2_1KeysByName.put("F4", iKeyLookup.formalKeyLookupInteger("F4"));
        r2_1KeysByName.put("F5", iKeyLookup.formalKeyLookupInteger("F5"));
        r2_1KeysByName.put("F6", iKeyLookup.formalKeyLookupInteger("F6"));
        r2_1KeysByName.put("F7", iKeyLookup.formalKeyLookupInteger("F7"));
        r2_1KeysByName.put("F8", iKeyLookup.formalKeyLookupInteger("F8"));
        r2_1KeysByName.put("F9", iKeyLookup.formalKeyLookupInteger("F9"));
        r2_1KeysByName.put("F10", iKeyLookup.formalKeyLookupInteger("F10"));
        r2_1KeysByName.put("F11", iKeyLookup.formalKeyLookupInteger("F11"));
        r2_1KeysByName.put("F12", iKeyLookup.formalKeyLookupInteger("F12"));
        r2_1KeysByName.put("F13", iKeyLookup.formalKeyLookupInteger("F13"));
        r2_1KeysByName.put("F14", iKeyLookup.formalKeyLookupInteger("F14"));
        r2_1KeysByName.put("F15", iKeyLookup.formalKeyLookupInteger("F15"));
        r2_1KeysByName.put("F16", iKeyLookup.formalKeyLookupInteger("F16"));
        r2_1KeysByName.put("F17", iKeyLookup.formalKeyLookupInteger("F17"));
        r2_1KeysByName.put("F18", iKeyLookup.formalKeyLookupInteger("F18"));
        r2_1KeysByName.put("F19", iKeyLookup.formalKeyLookupInteger("F19"));
        r2_1KeysByName.put("F20", iKeyLookup.formalKeyLookupInteger("F20"));
    }

    private static final KeySequence convert2_1Sequence(int[] nArray) {
        int n = nArray.length;
        KeyStroke[] keyStrokeArray = new KeyStroke[n];
        int n2 = 0;
        while (n2 < n) {
            keyStrokeArray[n2] = BindingPersistence.convert2_1Stroke(nArray[n2]);
            ++n2;
        }
        return KeySequence.getInstance((KeyStroke[])keyStrokeArray);
    }

    private static final KeyStroke convert2_1Stroke(int n) {
        return SWTKeySupport.convertAcceleratorToKeyStroke((int)n);
    }

    static final String getDefaultSchemeId() {
        IPreferenceStore iPreferenceStore = PlatformUI.getPreferenceStore();
        return iPreferenceStore.getDefaultString("KEY_CONFIGURATION_ID");
    }

    private static final int[] parse2_1Sequence(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = stringTokenizer.countTokens();
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = BindingPersistence.parse2_1Stroke(stringTokenizer.nextToken());
            ++n2;
        }
        return nArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final int parse2_1Stroke(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "+", true);
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n2] = stringTokenizer.nextToken();
            ++n2;
        }
        n2 = 0;
        if (n % 2 != 1) return n2;
        String string2 = stringArray[n - 1];
        Integer n3 = (Integer)r2_1KeysByName.get(string2.toUpperCase());
        if (n3 != null) {
            n2 = n3;
        } else if (string2.length() == 1) {
            n2 = string2.toUpperCase().charAt(0);
        }
        if (n2 == 0) return n2;
        int n4 = 0;
        while (n4 < n - 1) {
            string2 = stringArray[n4];
            if (n4 % 2 == 0) {
                if (string2.equalsIgnoreCase("CTRL")) {
                    if ((n2 & 0x40000) != 0) {
                        return 0;
                    }
                    n2 |= 0x40000;
                } else if (string2.equalsIgnoreCase("ALT")) {
                    if ((n2 & 0x10000) != 0) {
                        return 0;
                    }
                    n2 |= 0x10000;
                } else if (string2.equalsIgnoreCase("SHIFT")) {
                    if ((n2 & 0x20000) != 0) {
                        return 0;
                    }
                    n2 |= 0x20000;
                } else {
                    if (!string2.equalsIgnoreCase("COMMAND")) return 0;
                    if ((n2 & 0x400000) != 0) {
                        return 0;
                    }
                    n2 |= 0x400000;
                }
            } else if (!"+".equals(string2)) {
                return 0;
            }
            ++n4;
        }
        return n2;
    }

    private static final void readActiveScheme(IConfigurationElement[] iConfigurationElementArray, int n, IMemento iMemento, BindingManager bindingManager) {
        IPreferenceStore iPreferenceStore = PlatformUI.getPreferenceStore();
        String string = iPreferenceStore.getDefaultString("KEY_CONFIGURATION_ID");
        String string2 = iPreferenceStore.getString("KEY_CONFIGURATION_ID");
        if (string2 != null && !string2.equals(string)) {
            try {
                bindingManager.setActiveScheme(bindingManager.getScheme(string2));
                return;
            }
            catch (NotDefinedException notDefinedException) {}
        }
        if (iMemento != null) {
            IMemento[] iMementoArray = iMemento.getChildren("activeKeyConfiguration");
            int n2 = iMementoArray.length;
            int n3 = n2 - 1;
            while (n3 >= 0) {
                IMemento iMemento2 = iMementoArray[n3];
                String string3 = iMemento2.getString("keyConfigurationId");
                if (string3 != null) {
                    try {
                        bindingManager.setActiveScheme(bindingManager.getScheme(string3));
                        return;
                    }
                    catch (NotDefinedException notDefinedException) {}
                }
                --n3;
            }
        }
        if (string != null && string.length() > 0 && !string.equals("org.eclipse.ui.defaultAcceleratorConfiguration")) {
            try {
                bindingManager.setActiveScheme(bindingManager.getScheme(string));
                return;
            }
            catch (NotDefinedException notDefinedException) {}
        }
        int n4 = n - 1;
        while (n4 >= 0) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n4];
            String string4 = iConfigurationElement.getAttribute("keyConfigurationId");
            if (string4 != null) {
                try {
                    bindingManager.setActiveScheme(bindingManager.getScheme(string4));
                    return;
                }
                catch (NotDefinedException notDefinedException) {}
            }
            if ((string4 = iConfigurationElement.getAttribute("value")) != null) {
                try {
                    bindingManager.setActiveScheme(bindingManager.getScheme(string4));
                    return;
                }
                catch (NotDefinedException notDefinedException) {}
            }
            --n4;
        }
        try {
            bindingManager.setActiveScheme(bindingManager.getScheme("org.eclipse.ui.defaultAcceleratorConfiguration"));
        }
        catch (NotDefinedException notDefinedException) {
            throw new Error("The default default active scheme id is not defined.");
        }
    }

    /*
     * Unable to fully structure code
     */
    private static final void readBindingsFromPreferences(IMemento var0, BindingManager var1_1, ICommandService var2_2) {
        block18: {
            var3_3 = new ArrayList<E>(1);
            if (var0 == null) break block18;
            var4_4 = PlatformUI.getWorkbench().getViewRegistry();
            var5_5 = var0.getChildren("keyBinding");
            var6_6 = var5_5.length;
            var7_7 = var6_6 - 1;
            while (var7_7 >= 0) {
                block17: {
                    block19: {
                        var8_8 = var5_5[var7_7];
                        var9_9 = BindingPersistence.readOptional(var8_8, "commandId");
                        if (var9_9 == null) {
                            var9_9 = BindingPersistence.readOptional(var8_8, "command");
                        }
                        var10_10 = null;
                        if (var9_9 != null) {
                            if (var4_4.find(var9_9) == null) {
                                var11_11 = var2_2.getCommand(var9_9);
                            } else {
                                var10_10 = var9_9;
                                var11_11 = var2_2.getCommand("org.eclipse.ui.views.showView");
                            }
                        } else {
                            var11_11 = null;
                        }
                        var12_12 = BindingPersistence.readOptional(var8_8, "keyConfigurationId");
                        if (var12_12 == null && (var12_12 = BindingPersistence.readRequired(var8_8, "configuration", var3_3, "Key bindings need a scheme or key configuration")) == null) break block17;
                        var13_13 = BindingPersistence.readOptional(var8_8, "contextId");
                        if (var13_13 == null) {
                            var13_13 = BindingPersistence.readOptional(var8_8, "scope");
                        }
                        if ("org.eclipse.ui.globalScope".equals(var13_13)) {
                            var13_13 = null;
                        }
                        if (var13_13 == null) {
                            var13_13 = "org.eclipse.ui.contexts.window";
                        }
                        var14_14 = BindingPersistence.readOptional(var8_8, "keySequence");
                        var15_15 = null;
                        if (var14_14 != null) break block19;
                        var14_14 = BindingPersistence.readRequired(var8_8, "string", var3_3, "Key bindings need a key sequence or string");
                        if (var14_14 == null) break block17;
                        var15_15 = BindingPersistence.convert2_1Sequence(BindingPersistence.parse2_1Sequence(var14_14));
                        ** GOTO lbl-1000
                    }
                    try {
                        var15_15 = KeySequence.getInstance((String)var14_14);
                    }
                    catch (ParseException v0) {
                        BindingPersistence.addWarning(var3_3, "Could not parse", null, var9_9, "keySequence", var14_14);
                        break block17;
                    }
                    if (var15_15.isEmpty() || !var15_15.isComplete()) {
                        BindingPersistence.addWarning(var3_3, "Key bindings cannot use an empty or incomplete key sequence", null, var9_9, "keySequence", var15_15.toString());
                    } else lbl-1000:
                    // 2 sources

                    {
                        var16_16 = BindingPersistence.readOptional(var8_8, "locale");
                        var17_17 = BindingPersistence.readOptional(var8_8, "platform");
                        if (var11_11 == null) {
                            var18_18 = null;
                        } else if (var10_10 != null) {
                            var19_19 = new HashMap();
                            var19_19.put("org.eclipse.ui.views.showView.viewId", var10_10);
                            var18_18 = ParameterizedCommand.generateCommand((Command)var11_11, var19_19);
                        } else {
                            var18_18 = BindingPersistence.readParameters(var8_8, var3_3, var11_11);
                        }
                        var19_19 = new KeyBinding(var15_15, var18_18, var12_12, var13_13, var16_16, var17_17, null, 1);
                        var1_1.addBinding((Binding)var19_19);
                    }
                }
                --var7_7;
            }
        }
        BindingPersistence.logWarnings(var3_3, "Warnings while parsing the key bindings from the preference store");
    }

    private static final void readBindingsFromRegistry(IConfigurationElement[] iConfigurationElementArray, int n, BindingManager bindingManager, ICommandService iCommandService) {
        ArrayList arrayList = new ArrayList(n);
        ArrayList arrayList2 = new ArrayList(1);
        HashSet<KeyBinding> hashSet = new HashSet<KeyBinding>();
        IViewRegistry iViewRegistry = PlatformUI.getWorkbench().getViewRegistry();
        IConfigurationElement[] iConfigurationElementArray2 = new IConfigurationElement[]{};
        if (n > 0) {
            iConfigurationElementArray2 = BindingPersistence.getSequenceModifierElements(iConfigurationElementArray[0]);
        }
        int n2 = 0;
        while (n2 < n) {
            block18: {
                String string;
                Command command;
                String string2;
                String string3;
                IConfigurationElement iConfigurationElement;
                block17: {
                    block15: {
                        block16: {
                            iConfigurationElement = iConfigurationElementArray[n2];
                            if (n2 > 0 && !iConfigurationElement.getDeclaringExtension().equals((Object)iConfigurationElementArray[n2 - 1].getDeclaringExtension())) {
                                iConfigurationElementArray2 = BindingPersistence.getSequenceModifierElements(iConfigurationElement);
                            }
                            string3 = BindingPersistence.readCommandId(iConfigurationElement);
                            string2 = null;
                            if (string3 == null) break block15;
                            if (iViewRegistry.find(string3) != null) break block16;
                            command = iCommandService.getCommand(string3);
                            if (command.isDefined()) break block17;
                            BindingPersistence.addWarning(arrayList2, "Cannot bind to an undefined command", iConfigurationElement, string3);
                            break block18;
                        }
                        string2 = string3;
                        command = iCommandService.getCommand("org.eclipse.ui.views.showView");
                        if (DEBUG) {
                            Tracing.printTrace((String)"BINDINGS", (String)("Command '" + string3 + "' should be migrated to " + "org.eclipse.ui.views.showView"));
                        }
                        if (command.isDefined()) break block17;
                        BindingPersistence.addWarning(arrayList2, "Cannot bind to an undefined command", iConfigurationElement, string3);
                        break block18;
                    }
                    command = null;
                }
                if (!BindingPersistence.isEmpty(string = BindingPersistence.readSchemeId(iConfigurationElement, arrayList2, string3))) {
                    String string4 = BindingPersistence.readContextId(iConfigurationElement);
                    String string5 = BindingPersistence.readKeySequenceText(iConfigurationElement);
                    if (BindingPersistence.isEmpty(string5)) {
                        BindingPersistence.addWarning(arrayList2, "Defining a key binding with no key sequence has no effect", iConfigurationElement, string3);
                    } else {
                        KeySequence keySequence = BindingPersistence.readKeySequence(iConfigurationElement, arrayList2, string3, string5);
                        if (keySequence != null) {
                            String string6 = BindingPersistence.readNonEmptyAttribute(iConfigurationElement, "locale");
                            String string7 = BindingPersistence.readNonEmptyAttribute(iConfigurationElement, "platform");
                            ParameterizedCommand parameterizedCommand = BindingPersistence.readParameterizedCommand(arrayList2, iConfigurationElement, string2, command);
                            List list = BindingPersistence.applyModifiers(keySequence, string5, string7, iConfigurationElementArray2, parameterizedCommand, string, string4, string6, arrayList2);
                            KeyBinding keyBinding = (KeyBinding)list.get(0);
                            if (list.size() > 1) {
                                int n3 = 1;
                                while (n3 < list.size()) {
                                    arrayList.add(list.get(n3));
                                    ++n3;
                                }
                            }
                            if ("cocoa".equals(string7)) {
                                hashSet.add(keyBinding);
                            } else if ("carbon".equals(string7)) {
                                arrayList.add(keyBinding);
                                hashSet.add(new KeyBinding(keySequence, parameterizedCommand, string, string4, string6, "cocoa", null, 0));
                            } else {
                                arrayList.add(keyBinding);
                            }
                        }
                    }
                }
            }
            ++n2;
        }
        if (hashSet.size() > 0) {
            arrayList.addAll(hashSet);
        }
        Binding[] bindingArray = arrayList.toArray(new Binding[arrayList.size()]);
        bindingManager.setBindings(bindingArray);
        BindingPersistence.logWarnings(arrayList2, "Warnings while parsing the key bindings from the 'org.eclipse.ui.commands' extension point");
    }

    private static List applyModifiers(KeySequence keySequence, String string, String string2, IConfigurationElement[] iConfigurationElementArray, ParameterizedCommand parameterizedCommand, String string3, String string4, String string5, List list) {
        ArrayList<KeyBinding> arrayList = new ArrayList<KeyBinding>();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            String string6 = iConfigurationElement.getAttribute("find");
            if (string.startsWith(string6)) {
                String string7 = iConfigurationElement.getAttribute("replace");
                String string8 = String.valueOf(string7) + string.substring(string6.length());
                String string9 = iConfigurationElement.getAttribute("platforms");
                String[] stringArray = BindingPersistence.parseCommaSeparatedString(string9);
                try {
                    if (string2 == null) {
                        BindingPersistence.addGenericBindings(keySequence, parameterizedCommand, string3, string4, string5, arrayList, string8, stringArray);
                        break;
                    }
                    BindingPersistence.getBindingForPlatform(keySequence, string2, parameterizedCommand, string3, string4, string5, arrayList, string8, stringArray);
                }
                catch (ParseException parseException) {
                    arrayList.clear();
                    BindingPersistence.addWarning(list, "Cannot create modified sequence for key binding", iConfigurationElement, parameterizedCommand.getId(), "replace", string7);
                }
                break;
            }
            ++n;
        }
        if (arrayList.size() == 0) {
            KeyBinding keyBinding = new KeyBinding(keySequence, parameterizedCommand, string3, string4, string5, string2, null, 0);
            arrayList.add(keyBinding);
        }
        return arrayList;
    }

    private static void getBindingForPlatform(KeySequence keySequence, String string, ParameterizedCommand parameterizedCommand, String string2, String string3, String string4, List list, String string5, String[] stringArray) throws ParseException {
        KeyBinding keyBinding;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(SWT.getPlatform())) {
                keyBinding = new KeyBinding(KeySequence.getInstance((String)string5), parameterizedCommand, string2, string3, string4, stringArray[n], null, 0);
                list.add(keyBinding);
                break;
            }
            ++n;
        }
        if (n == stringArray.length) {
            keyBinding = new KeyBinding(keySequence, parameterizedCommand, string2, string3, string4, null, null, 0);
            list.add(keyBinding);
        }
    }

    private static void addGenericBindings(KeySequence keySequence, ParameterizedCommand parameterizedCommand, String string, String string2, String string3, List list, String string4, String[] stringArray) throws ParseException {
        KeyBinding keyBinding = new KeyBinding(keySequence, parameterizedCommand, string, string2, string3, null, null, 0);
        list.add(keyBinding);
        String string5 = SWT.getPlatform();
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string5)) {
                bl = true;
                break;
            }
            ++n;
        }
        if (bl) {
            KeyBinding keyBinding2 = new KeyBinding(KeySequence.getInstance((String)string4), parameterizedCommand, string, string2, string3, SWT.getPlatform(), null, 0);
            KeyBinding keyBinding3 = new KeyBinding(keySequence, null, string, string2, string3, SWT.getPlatform(), null, 0);
            list.add(keyBinding2);
            list.add(keyBinding3);
        }
    }

    private static IConfigurationElement[] getSequenceModifierElements(IConfigurationElement iConfigurationElement) {
        IExtension iExtension = iConfigurationElement.getDeclaringExtension();
        IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
        ArrayList<IConfigurationElement> arrayList = new ArrayList<IConfigurationElement>();
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement2 = iConfigurationElementArray[n];
            if ("sequenceModifier".equals(iConfigurationElement2.getName())) {
                arrayList.add(iConfigurationElement2);
            }
            ++n;
        }
        return arrayList.toArray(new IConfigurationElement[arrayList.size()]);
    }

    public static String[] parseCommaSeparatedString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < stringArray.length) {
            stringArray[n2] = stringTokenizer.nextToken();
            ++n2;
        }
        return stringArray;
    }

    private static String readKeySequenceText(IConfigurationElement iConfigurationElement) {
        String string = iConfigurationElement.getAttribute("sequence");
        if (BindingPersistence.isEmpty(string)) {
            string = iConfigurationElement.getAttribute("keySequence");
        }
        if (BindingPersistence.isEmpty(string)) {
            string = iConfigurationElement.getAttribute("string");
        }
        return string;
    }

    private static KeySequence readKeySequence(IConfigurationElement iConfigurationElement, List list, String string, String string2) {
        KeySequence keySequence = null;
        if (string2.equals(iConfigurationElement.getAttribute("string"))) {
            try {
                keySequence = BindingPersistence.convert2_1Sequence(BindingPersistence.parse2_1Sequence(string2));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                BindingPersistence.addWarning(list, "Could not parse key sequence", iConfigurationElement, string, "keySequence", string2);
                return null;
            }
        }
        try {
            keySequence = KeySequence.getInstance((String)string2);
        }
        catch (ParseException parseException) {
            BindingPersistence.addWarning(list, "Could not parse key sequence", iConfigurationElement, string, "keySequence", string2);
            return null;
        }
        if (keySequence.isEmpty() || !keySequence.isComplete()) {
            BindingPersistence.addWarning(list, "Key bindings should not have an empty or incomplete key sequence", iConfigurationElement, string, "keySequence", keySequence.toString());
            return null;
        }
        return keySequence;
    }

    private static ParameterizedCommand readParameterizedCommand(List list, IConfigurationElement iConfigurationElement, String string, Command command) {
        ParameterizedCommand parameterizedCommand;
        if (command == null) {
            parameterizedCommand = null;
        } else if (string != null) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("org.eclipse.ui.views.showView.viewId", string);
            parameterizedCommand = ParameterizedCommand.generateCommand((Command)command, hashMap);
        } else {
            parameterizedCommand = BindingPersistence.readParameters(iConfigurationElement, list, command);
        }
        return parameterizedCommand;
    }

    private static String readNonEmptyAttribute(IConfigurationElement iConfigurationElement, String string) {
        String string2 = iConfigurationElement.getAttribute(string);
        if (string2 != null && string2.length() == 0) {
            string2 = null;
        }
        return string2;
    }

    private static String readContextId(IConfigurationElement iConfigurationElement) {
        String string = iConfigurationElement.getAttribute("contextId");
        if (LEGACY_DEFAULT_SCOPE.equals(string)) {
            string = null;
        } else if ((string == null || string.length() == 0) && LEGACY_DEFAULT_SCOPE.equals(string = iConfigurationElement.getAttribute("scope"))) {
            string = null;
        }
        if (string == null || string.length() == 0) {
            string = "org.eclipse.ui.contexts.window";
        }
        return string;
    }

    private static String readSchemeId(IConfigurationElement iConfigurationElement, List list, String string) {
        String string2 = iConfigurationElement.getAttribute("schemeId");
        if (!(string2 != null && string2.length() != 0 || (string2 = iConfigurationElement.getAttribute("keyConfigurationId")) != null && string2.length() != 0 || (string2 = iConfigurationElement.getAttribute("configuration")) != null && string2.length() != 0)) {
            BindingPersistence.addWarning(list, "Key bindings need a scheme", iConfigurationElement, string);
        }
        return string2;
    }

    private static String readCommandId(IConfigurationElement iConfigurationElement) {
        String string = iConfigurationElement.getAttribute("commandId");
        if (string == null || string.length() == 0) {
            string = iConfigurationElement.getAttribute("command");
        }
        if (string != null && string.length() == 0) {
            string = null;
        }
        return string;
    }

    private static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    private static final void readSchemesFromRegistry(IConfigurationElement[] iConfigurationElementArray, int n, BindingManager bindingManager) {
        Scheme[] schemeArray = bindingManager.getDefinedSchemes();
        if (schemeArray != null) {
            int n2 = 0;
            while (n2 < schemeArray.length) {
                schemeArray[n2].undefine();
                ++n2;
            }
        }
        ArrayList arrayList = new ArrayList(1);
        int n3 = 0;
        while (n3 < n) {
            String string;
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n3];
            String string2 = BindingPersistence.readRequired(iConfigurationElement, "id", arrayList, "Schemes need an id");
            if (string2 != null && (string = BindingPersistence.readRequired(iConfigurationElement, "name", arrayList, "A scheme needs a name", string2)) != null) {
                String string3 = BindingPersistence.readOptional(iConfigurationElement, "description");
                String string4 = iConfigurationElement.getAttribute("parentId");
                if (string4 != null && string4.length() == 0 && (string4 = iConfigurationElement.getAttribute("parent")) != null && string4.length() == 0) {
                    string4 = null;
                }
                Scheme scheme = bindingManager.getScheme(string2);
                scheme.define(string, string3, string4);
            }
            ++n3;
        }
        BindingPersistence.logWarnings(arrayList, "Warnings while parsing the key bindings from the 'org.eclipse.ui.bindings', 'org.eclipse.ui.acceleratorConfigurations' and 'org.eclipse.ui.commands' extension point");
    }

    static final void write(Scheme scheme, Binding[] bindingArray) throws IOException {
        if (DEBUG) {
            Tracing.printTrace((String)"BINDINGS", (String)("Persisting active scheme '" + scheme.getId() + '\''));
            Tracing.printTrace((String)"BINDINGS", (String)"Persisting bindings");
        }
        BindingPersistence.writeActiveScheme(scheme);
        XMLMemento xMLMemento = XMLMemento.createWriteRoot("org.eclipse.ui.commands");
        if (scheme != null) {
            BindingPersistence.writeActiveSchemeToPreferences(xMLMemento, scheme);
        }
        if (bindingArray != null) {
            int n = bindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                Binding binding = bindingArray[n2];
                if (binding.getType() == 1) {
                    BindingPersistence.writeBindingToPreferences(xMLMemento, binding);
                }
                ++n2;
            }
        }
        IPreferenceStore iPreferenceStore = WorkbenchPlugin.getDefault().getPreferenceStore();
        try (StringWriter stringWriter = new StringWriter();){
            xMLMemento.save(stringWriter);
            iPreferenceStore.setValue("org.eclipse.ui.commands", ((Object)stringWriter).toString());
        }
    }

    private static final void writeActiveScheme(Scheme scheme) {
        IPreferenceStore iPreferenceStore = PlatformUI.getPreferenceStore();
        String string = scheme == null ? null : scheme.getId();
        String string2 = iPreferenceStore.getDefaultString("KEY_CONFIGURATION_ID");
        if (string2 == null ? scheme != null : !string2.equals(string)) {
            iPreferenceStore.setValue("KEY_CONFIGURATION_ID", scheme.getId());
        } else {
            iPreferenceStore.setToDefault("KEY_CONFIGURATION_ID");
        }
    }

    private static final void writeActiveSchemeToPreferences(IMemento iMemento, Scheme scheme) {
        IPreferenceStore iPreferenceStore = PlatformUI.getPreferenceStore();
        String string = scheme.getId();
        String string2 = iPreferenceStore.getDefaultString("KEY_CONFIGURATION_ID");
        if (string2 == null ? string != null : !string2.equals(string)) {
            IMemento iMemento2 = iMemento.createChild("activeKeyConfiguration");
            iMemento2.putString("keyConfigurationId", string);
        }
    }

    private static final void writeBindingToPreferences(IMemento iMemento, Binding binding) {
        IMemento iMemento2 = iMemento.createChild("keyBinding");
        iMemento2.putString("contextId", binding.getContextId());
        ParameterizedCommand parameterizedCommand = binding.getParameterizedCommand();
        String string = parameterizedCommand == null ? null : parameterizedCommand.getId();
        iMemento2.putString("commandId", string);
        iMemento2.putString("keyConfigurationId", binding.getSchemeId());
        iMemento2.putString("keySequence", binding.getTriggerSequence().toString());
        iMemento2.putString("locale", binding.getLocale());
        iMemento2.putString("platform", binding.getPlatform());
        if (parameterizedCommand != null) {
            Map map = parameterizedCommand.getParameterMap();
            for (Map.Entry entry : map.entrySet()) {
                String string2 = (String)entry.getKey();
                String string3 = (String)entry.getValue();
                IMemento iMemento3 = iMemento2.createChild("parameter");
                iMemento3.putString("id", string2);
                iMemento3.putString("value", string3);
            }
        }
    }

    BindingPersistence(BindingManager bindingManager, ICommandService iCommandService) {
        this.bindingManager = bindingManager;
        this.commandService = iCommandService;
    }

    @Override
    protected final boolean isChangeImportant(IRegistryChangeEvent iRegistryChangeEvent) {
        return false;
    }

    public boolean bindingsNeedUpdating(IRegistryChangeEvent iRegistryChangeEvent) {
        IExtensionDelta[] iExtensionDeltaArray;
        IExtensionDelta[] iExtensionDeltaArray2;
        IExtensionDelta[] iExtensionDeltaArray3;
        IExtensionDelta[] iExtensionDeltaArray4;
        IExtensionDelta[] iExtensionDeltaArray5;
        IExtensionDelta[] iExtensionDeltaArray6 = iRegistryChangeEvent.getExtensionDeltas("org.eclipse.ui", "acceleratorConfigurations");
        return iExtensionDeltaArray6.length != 0 || (iExtensionDeltaArray5 = iRegistryChangeEvent.getExtensionDeltas("org.eclipse.ui", "bindings")).length != 0 || (iExtensionDeltaArray4 = iRegistryChangeEvent.getExtensionDeltas("org.eclipse.ui", "commands")).length != 0 || (iExtensionDeltaArray3 = iRegistryChangeEvent.getExtensionDeltas("org.eclipse.ui", "acceleratorScopes")).length != 0 || (iExtensionDeltaArray2 = iRegistryChangeEvent.getExtensionDeltas("org.eclipse.ui", "contexts")).length != 0 || (iExtensionDeltaArray = iRegistryChangeEvent.getExtensionDeltas("org.eclipse.ui", "actionDefinitions")).length != 0;
    }

    @Override
    protected final boolean isChangeImportant(PropertyChangeEvent propertyChangeEvent) {
        return "org.eclipse.ui.commands".equals(propertyChangeEvent.getProperty());
    }

    @Override
    protected final void read() {
        super.read();
        this.reRead();
    }

    public void reRead() {
        Object object;
        String string;
        String string2;
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        IConfigurationElement[][] iConfigurationElementArrayArray = new IConfigurationElement[3][];
        IConfigurationElement[] iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor("org.eclipse.ui.bindings");
        int n4 = 0;
        while (n4 < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n4];
            string2 = iConfigurationElement.getName();
            if ("key".equals(string2)) {
                BindingPersistence.addElementToIndexedArray(iConfigurationElement, iConfigurationElementArrayArray, 1, n2++);
            } else if ("scheme".equals(string2)) {
                BindingPersistence.addElementToIndexedArray(iConfigurationElement, iConfigurationElementArrayArray, 2, n3++);
            }
            ++n4;
        }
        IConfigurationElement[] iConfigurationElementArray2 = iExtensionRegistry.getConfigurationElementsFor("org.eclipse.ui.commands");
        int n5 = 0;
        while (n5 < iConfigurationElementArray2.length) {
            string2 = iConfigurationElementArray2[n5];
            string = string2.getName();
            if ("keyBinding".equals(string)) {
                BindingPersistence.addElementToIndexedArray((IConfigurationElement)string2, iConfigurationElementArrayArray, 1, n2++);
            } else if ("keyConfiguration".equals(string)) {
                BindingPersistence.addElementToIndexedArray((IConfigurationElement)string2, iConfigurationElementArrayArray, 2, n3++);
            } else if ("activeKeyConfiguration".equals(string)) {
                BindingPersistence.addElementToIndexedArray((IConfigurationElement)string2, iConfigurationElementArrayArray, 0, n++);
            }
            ++n5;
        }
        IConfigurationElement[] iConfigurationElementArray3 = iExtensionRegistry.getConfigurationElementsFor("org.eclipse.ui.acceleratorConfigurations");
        int n6 = 0;
        while (n6 < iConfigurationElementArray3.length) {
            string = iConfigurationElementArray3[n6];
            object = string.getName();
            if ("acceleratorConfiguration".equals(object)) {
                BindingPersistence.addElementToIndexedArray((IConfigurationElement)string, iConfigurationElementArrayArray, 2, n3++);
            }
            ++n6;
        }
        IPreferenceStore iPreferenceStore = WorkbenchPlugin.getDefault().getPreferenceStore();
        string = iPreferenceStore.getString("org.eclipse.ui.commands");
        object = null;
        if (string != null && string.length() > 0) {
            StringReader stringReader = new StringReader(string);
            try {
                object = XMLMemento.createReadRoot(stringReader);
            }
            catch (WorkbenchException workbenchException) {}
        }
        BindingPersistence.readSchemesFromRegistry(iConfigurationElementArrayArray[2], n3, this.bindingManager);
        BindingPersistence.readActiveScheme(iConfigurationElementArrayArray[0], n, (IMemento)object, this.bindingManager);
        BindingPersistence.readBindingsFromRegistry(iConfigurationElementArrayArray[1], n2, this.bindingManager, this.commandService);
        BindingPersistence.readBindingsFromPreferences((IMemento)object, this.bindingManager, this.commandService);
    }
}

