/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.keys;

import java.util.Comparator;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.TreeSet;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.keys.IKeyFormatter;
import org.eclipse.ui.keys.Key;
import org.eclipse.ui.keys.KeySequence;
import org.eclipse.ui.keys.KeyStroke;
import org.eclipse.ui.keys.ModifierKey;
import org.eclipse.ui.keys.NaturalKey;

public abstract class AbstractKeyFormatter
implements IKeyFormatter {
    protected static final String KEY_DELIMITER_KEY = "KEY_DELIMITER";
    protected static final String KEY_STROKE_DELIMITER_KEY = "KEY_STROKE_DELIMITER";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle(AbstractKeyFormatter.class.getName());

    @Override
    public String format(Key key) {
        String string = key.toString();
        return Util.translateString(RESOURCE_BUNDLE, string, string, false, false);
    }

    @Override
    public String format(KeySequence keySequence) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = keySequence.getKeyStrokes().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(this.format((KeyStroke)iterator.next()));
            if (!iterator.hasNext()) continue;
            stringBuffer.append(this.getKeyStrokeDelimiter());
        }
        return stringBuffer.toString();
    }

    @Override
    public String format(KeyStroke keyStroke) {
        String string = this.getKeyDelimiter();
        TreeSet treeSet = new TreeSet(this.getModifierKeyComparator());
        treeSet.addAll(keyStroke.getModifierKeys());
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(this.format((ModifierKey)iterator.next()));
            stringBuffer.append(string);
        }
        NaturalKey naturalKey = keyStroke.getNaturalKey();
        if (naturalKey != null) {
            stringBuffer.append(this.format(naturalKey));
        }
        return stringBuffer.toString();
    }

    protected abstract String getKeyDelimiter();

    protected abstract String getKeyStrokeDelimiter();

    protected abstract Comparator getModifierKeyComparator();
}

