/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.intro.IIntroDescriptor;
import org.eclipse.ui.internal.intro.IIntroRegistry;
import org.eclipse.ui.internal.intro.IntroDescriptor;
import org.eclipse.ui.internal.intro.IntroMessages;
import org.eclipse.ui.internal.registry.RegistryReader;

public class IntroRegistry
implements IIntroRegistry {
    private static final String TAG_INTRO = "intro";
    private static final String TAG_INTROPRODUCTBINDING = "introProductBinding";
    private static final String ATT_INTROID = "introId";
    private static final String ATT_PRODUCTID = "productId";

    @Override
    public int getIntroCount() {
        return this.getIntros().length;
    }

    @Override
    public IIntroDescriptor[] getIntros() {
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui", TAG_INTRO);
        if (iExtensionPoint == null) {
            return new IIntroDescriptor[0];
        }
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        iExtensionArray = RegistryReader.orderExtensions(iExtensionArray);
        ArrayList<IntroDescriptor> arrayList = new ArrayList<IntroDescriptor>(iExtensionArray.length);
        int n = 0;
        while (n < iExtensionArray.length) {
            IConfigurationElement[] iConfigurationElementArray = iExtensionArray[n].getConfigurationElements();
            int n2 = 0;
            while (n2 < iConfigurationElementArray.length) {
                if (iConfigurationElementArray[n2].getName().equals(TAG_INTRO)) {
                    try {
                        IntroDescriptor introDescriptor = new IntroDescriptor(iConfigurationElementArray[n2]);
                        arrayList.add(introDescriptor);
                    }
                    catch (CoreException coreException) {
                        WorkbenchPlugin.log(IntroMessages.Intro_could_not_create_descriptor, coreException.getStatus());
                    }
                }
                ++n2;
            }
            ++n;
        }
        return arrayList.toArray(new IIntroDescriptor[arrayList.size()]);
    }

    @Override
    public IIntroDescriptor getIntroForProduct(String string) {
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui", TAG_INTRO);
        if (iExtensionPoint == null) {
            return null;
        }
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        String string2 = this.getIntroForProduct(string, iExtensionArray = RegistryReader.orderExtensions(iExtensionArray));
        if (string2 == null) {
            return null;
        }
        IIntroDescriptor iIntroDescriptor = null;
        IIntroDescriptor[] iIntroDescriptorArray = this.getIntros();
        int n = 0;
        while (n < iIntroDescriptorArray.length) {
            if (iIntroDescriptorArray[n].getId().equals(string2)) {
                iIntroDescriptor = iIntroDescriptorArray[n];
                break;
            }
            ++n;
        }
        return iIntroDescriptor;
    }

    private String getIntroForProduct(String string, IExtension[] iExtensionArray) {
        int n = 0;
        while (n < iExtensionArray.length) {
            IConfigurationElement[] iConfigurationElementArray = iExtensionArray[n].getConfigurationElements();
            int n2 = 0;
            while (n2 < iConfigurationElementArray.length) {
                if (iConfigurationElementArray[n2].getName().equals(TAG_INTROPRODUCTBINDING)) {
                    String string2 = iConfigurationElementArray[n2].getAttribute(ATT_INTROID);
                    String string3 = iConfigurationElementArray[n2].getAttribute(ATT_PRODUCTID);
                    if (string2 == null || string3 == null) {
                        Status status = new Status(4, iConfigurationElementArray[n2].getDeclaringExtension().getNamespace(), 4, "introId and productId must be defined.", (Throwable)new IllegalArgumentException());
                        WorkbenchPlugin.log("Invalid intro binding", (IStatus)status);
                    } else if (string.equals(string3)) {
                        return string2;
                    }
                }
                ++n2;
            }
            ++n;
        }
        return null;
    }

    @Override
    public IIntroDescriptor getIntro(String string) {
        IIntroDescriptor[] iIntroDescriptorArray = this.getIntros();
        int n = 0;
        while (n < iIntroDescriptorArray.length) {
            IIntroDescriptor iIntroDescriptor = iIntroDescriptorArray[n];
            if (iIntroDescriptor.getId().equals(string)) {
                return iIntroDescriptor;
            }
            ++n;
        }
        return null;
    }
}

