/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.help;

import java.net.URL;
import java.util.Hashtable;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IContext;
import org.eclipse.help.IContext2;
import org.eclipse.help.IHelp;
import org.eclipse.help.IHelpResource;
import org.eclipse.help.IToc;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommand;
import org.eclipse.ui.help.AbstractHelpUI;
import org.eclipse.ui.help.IContextComputer;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.internal.WorkbenchPlugin;

public final class WorkbenchHelpSystem
implements IWorkbenchHelpSystem {
    public static final String HELP_KEY = "org.eclipse.ui.help";
    private static final String HELP_SYSTEM_EXTENSION_ID = "org.eclipse.ui.helpSupport";
    private static final String HELP_SYSTEM_CLASS_ATTRIBUTE = "class";
    private static WorkbenchHelpSystem instance;
    private boolean isInitialized;
    private AbstractHelpUI pluggableHelpUI = null;
    private String desiredHelpSystemId;
    private Hashtable registeredIDTable;
    private IExtensionChangeHandler handler = new IExtensionChangeHandler(){

        public void addExtension(IExtensionTracker iExtensionTracker, IExtension iExtension) {
        }

        public void removeExtension(IExtension iExtension, Object[] objectArray) {
            int n = 0;
            while (n < objectArray.length) {
                if (objectArray[n] == WorkbenchHelpSystem.this.pluggableHelpUI) {
                    WorkbenchHelpSystem.this.isInitialized = false;
                    WorkbenchHelpSystem.this.pluggableHelpUI = null;
                    WorkbenchHelpSystem.this.helpCompatibilityWrapper = null;
                    PlatformUI.getWorkbench().getExtensionTracker().unregisterHandler(WorkbenchHelpSystem.this.handler);
                }
                ++n;
            }
        }
    };
    private IHelp helpCompatibilityWrapper = null;
    private static HelpListener helpListener;

    public String getDesiredHelpSystemId() {
        return this.desiredHelpSystemId;
    }

    public void setDesiredHelpSystemId(String string) {
        this.dispose();
        this.desiredHelpSystemId = string;
    }

    private WorkbenchHelpSystem() {
    }

    public static WorkbenchHelpSystem getInstance() {
        if (instance == null) {
            instance = new WorkbenchHelpSystem();
        }
        return instance;
    }

    public static void disposeIfNecessary() {
        if (instance != null) {
            instance.dispose();
            instance = null;
        }
    }

    public void dispose() {
        this.pluggableHelpUI = null;
        this.helpCompatibilityWrapper = null;
        this.isInitialized = false;
        PlatformUI.getWorkbench().getExtensionTracker().unregisterHandler(this.handler);
    }

    private AbstractHelpUI getHelpUI() {
        if (!this.isInitialized) {
            this.isInitialized = this.initializePluggableHelpUI();
            if (!this.isInitialized) {
                WorkbenchPlugin.log("Unable to instantiate help UI");
            }
        }
        return this.pluggableHelpUI;
    }

    private boolean initializePluggableHelpUI() {
        final boolean[] blArray = new boolean[1];
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            @Override
            public void run() {
                IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint(WorkbenchHelpSystem.HELP_SYSTEM_EXTENSION_ID);
                if (iExtensionPoint == null) {
                    return;
                }
                IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
                if (iExtensionArray.length == 0) {
                    return;
                }
                IConfigurationElement iConfigurationElement = null;
                iConfigurationElement = WorkbenchHelpSystem.this.desiredHelpSystemId == null ? this.getFirstElement(iExtensionArray) : this.findElement(WorkbenchHelpSystem.this.desiredHelpSystemId, iExtensionArray);
                if (iConfigurationElement != null) {
                    blArray[0] = this.initializePluggableHelpUI(iConfigurationElement);
                }
            }

            private IConfigurationElement findElement(String string, IExtension[] iExtensionArray) {
                int n = 0;
                while (n < iExtensionArray.length) {
                    IExtension iExtension = iExtensionArray[n];
                    if (string.equals(iExtension.getUniqueIdentifier())) {
                        IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
                        if (iConfigurationElementArray.length == 0) {
                            return null;
                        }
                        return iConfigurationElementArray[0];
                    }
                    ++n;
                }
                return null;
            }

            private IConfigurationElement getFirstElement(IExtension[] iExtensionArray) {
                IConfigurationElement[] iConfigurationElementArray = iExtensionArray[0].getConfigurationElements();
                if (iConfigurationElementArray.length == 0) {
                    return null;
                }
                return iConfigurationElementArray[0];
            }

            private boolean initializePluggableHelpUI(IConfigurationElement iConfigurationElement) {
                try {
                    WorkbenchHelpSystem.this.pluggableHelpUI = (AbstractHelpUI)WorkbenchPlugin.createExtension(iConfigurationElement, WorkbenchHelpSystem.HELP_SYSTEM_CLASS_ATTRIBUTE);
                    PlatformUI.getWorkbench().getExtensionTracker().registerHandler(WorkbenchHelpSystem.this.handler, null);
                    PlatformUI.getWorkbench().getExtensionTracker().registerObject(iConfigurationElement.getDeclaringExtension(), (Object)WorkbenchHelpSystem.this.pluggableHelpUI, 2);
                    return true;
                }
                catch (CoreException coreException) {
                    WorkbenchPlugin.log("Unable to instantiate help UI" + coreException.getStatus(), coreException);
                    return false;
                }
            }
        });
        return blArray[0];
    }

    private static Point computePopUpLocation(Display display) {
        Point point = display.getCursorLocation();
        return new Point(point.x + 15, point.y);
    }

    private HelpListener getHelpListener() {
        if (helpListener == null) {
            helpListener = new WorkbenchHelpListener();
        }
        return helpListener;
    }

    public IHelp getHelpSupport() {
        AbstractHelpUI abstractHelpUI = this.getHelpUI();
        if (abstractHelpUI != null && this.helpCompatibilityWrapper == null) {
            this.helpCompatibilityWrapper = new CompatibilityIHelpImplementation();
        }
        return this.helpCompatibilityWrapper;
    }

    public void setHelp(IAction iAction, final Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            Assert.isTrue((objectArray[n] instanceof String || objectArray[n] instanceof IContext ? 1 : 0) != 0);
            ++n;
        }
        iAction.setHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent helpEvent) {
                if (objectArray != null && objectArray.length > 0 && WorkbenchHelpSystem.this.getHelpUI() != null) {
                    IContext iContext = null;
                    if (objectArray[0] instanceof String) {
                        iContext = HelpSystem.getContext((String)((String)objectArray[0]));
                    } else if (objectArray[0] instanceof IContext) {
                        iContext = (IContext)objectArray[0];
                    }
                    if (iContext != null) {
                        Point point = WorkbenchHelpSystem.computePopUpLocation(helpEvent.widget.getDisplay());
                        WorkbenchHelpSystem.this.displayContext(iContext, point.x, point.y);
                    }
                }
            }
        });
    }

    public void setHelp(IAction iAction, final IContextComputer iContextComputer) {
        iAction.setHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent helpEvent) {
                Object[] objectArray = iContextComputer.computeContexts(helpEvent);
                if (objectArray != null && objectArray.length > 0 && WorkbenchHelpSystem.this.getHelpUI() != null) {
                    IContext iContext = null;
                    if (objectArray[0] instanceof String) {
                        iContext = HelpSystem.getContext((String)((String)objectArray[0]));
                    } else if (objectArray[0] instanceof IContext) {
                        iContext = (IContext)objectArray[0];
                    }
                    if (iContext != null) {
                        Point point = WorkbenchHelpSystem.computePopUpLocation(helpEvent.widget.getDisplay());
                        WorkbenchHelpSystem.this.displayContext(iContext, point.x, point.y);
                    }
                }
            }
        });
    }

    public void setHelp(Control control, Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            Assert.isTrue((objectArray[n] instanceof String || objectArray[n] instanceof IContext ? 1 : 0) != 0);
            ++n;
        }
        control.setData(HELP_KEY, (Object)objectArray);
        control.removeHelpListener(this.getHelpListener());
        control.addHelpListener(this.getHelpListener());
    }

    public void setHelp(Control control, IContextComputer iContextComputer) {
        control.setData(HELP_KEY, (Object)iContextComputer);
        control.removeHelpListener(this.getHelpListener());
        control.addHelpListener(this.getHelpListener());
    }

    public void setHelp(Menu menu, Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            Assert.isTrue((objectArray[n] instanceof String || objectArray[n] instanceof IContext ? 1 : 0) != 0);
            ++n;
        }
        menu.setData(HELP_KEY, (Object)objectArray);
        menu.removeHelpListener(this.getHelpListener());
        menu.addHelpListener(this.getHelpListener());
    }

    public void setHelp(Menu menu, IContextComputer iContextComputer) {
        menu.setData(HELP_KEY, (Object)iContextComputer);
        menu.removeHelpListener(this.getHelpListener());
        menu.addHelpListener(this.getHelpListener());
    }

    public void setHelp(MenuItem menuItem, Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            Assert.isTrue((objectArray[n] instanceof String || objectArray[n] instanceof IContext ? 1 : 0) != 0);
            ++n;
        }
        menuItem.setData(HELP_KEY, (Object)objectArray);
        menuItem.removeHelpListener(this.getHelpListener());
        menuItem.addHelpListener(this.getHelpListener());
    }

    public void setHelp(MenuItem menuItem, IContextComputer iContextComputer) {
        menuItem.setData(HELP_KEY, (Object)iContextComputer);
        menuItem.removeHelpListener(this.getHelpListener());
        menuItem.addHelpListener(this.getHelpListener());
    }

    public HelpListener createHelpListener(ICommand iCommand) {
        return new HelpListener(){

            public void helpRequested(HelpEvent helpEvent) {
                IContext iContext;
                if (WorkbenchHelpSystem.this.getHelpUI() != null && (iContext = HelpSystem.getContext((String)"")) != null) {
                    Point point = WorkbenchHelpSystem.computePopUpLocation(helpEvent.widget.getDisplay());
                    WorkbenchHelpSystem.this.displayContext(iContext, point.x, point.y);
                }
            }
        };
    }

    @Override
    public void displayHelp() {
        AbstractHelpUI abstractHelpUI = this.getHelpUI();
        if (abstractHelpUI != null) {
            abstractHelpUI.displayHelp();
        }
    }

    @Override
    public void displaySearch() {
        AbstractHelpUI abstractHelpUI = this.getHelpUI();
        if (abstractHelpUI != null) {
            abstractHelpUI.displaySearch();
        }
    }

    @Override
    public void displayDynamicHelp() {
        AbstractHelpUI abstractHelpUI = this.getHelpUI();
        if (abstractHelpUI != null) {
            abstractHelpUI.displayDynamicHelp();
        }
    }

    @Override
    public void search(String string) {
        AbstractHelpUI abstractHelpUI = this.getHelpUI();
        if (abstractHelpUI != null) {
            abstractHelpUI.search(string);
        }
    }

    @Override
    public URL resolve(String string, boolean bl) {
        AbstractHelpUI abstractHelpUI = this.getHelpUI();
        if (abstractHelpUI != null) {
            return abstractHelpUI.resolve(string, bl);
        }
        return null;
    }

    @Override
    public void displayContext(IContext iContext, int n, int n2) {
        if (iContext == null) {
            throw new IllegalArgumentException();
        }
        AbstractHelpUI abstractHelpUI = this.getHelpUI();
        if (abstractHelpUI != null) {
            abstractHelpUI.displayContext(iContext, n, n2);
        }
    }

    @Override
    public void displayHelpResource(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        AbstractHelpUI abstractHelpUI = this.getHelpUI();
        if (abstractHelpUI != null) {
            abstractHelpUI.displayHelpResource(string);
        }
    }

    @Override
    public void displayHelp(String string) {
        IContext iContext = HelpSystem.getContext((String)string);
        if (iContext != null) {
            Point point = WorkbenchHelpSystem.computePopUpLocation(Display.getCurrent());
            this.displayContext(iContext, point.x, point.y);
        }
    }

    @Override
    public void displayHelp(IContext iContext) {
        Point point = WorkbenchHelpSystem.computePopUpLocation(Display.getCurrent());
        AbstractHelpUI abstractHelpUI = this.getHelpUI();
        if (abstractHelpUI != null) {
            abstractHelpUI.displayContext(iContext, point.x, point.y);
        }
    }

    @Override
    public boolean isContextHelpDisplayed() {
        if (!this.isInitialized) {
            return false;
        }
        AbstractHelpUI abstractHelpUI = this.getHelpUI();
        return abstractHelpUI != null && abstractHelpUI.isContextHelpDisplayed();
    }

    @Override
    public void setHelp(final IAction iAction, final String string) {
        if (WorkbenchPlugin.DEBUG) {
            this.setHelpTrace(string);
        }
        iAction.setHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent helpEvent) {
                IContext iContext;
                if (WorkbenchHelpSystem.this.getHelpUI() != null && (iContext = HelpSystem.getContext((String)string)) != null) {
                    Point point = WorkbenchHelpSystem.computePopUpLocation(helpEvent.widget.getDisplay());
                    String string2 = LegacyActionTools.removeMnemonics((String)iAction.getText());
                    WorkbenchHelpSystem.this.displayContext((IContext)new ContextWithTitle(iContext, string2), point.x, point.y);
                }
            }
        });
    }

    @Override
    public void setHelp(Control control, String string) {
        if (WorkbenchPlugin.DEBUG) {
            this.setHelpTrace(string);
        }
        control.setData(HELP_KEY, (Object)string);
        control.removeHelpListener(this.getHelpListener());
        control.addHelpListener(this.getHelpListener());
    }

    @Override
    public void setHelp(Menu menu, String string) {
        if (WorkbenchPlugin.DEBUG) {
            this.setHelpTrace(string);
        }
        menu.setData(HELP_KEY, (Object)string);
        menu.removeHelpListener(this.getHelpListener());
        menu.addHelpListener(this.getHelpListener());
    }

    @Override
    public void setHelp(MenuItem menuItem, String string) {
        if (WorkbenchPlugin.DEBUG) {
            this.setHelpTrace(string);
        }
        menuItem.setData(HELP_KEY, (Object)string);
        menuItem.removeHelpListener(this.getHelpListener());
        menuItem.addHelpListener(this.getHelpListener());
    }

    private void setHelpTrace(String string) {
        RuntimeException runtimeException = new RuntimeException();
        StackTraceElement[] stackTraceElementArray = runtimeException.getStackTrace();
        StackTraceElement stackTraceElement = null;
        int n = 0;
        while (n < stackTraceElementArray.length) {
            if (stackTraceElementArray[n].getMethodName().equals("setHelp") && n + 1 < stackTraceElementArray.length) {
                stackTraceElement = stackTraceElementArray[n + 1];
                break;
            }
            ++n;
        }
        if (this.registeredIDTable == null) {
            this.registeredIDTable = new Hashtable();
        }
        if (!this.registeredIDTable.containsKey(string)) {
            this.registeredIDTable.put(string, stackTraceElement);
        } else if (!this.registeredIDTable.get(string).equals(stackTraceElement)) {
            StackTraceElement stackTraceElement2 = (StackTraceElement)this.registeredIDTable.get(string);
            String string2 = "UI Duplicate Context ID found: '" + string + "'\n" + " 1 at " + stackTraceElement2 + '\n' + " 2 at " + stackTraceElement;
            System.out.println(string2);
        }
    }

    @Override
    public boolean hasHelpUI() {
        return this.getHelpUI() != null;
    }

    private class CompatibilityIHelpImplementation
    implements IHelp {
        private CompatibilityIHelpImplementation() {
        }

        public void displayHelp() {
            AbstractHelpUI abstractHelpUI = WorkbenchHelpSystem.this.getHelpUI();
            if (abstractHelpUI != null) {
                abstractHelpUI.displayHelp();
            }
        }

        public void displayContext(IContext iContext, int n, int n2) {
            AbstractHelpUI abstractHelpUI = WorkbenchHelpSystem.this.getHelpUI();
            if (abstractHelpUI != null) {
                abstractHelpUI.displayContext(iContext, n, n2);
            }
        }

        public void displayContext(String string, int n, int n2) {
            IContext iContext = HelpSystem.getContext((String)string);
            if (iContext != null) {
                this.displayContext(iContext, n, n2);
            }
        }

        public void displayHelpResource(String string) {
            AbstractHelpUI abstractHelpUI = WorkbenchHelpSystem.this.getHelpUI();
            if (abstractHelpUI != null) {
                abstractHelpUI.displayHelpResource(string);
            }
        }

        public void displayHelpResource(IHelpResource iHelpResource) {
            this.displayHelpResource(iHelpResource.getHref());
        }

        public void displayHelp(String string) {
            this.displayHelpResource(string);
        }

        public void displayHelp(String string, String string2) {
            this.displayHelpResource(string2);
        }

        public void displayHelp(String string, int n, int n2) {
            this.displayContext(string, n, n2);
        }

        public void displayHelp(IContext iContext, int n, int n2) {
            this.displayContext(iContext, n, n2);
        }

        public IContext getContext(String string) {
            return HelpSystem.getContext((String)string);
        }

        public IToc[] getTocs() {
            return HelpSystem.getTocs();
        }

        public boolean isContextHelpDisplayed() {
            return this.isContextHelpDisplayed();
        }
    }

    private static class ContextWithTitle
    implements IContext2 {
        private IContext context;
        private String title;

        ContextWithTitle(IContext iContext, String string) {
            this.context = iContext;
            this.title = string;
        }

        public String getTitle() {
            String string;
            if (this.context instanceof IContext2 && (string = ((IContext2)this.context).getTitle()) != null) {
                return string;
            }
            return this.title;
        }

        public String getStyledText() {
            if (this.context instanceof IContext2) {
                return ((IContext2)this.context).getStyledText();
            }
            return this.context.getText();
        }

        public String getCategory(IHelpResource iHelpResource) {
            if (this.context instanceof IContext2) {
                return ((IContext2)this.context).getCategory(iHelpResource);
            }
            return null;
        }

        public IHelpResource[] getRelatedTopics() {
            return this.context.getRelatedTopics();
        }

        public String getText() {
            return this.context.getText();
        }
    }

    private static class WorkbenchHelpListener
    implements HelpListener {
        private WorkbenchHelpListener() {
        }

        public void helpRequested(HelpEvent helpEvent) {
            Point point;
            if (WorkbenchHelpSystem.getInstance().getHelpUI() == null) {
                return;
            }
            Object object = helpEvent.widget.getData(WorkbenchHelpSystem.HELP_KEY);
            IContext iContext = null;
            if (object instanceof String) {
                iContext = HelpSystem.getContext((String)((String)object));
            } else if (object instanceof IContext) {
                iContext = (IContext)object;
            } else if (object instanceof IContextComputer) {
                point = ((IContextComputer)object).computeContexts(helpEvent);
                if (point != null && ((Point)point).length > 0) {
                    Point point2 = point[0];
                    if (point2 instanceof String) {
                        iContext = HelpSystem.getContext((String)((String)point2));
                    } else if (point2 instanceof IContext) {
                        iContext = (IContext)point2;
                    }
                }
            } else if (object instanceof Object[] && ((Point)(point = (Object[])object)).length > 0) {
                Point point3 = point[0];
                if (point3 instanceof String) {
                    iContext = HelpSystem.getContext((String)((String)point3));
                } else if (point3 instanceof IContext) {
                    iContext = (IContext)point3;
                }
            }
            if (iContext == null) {
                iContext = HelpSystem.getContext((String)"org.eclipse.ui.missing");
            }
            if (iContext != null) {
                point = WorkbenchHelpSystem.computePopUpLocation(helpEvent.widget.getDisplay());
                WorkbenchHelpSystem.getInstance().displayContext(iContext, point.x, point.y);
            }
        }
    }
}

