/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.handlers;

import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.LegacyResourceSupport;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.ImportExportWizard;
import org.eclipse.ui.internal.dialogs.NewWizard;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.wizards.IWizardDescriptor;
import org.eclipse.ui.wizards.IWizardRegistry;

public abstract class WizardHandler
extends AbstractHandler
implements IElementUpdater {
    protected abstract void executeHandler(ExecutionEvent var1);

    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        String string = executionEvent.getParameter(this.getWizardIdParameterId());
        IWorkbenchWindow iWorkbenchWindow = HandlerUtil.getActiveWorkbenchWindowChecked(executionEvent);
        if (string == null) {
            this.executeHandler(executionEvent);
        } else {
            IWorkbenchWizard iWorkbenchWizard;
            block6: {
                IWizardRegistry iWizardRegistry = this.getWizardRegistry();
                IWizardDescriptor iWizardDescriptor = iWizardRegistry.findWizard(string);
                if (iWizardDescriptor == null) {
                    throw new ExecutionException("unknown wizard: " + string);
                }
                try {
                    iWorkbenchWizard = iWizardDescriptor.createWizard();
                    iWorkbenchWizard.init(PlatformUI.getWorkbench(), this.getSelectionToUse(executionEvent));
                    if (!iWizardDescriptor.canFinishEarly() || iWizardDescriptor.hasPages()) break block6;
                    iWorkbenchWizard.performFinish();
                    return null;
                }
                catch (CoreException coreException) {
                    throw new ExecutionException("error creating wizard", (Throwable)coreException);
                }
            }
            Shell shell = iWorkbenchWindow.getShell();
            WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)iWorkbenchWizard);
            wizardDialog.create();
            wizardDialog.open();
        }
        return null;
    }

    protected IStructuredSelection getSelectionToUse(ExecutionEvent executionEvent) {
        ISelection iSelection = HandlerUtil.getCurrentSelection(executionEvent);
        if (iSelection instanceof IStructuredSelection) {
            return (IStructuredSelection)iSelection;
        }
        return StructuredSelection.EMPTY;
    }

    @Override
    public void updateElement(UIElement uIElement, Map map) {
        String string = (String)map.get(this.getWizardIdParameterId());
        if (string == null) {
            return;
        }
        IWizardDescriptor iWizardDescriptor = this.getWizardRegistry().findWizard(string);
        if (iWizardDescriptor != null) {
            uIElement.setText(NLS.bind((String)WorkbenchMessages.WizardHandler_menuLabel, (Object)iWizardDescriptor.getLabel()));
            uIElement.setTooltip(iWizardDescriptor.getDescription());
            uIElement.setIcon(iWizardDescriptor.getImageDescriptor());
        }
    }

    protected abstract String getWizardIdParameterId();

    protected abstract IWizardRegistry getWizardRegistry();

    public static final class Export
    extends WizardHandler {
        private static final int SIZING_WIZARD_WIDTH = 470;
        private static final int SIZING_WIZARD_HEIGHT = 550;

        @Override
        protected String getWizardIdParameterId() {
            return "exportWizardId";
        }

        @Override
        protected IWizardRegistry getWizardRegistry() {
            return PlatformUI.getWorkbench().getExportWizardRegistry();
        }

        @Override
        protected void executeHandler(ExecutionEvent executionEvent) {
            IWorkbenchWindow iWorkbenchWindow = HandlerUtil.getActiveWorkbenchWindow(executionEvent);
            if (iWorkbenchWindow == null) {
                return;
            }
            ImportExportWizard importExportWizard = new ImportExportWizard("export");
            IStructuredSelection iStructuredSelection = this.getSelectionToUse(executionEvent);
            importExportWizard.init(iWorkbenchWindow.getWorkbench(), iStructuredSelection);
            IDialogSettings iDialogSettings = WorkbenchPlugin.getDefault().getDialogSettings();
            IDialogSettings iDialogSettings2 = iDialogSettings.getSection("ImportExportAction");
            if (iDialogSettings2 == null) {
                iDialogSettings2 = iDialogSettings.addNewSection("ImportExportAction");
            }
            importExportWizard.setDialogSettings(iDialogSettings2);
            importExportWizard.setForcePreviousAndNextButtons(true);
            Shell shell = iWorkbenchWindow.getShell();
            WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)importExportWizard);
            wizardDialog.create();
            wizardDialog.getShell().setSize(Math.max(470, wizardDialog.getShell().getSize().x), 550);
            iWorkbenchWindow.getWorkbench().getHelpSystem().setHelp((Control)wizardDialog.getShell(), "org.eclipse.ui.export_wizard_context");
            wizardDialog.open();
        }
    }

    public static final class Import
    extends WizardHandler {
        private static final int SIZING_WIZARD_WIDTH = 470;
        private static final int SIZING_WIZARD_HEIGHT = 550;

        @Override
        protected String getWizardIdParameterId() {
            return "importWizardId";
        }

        @Override
        protected IWizardRegistry getWizardRegistry() {
            return PlatformUI.getWorkbench().getImportWizardRegistry();
        }

        @Override
        protected void executeHandler(ExecutionEvent executionEvent) {
            IWorkbenchWindow iWorkbenchWindow = HandlerUtil.getActiveWorkbenchWindow(executionEvent);
            if (iWorkbenchWindow == null) {
                return;
            }
            ImportExportWizard importExportWizard = new ImportExportWizard("import");
            IStructuredSelection iStructuredSelection = this.getSelectionToUse(executionEvent);
            importExportWizard.init(iWorkbenchWindow.getWorkbench(), iStructuredSelection);
            IDialogSettings iDialogSettings = WorkbenchPlugin.getDefault().getDialogSettings();
            IDialogSettings iDialogSettings2 = iDialogSettings.getSection("ImportExportAction");
            if (iDialogSettings2 == null) {
                iDialogSettings2 = iDialogSettings.addNewSection("ImportExportAction");
            }
            importExportWizard.setDialogSettings(iDialogSettings2);
            importExportWizard.setForcePreviousAndNextButtons(true);
            Shell shell = iWorkbenchWindow.getShell();
            WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)importExportWizard);
            wizardDialog.create();
            wizardDialog.getShell().setSize(Math.max(470, wizardDialog.getShell().getSize().x), 550);
            iWorkbenchWindow.getWorkbench().getHelpSystem().setHelp((Control)wizardDialog.getShell(), "org.eclipse.ui.import_wizard_context");
            wizardDialog.open();
        }
    }

    public static final class New
    extends WizardHandler {
        private static final int SIZING_WIZARD_WIDTH = 500;
        private static final int SIZING_WIZARD_HEIGHT = 500;
        private String categoryId = null;

        @Override
        protected String getWizardIdParameterId() {
            return "newWizardId";
        }

        @Override
        protected IWizardRegistry getWizardRegistry() {
            return PlatformUI.getWorkbench().getNewWizardRegistry();
        }

        public String getCategoryId() {
            return this.categoryId;
        }

        public void setCategoryId(String string) {
            this.categoryId = string;
        }

        @Override
        protected IStructuredSelection getSelectionToUse(ExecutionEvent executionEvent) {
            ISelection iSelection = HandlerUtil.getCurrentSelection(executionEvent);
            StructuredSelection structuredSelection = StructuredSelection.EMPTY;
            if (iSelection instanceof IStructuredSelection) {
                structuredSelection = (IStructuredSelection)iSelection;
            } else {
                IEditorInput iEditorInput;
                Object object;
                IWorkbenchWindow iWorkbenchWindow;
                IWorkbenchPart iWorkbenchPart;
                Class clazz = LegacyResourceSupport.getResourceClass();
                if (clazz != null && (iWorkbenchPart = (iWorkbenchWindow = HandlerUtil.getActiveWorkbenchWindow(executionEvent)).getPartService().getActivePart()) instanceof IEditorPart && (object = Util.getAdapter(iEditorInput = ((IEditorPart)iWorkbenchPart).getEditorInput(), clazz)) != null) {
                    structuredSelection = new StructuredSelection(object);
                }
            }
            return structuredSelection;
        }

        @Override
        protected void executeHandler(ExecutionEvent executionEvent) {
            IWorkbenchWindow iWorkbenchWindow = HandlerUtil.getActiveWorkbenchWindow(executionEvent);
            if (iWorkbenchWindow == null) {
                return;
            }
            NewWizard newWizard = new NewWizard();
            newWizard.setCategoryId(this.categoryId);
            IStructuredSelection iStructuredSelection = this.getSelectionToUse(executionEvent);
            newWizard.init(iWorkbenchWindow.getWorkbench(), iStructuredSelection);
            IDialogSettings iDialogSettings = WorkbenchPlugin.getDefault().getDialogSettings();
            IDialogSettings iDialogSettings2 = iDialogSettings.getSection("NewWizardAction");
            if (iDialogSettings2 == null) {
                iDialogSettings2 = iDialogSettings.addNewSection("NewWizardAction");
            }
            newWizard.setDialogSettings(iDialogSettings2);
            newWizard.setForcePreviousAndNextButtons(true);
            Shell shell = iWorkbenchWindow.getShell();
            WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)newWizard);
            wizardDialog.create();
            wizardDialog.getShell().setSize(Math.max(500, wizardDialog.getShell().getSize().x), 500);
            iWorkbenchWindow.getWorkbench().getHelpSystem().setHelp((Control)wizardDialog.getShell(), "org.eclipse.ui.new_wizard_context");
            wizardDialog.open();
        }
    }
}

