/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.handlers;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.internal.ExceptionHandler;

public class WidgetMethodHandler
extends AbstractHandler
implements IExecutableExtension {
    protected static final Class[] NO_PARAMETERS = new Class[0];
    protected String methodName;
    private Listener focusListener;
    private Display display = Display.getCurrent();

    public WidgetMethodHandler() {
        if (this.display != null) {
            this.focusListener = new Listener(){

                public void handleEvent(Event event) {
                    WidgetMethodHandler.this.updateEnablement();
                }
            };
            this.display.addFilter(15, this.focusListener);
        }
    }

    void updateEnablement() {
        boolean bl = this.isHandled();
        if (bl != this.isEnabled()) {
            this.setBaseEnabled(bl);
        }
    }

    public void setEnabled(Object object) {
        this.updateEnablement();
    }

    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        block9: {
            final Method method = this.getMethodToExecute();
            if (method != null) {
                try {
                    final Control control = Display.getCurrent().getFocusControl();
                    if (control instanceof Composite && (((Composite)control).getStyle() & 0x1000000) != 0) {
                        try {
                            final Object object = this.getFocusComponent();
                            if (object != null) {
                                Runnable runnable = new Runnable(){

                                    @Override
                                    public void run() {
                                        try {
                                            method.invoke(object, null);
                                        }
                                        catch (IllegalAccessException illegalAccessException) {
                                        }
                                        catch (InvocationTargetException invocationTargetException) {
                                            control.getDisplay().asyncExec(new Runnable(){

                                                @Override
                                                public void run() {
                                                    ExceptionHandler.getInstance().handleException(new ExecutionException("An exception occurred while executing " + method.getName(), invocationTargetException.getTargetException()));
                                                }
                                            });
                                        }
                                    }
                                };
                                this.swingInvokeLater(runnable);
                            }
                            break block9;
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            break block9;
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            throw new Error("Something is seriously wrong here");
                        }
                    }
                    method.invoke((Object)control, null);
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new ExecutionException("An exception occurred while executing " + method.getName(), invocationTargetException.getTargetException());
                }
            }
        }
        return null;
    }

    protected void swingInvokeLater(Runnable runnable) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = Class.forName("javax.swing.SwingUtilities");
        Method method = clazz.getMethod("invokeLater", Runnable.class);
        method.invoke(clazz, runnable);
    }

    protected Object getFocusComponent() throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("java.awt.KeyboardFocusManager");
        }
        catch (ClassNotFoundException classNotFoundException) {}
        if (clazz != null) {
            Method method = clazz.getMethod("getCurrentKeyboardFocusManager", null);
            Object object = method.invoke(clazz, null);
            Method method2 = clazz.getMethod("getFocusOwner", null);
            Object object2 = method2.invoke(object, null);
            return object2;
        }
        Class<?> clazz2 = Class.forName("javax.swing.FocusManager");
        Method method = clazz2.getMethod("getCurrentManager", null);
        Object object = method.invoke(clazz2, null);
        Method method3 = clazz2.getMethod("getFocusOwner", null);
        Object object3 = method3.invoke(object, null);
        return object3;
    }

    public final boolean isHandled() {
        return this.getMethodToExecute() != null;
    }

    protected Method getMethodToExecute() {
        Object object;
        Display display = Display.getCurrent();
        if (display == null) {
            return null;
        }
        Control control = display.getFocusControl();
        Method method = null;
        if (control != null) {
            object = control.getClass();
            try {
                method = ((Class)object).getMethod(this.methodName, NO_PARAMETERS);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        if (method == null && control instanceof Composite && (((Composite)control).getStyle() & 0x1000000) != 0) {
            try {
                object = this.getFocusComponent();
                if (object != null) {
                    Class<?> clazz = object.getClass();
                    try {
                        method = clazz.getMethod(this.methodName, NO_PARAMETERS);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {}
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new Error("Something is seriously wrong here");
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new Error("Something is seriously wrong here");
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new Error("Something is seriously wrong here");
            }
        }
        return method;
    }

    public void setInitializationData(IConfigurationElement iConfigurationElement, String string, Object object) {
        this.methodName = object.toString();
    }

    public void dispose() {
        if (this.display != null && !this.display.isDisposed()) {
            this.display.removeFilter(15, this.focusListener);
        }
        this.display = null;
        this.focusListener = null;
    }
}

