/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.handlers;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.services.IWorkbenchLocationService;
import org.eclipse.ui.menus.UIElement;

public class ToggleCoolbarHandler
extends AbstractHandler
implements IElementUpdater {
    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        IWorkbenchWindow iWorkbenchWindow = HandlerUtil.getActiveWorkbenchWindowChecked(executionEvent);
        if (iWorkbenchWindow instanceof WorkbenchWindow) {
            WorkbenchWindow workbenchWindow = (WorkbenchWindow)iWorkbenchWindow;
            workbenchWindow.toggleToolbarVisibility();
            ICommandService iCommandService = (ICommandService)iWorkbenchWindow.getService(ICommandService.class);
            HashMap<String, WorkbenchWindow> hashMap = new HashMap<String, WorkbenchWindow>();
            hashMap.put("org.eclipse.ui.IWorkbenchWindow", workbenchWindow);
            iCommandService.refreshElements(executionEvent.getCommand().getId(), hashMap);
        }
        return null;
    }

    @Override
    public void updateElement(UIElement uIElement, Map map) {
        IWorkbenchLocationService iWorkbenchLocationService = (IWorkbenchLocationService)uIElement.getServiceLocator().getService(IWorkbenchLocationService.class);
        IWorkbenchWindow iWorkbenchWindow = iWorkbenchLocationService.getWorkbenchWindow();
        if (iWorkbenchWindow == null || !(iWorkbenchWindow instanceof WorkbenchWindow)) {
            return;
        }
        uIElement.setText(this.isCoolbarVisible((WorkbenchWindow)iWorkbenchWindow) ? WorkbenchMessages.ToggleCoolbarVisibilityAction_hide_text : WorkbenchMessages.ToggleCoolbarVisibilityAction_show_text);
    }

    private boolean isCoolbarVisible(WorkbenchWindow workbenchWindow) {
        return workbenchWindow.getCoolBarVisible() || workbenchWindow.getPerspectiveBarVisible();
    }
}

