/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.window.ToolTip;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.testing.ContributionInfoMessages;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.testing.ContributionInfo;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class SpyHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent executionEvent) {
        Control control;
        Shell shell = HandlerUtil.getActiveShell(executionEvent);
        if (shell != null && (control = shell.getDisplay().getFocusControl()) != null) {
            this.showTooltip(control);
        }
        return null;
    }

    protected void showTooltip(Control control) {
        ContributionInfo contributionInfo = null;
        Point point = new Point(0, 0);
        while (control != null) {
            TableItem tableItem;
            Object object;
            if (control instanceof Table) {
                object = (Table)control;
                if (object.getSelectionCount() == 1 && (contributionInfo = this.getContributionInfo((tableItem = object.getSelection()[0]).getData(), ContributionInfoMessages.ContributionInfo_TableItem)) != null) {
                    Rectangle rectangle = tableItem.getBounds();
                    point = new Point(rectangle.x, rectangle.y);
                    break;
                }
            } else if (control instanceof Tree && (object = (Tree)control).getSelectionCount() == 1 && (contributionInfo = this.getContributionInfo((tableItem = object.getSelection()[0]).getData(), ContributionInfoMessages.ContributionInfo_TreeItem)) != null) {
                Rectangle rectangle = tableItem.getBounds();
                point = new Point(rectangle.x, rectangle.y);
                break;
            }
            object = control instanceof Shell ? ContributionInfoMessages.ContributionInfo_Window : null;
            contributionInfo = this.getContributionInfo(control.getData(), (String)object);
            if (contributionInfo != null) break;
            control = control.getParent();
        }
        if (contributionInfo == null) {
            return;
        }
        this.doShowTooltip(control, point, contributionInfo);
    }

    protected void doShowTooltip(Control control, Point point, final ContributionInfo contributionInfo) {
        ToolTip toolTip = new ToolTip(control, 2, true){

            protected Composite createToolTipContentArea(Event event, Composite composite) {
                Composite composite2 = new Composite(composite, 0);
                composite2.setBackground(composite.getDisplay().getSystemColor(29));
                Text text = new Text(composite2, 8);
                text.setBackground(composite.getDisplay().getSystemColor(29));
                String string = NLS.bind((String)ContributionInfoMessages.ContributionInfo_ContributedBy, (Object)contributionInfo.getElementType(), (Object)contributionInfo.getBundleId());
                text.setText(string);
                GridLayoutFactory.fillDefaults().margins(2, 2).generateLayout(composite2);
                return composite2;
            }
        };
        toolTip.setHideOnMouseDown(false);
        toolTip.setHideDelay(3000);
        toolTip.show(point);
    }

    ContributionInfo getContributionInfo(Object object, String string) {
        Bundle bundle;
        if (object instanceof ContributionInfo) {
            return (ContributionInfo)object;
        }
        ContributionInfo contributionInfo = (ContributionInfo)Util.getAdapter(object, ContributionInfo.class);
        if (string != null && contributionInfo == null && object != null && (bundle = FrameworkUtil.getBundle(object.getClass())) != null) {
            contributionInfo = new ContributionInfo(bundle.getSymbolicName(), string != null ? string : ContributionInfoMessages.ContributionInfo_Unknown, null);
        }
        return contributionInfo;
    }
}

