/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.ISourceProvider;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.expressions.AndExpression;
import org.eclipse.ui.internal.handlers.HandlerActivation;

public class SlaveHandlerService
implements IHandlerService {
    protected final Expression defaultExpression;
    private Collection fSourceProviders = new ArrayList();
    protected final Map localActivationsToParentActivations = new HashMap();
    protected final IHandlerService parent;
    protected final Set parentActivations = new HashSet();

    public SlaveHandlerService(IHandlerService iHandlerService, Expression expression) {
        if (iHandlerService == null) {
            throw new NullPointerException("The parent handler service cannot be null");
        }
        this.defaultExpression = expression;
        this.parent = iHandlerService;
    }

    @Override
    public final IHandlerActivation activateHandler(IHandlerActivation iHandlerActivation) {
        String string = iHandlerActivation.getCommandId();
        IHandler iHandler = iHandlerActivation.getHandler();
        Expression expression = iHandlerActivation.getExpression();
        Expression expression2 = this.defaultExpression;
        if (expression != null && this.defaultExpression != null) {
            AndExpression andExpression = new AndExpression();
            andExpression.add(expression);
            andExpression.add(this.defaultExpression);
            expression2 = andExpression;
        } else if (expression != null) {
            expression2 = expression;
        }
        int n = iHandlerActivation.getDepth() + 1;
        HandlerActivation handlerActivation = new HandlerActivation(string, iHandler, expression2, n, this);
        return this.doActivation(handlerActivation);
    }

    @Override
    public final IHandlerActivation activateHandler(String string, IHandler iHandler) {
        HandlerActivation handlerActivation = new HandlerActivation(string, iHandler, this.defaultExpression, 1, this);
        return this.doActivation(handlerActivation);
    }

    @Override
    public final IHandlerActivation activateHandler(String string, IHandler iHandler, Expression expression) {
        return this.activateHandler(string, iHandler, expression, false);
    }

    @Override
    public final IHandlerActivation activateHandler(String string, IHandler iHandler, Expression expression, boolean bl) {
        Object object;
        if (bl) {
            IHandlerActivation iHandlerActivation = this.parent.activateHandler(string, iHandler, expression, bl);
            this.parentActivations.add(iHandlerActivation);
            return iHandlerActivation;
        }
        Expression expression2 = this.defaultExpression;
        if (expression != null && this.defaultExpression != null) {
            object = new AndExpression();
            object.add(expression);
            object.add(this.defaultExpression);
            expression2 = object;
        } else if (expression != null) {
            expression2 = expression;
        }
        object = new HandlerActivation(string, iHandler, expression2, 1, this);
        return this.doActivation((IHandlerActivation)object);
    }

    @Override
    public final IHandlerActivation activateHandler(String string, IHandler iHandler, Expression expression, int n) {
        return this.activateHandler(string, iHandler, expression);
    }

    @Override
    public final void addSourceProvider(ISourceProvider iSourceProvider) {
        if (!this.fSourceProviders.contains(iSourceProvider)) {
            this.fSourceProviders.add(iSourceProvider);
        }
        this.parent.addSourceProvider(iSourceProvider);
    }

    @Override
    public final ExecutionEvent createExecutionEvent(Command command, Event event) {
        return this.parent.createExecutionEvent(command, event);
    }

    @Override
    public final ExecutionEvent createExecutionEvent(ParameterizedCommand parameterizedCommand, Event event) {
        return this.parent.createExecutionEvent(parameterizedCommand, event);
    }

    @Override
    public final void deactivateHandler(IHandlerActivation iHandlerActivation) {
        IHandlerActivation iHandlerActivation2 = this.localActivationsToParentActivations.containsKey(iHandlerActivation) ? (IHandlerActivation)this.localActivationsToParentActivations.remove(iHandlerActivation) : iHandlerActivation;
        if (iHandlerActivation2 != null) {
            this.parent.deactivateHandler(iHandlerActivation2);
            this.parentActivations.remove(iHandlerActivation2);
        }
    }

    @Override
    public final void deactivateHandlers(Collection collection) {
        Object[] objectArray = collection.toArray();
        int n = 0;
        while (n < objectArray.length) {
            this.deactivateHandler((IHandlerActivation)objectArray[n]);
            objectArray[n] = null;
            ++n;
        }
    }

    @Override
    public final void dispose() {
        this.parent.deactivateHandlers(this.parentActivations);
        this.parentActivations.clear();
        this.localActivationsToParentActivations.clear();
        if (!this.fSourceProviders.isEmpty()) {
            Object[] objectArray = this.fSourceProviders.toArray();
            int n = 0;
            while (n < objectArray.length) {
                this.removeSourceProvider((ISourceProvider)objectArray[n]);
                ++n;
            }
            this.fSourceProviders.clear();
        }
    }

    protected IHandlerActivation doActivation(IHandlerActivation iHandlerActivation) {
        IHandlerActivation iHandlerActivation2 = this.parent.activateHandler(iHandlerActivation);
        this.parentActivations.add(iHandlerActivation2);
        this.localActivationsToParentActivations.put(iHandlerActivation, iHandlerActivation2);
        return iHandlerActivation;
    }

    @Override
    public final Object executeCommand(ParameterizedCommand parameterizedCommand, Event event) throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
        return this.parent.executeCommand(parameterizedCommand, event);
    }

    @Override
    public final Object executeCommand(String string, Event event) throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
        return this.parent.executeCommand(string, event);
    }

    @Override
    public final IEvaluationContext getCurrentState() {
        return this.parent.getCurrentState();
    }

    @Override
    public final void readRegistry() {
        this.parent.readRegistry();
    }

    @Override
    public final void removeSourceProvider(ISourceProvider iSourceProvider) {
        this.fSourceProviders.remove(iSourceProvider);
        this.parent.removeSourceProvider(iSourceProvider);
    }

    @Override
    public final void setHelpContextId(IHandler iHandler, String string) {
        this.parent.setHelpContextId(iHandler, string);
    }

    Expression getDefaultExpression() {
        return this.defaultExpression;
    }

    @Override
    public IEvaluationContext createContextSnapshot(boolean bl) {
        return this.parent.createContextSnapshot(bl);
    }

    @Override
    public Object executeCommandInContext(ParameterizedCommand parameterizedCommand, Event event, IEvaluationContext iEvaluationContext) throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
        return this.parent.executeCommandInContext(parameterizedCommand, event, iEvaluationContext);
    }
}

