/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.handlers;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.internal.ExceptionHandler;
import org.eclipse.ui.internal.handlers.WidgetMethodHandler;

public class SelectAllHandler
extends WidgetMethodHandler {
    private static final Class[] METHOD_PARAMETERS = new Class[]{Point.class};

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        final Method method = this.getMethodToExecute();
        if (method == null) return null;
        try {
            final Control control = Display.getCurrent().getFocusControl();
            int n = method.getParameterTypes().length;
            if (control instanceof Composite && (((Composite)control).getStyle() & 0x1000000) != 0) {
                if (n != 0) {
                    return null;
                }
                try {
                    final Object object = this.getFocusComponent();
                    if (object == null) return null;
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                method.invoke(object, null);
                                control.getDisplay().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (!control.isDisposed()) {
                                            control.notifyListeners(13, null);
                                        }
                                    }
                                });
                            }
                            catch (IllegalAccessException illegalAccessException) {
                            }
                            catch (InvocationTargetException invocationTargetException) {
                                control.getDisplay().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        ExceptionHandler.getInstance().handleException(new ExecutionException("An exception occurred while executing " + method.getName(), invocationTargetException.getTargetException()));
                                    }
                                });
                            }
                        }
                    };
                    this.swingInvokeLater(runnable);
                    return null;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return null;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new Error("Something is seriously wrong here");
                }
            }
            if (n == 0) {
                method.invoke((Object)control, null);
                control.notifyListeners(13, null);
                return null;
            }
            if (n != 1) throw new ExecutionException("Too many parameters on select all", (Throwable)new Exception());
            Method method2 = control.getClass().getMethod("getTextLimit", NO_PARAMETERS);
            Integer n2 = (Integer)method2.invoke((Object)control, null);
            Object[] objectArray = new Object[]{new Point(0, n2.intValue())};
            method.invoke((Object)control, objectArray);
            if (control instanceof Combo) return null;
            control.notifyListeners(13, null);
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ExecutionException("An exception occurred while executing " + this.getMethodToExecute(), invocationTargetException.getTargetException());
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        return null;
    }

    @Override
    protected Method getMethodToExecute() {
        Control control;
        Method method = super.getMethodToExecute();
        if (method == null && (control = Display.getCurrent().getFocusControl()) != null) {
            try {
                method = control.getClass().getMethod("setSelection", METHOD_PARAMETERS);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        return method;
    }

    @Override
    public void setInitializationData(IConfigurationElement iConfigurationElement, String string, Object object) {
        this.methodName = "selectAll";
    }
}

