/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.SavePerspectiveDialog;
import org.eclipse.ui.internal.registry.PerspectiveDescriptor;
import org.eclipse.ui.internal.registry.PerspectiveRegistry;

public class SavePerspectiveHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent executionEvent) {
        PerspectiveDescriptor perspectiveDescriptor;
        WorkbenchPage workbenchPage;
        IWorkbenchWindow iWorkbenchWindow = HandlerUtil.getActiveWorkbenchWindow(executionEvent);
        if (iWorkbenchWindow != null && (workbenchPage = (WorkbenchPage)iWorkbenchWindow.getActivePage()) != null && (perspectiveDescriptor = (PerspectiveDescriptor)workbenchPage.getPerspective()) != null) {
            if (perspectiveDescriptor.isSingleton()) {
                this.saveSingleton(workbenchPage);
            } else {
                this.saveNonSingleton(workbenchPage, perspectiveDescriptor);
            }
        }
        return null;
    }

    private void saveSingleton(IWorkbenchPage iWorkbenchPage) {
        String[] stringArray = new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL};
        MessageDialog messageDialog = new MessageDialog(iWorkbenchPage.getWorkbenchWindow().getShell(), WorkbenchMessages.SavePerspective_overwriteTitle, null, WorkbenchMessages.SavePerspective_singletonQuestion, 3, stringArray, 0);
        if (messageDialog.open() == 0) {
            iWorkbenchPage.savePerspective();
        }
    }

    private void saveNonSingleton(IWorkbenchPage iWorkbenchPage, PerspectiveDescriptor perspectiveDescriptor) {
        String string;
        PerspectiveRegistry perspectiveRegistry = (PerspectiveRegistry)WorkbenchPlugin.getDefault().getPerspectiveRegistry();
        SavePerspectiveDialog savePerspectiveDialog = new SavePerspectiveDialog(iWorkbenchPage.getWorkbenchWindow().getShell(), perspectiveRegistry);
        IPerspectiveDescriptor iPerspectiveDescriptor = perspectiveRegistry.findPerspectiveWithId(perspectiveDescriptor.getId());
        savePerspectiveDialog.setInitialSelection(iPerspectiveDescriptor);
        if (savePerspectiveDialog.open() != 0) {
            return;
        }
        PerspectiveDescriptor perspectiveDescriptor2 = (PerspectiveDescriptor)savePerspectiveDialog.getPersp();
        if (perspectiveDescriptor2 == null && (perspectiveDescriptor2 = perspectiveRegistry.createPerspective(string = savePerspectiveDialog.getPerspName(), (PerspectiveDescriptor)iPerspectiveDescriptor)) == null) {
            MessageDialog.openError((Shell)savePerspectiveDialog.getShell(), (String)WorkbenchMessages.SavePerspective_errorTitle, (String)WorkbenchMessages.SavePerspective_errorMessage);
            return;
        }
        iWorkbenchPage.savePerspectiveAs(perspectiveDescriptor2);
    }
}

