/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.ISaveablesSource;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.InternalHandlerUtil;
import org.eclipse.ui.internal.SaveableHelper;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.handlers.AbstractSaveHandler;

public class SaveHandler
extends AbstractSaveHandler {
    public SaveHandler() {
        this.registerEnablement();
    }

    public Object execute(ExecutionEvent executionEvent) {
        ISaveablePart iSaveablePart = this.getSaveablePart(executionEvent);
        if (iSaveablePart == null) {
            return null;
        }
        if (iSaveablePart instanceof IEditorPart) {
            IEditorPart iEditorPart = (IEditorPart)iSaveablePart;
            IWorkbenchPage iWorkbenchPage = iEditorPart.getSite().getPage();
            iWorkbenchPage.saveEditor(iEditorPart, false);
            return null;
        }
        IWorkbenchPart iWorkbenchPart = HandlerUtil.getActivePart(executionEvent);
        WorkbenchPage workbenchPage = (WorkbenchPage)iWorkbenchPart.getSite().getPage();
        workbenchPage.savePart(iSaveablePart, iWorkbenchPart, false);
        return null;
    }

    @Override
    protected EvaluationResult evaluate(IEvaluationContext iEvaluationContext) {
        IWorkbenchWindow iWorkbenchWindow = InternalHandlerUtil.getActiveWorkbenchWindow(iEvaluationContext);
        if (iWorkbenchWindow == null) {
            return EvaluationResult.FALSE;
        }
        WorkbenchPage workbenchPage = (WorkbenchPage)iWorkbenchWindow.getActivePage();
        if (workbenchPage == null) {
            return EvaluationResult.FALSE;
        }
        ISaveablePart iSaveablePart = this.getSaveablePart(iEvaluationContext);
        if (iSaveablePart == null) {
            return EvaluationResult.FALSE;
        }
        if (iSaveablePart instanceof ISaveablesSource) {
            ISaveablesSource iSaveablesSource = (ISaveablesSource)((Object)iSaveablePart);
            if (SaveableHelper.needsSave(iSaveablesSource)) {
                return EvaluationResult.TRUE;
            }
            return EvaluationResult.FALSE;
        }
        if (iSaveablePart != null && iSaveablePart.isDirty()) {
            return EvaluationResult.TRUE;
        }
        return EvaluationResult.FALSE;
    }
}

