/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.InternalHandlerUtil;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.handlers.AbstractSaveHandler;

public class SaveAsHandler
extends AbstractSaveHandler {
    public SaveAsHandler() {
        this.registerEnablement();
    }

    public Object execute(ExecutionEvent executionEvent) {
        ISaveablePart iSaveablePart = this.getSaveablePart(executionEvent);
        if (iSaveablePart != null) {
            iSaveablePart.doSaveAs();
        }
        return null;
    }

    @Override
    protected EvaluationResult evaluate(IEvaluationContext iEvaluationContext) {
        IWorkbenchWindow iWorkbenchWindow = InternalHandlerUtil.getActiveWorkbenchWindow(iEvaluationContext);
        if (iWorkbenchWindow == null) {
            return EvaluationResult.FALSE;
        }
        WorkbenchPage workbenchPage = (WorkbenchPage)iWorkbenchWindow.getActivePage();
        if (workbenchPage == null) {
            return EvaluationResult.FALSE;
        }
        ISaveablePart iSaveablePart = this.getSaveablePart(iEvaluationContext);
        if (iSaveablePart == null) {
            return EvaluationResult.FALSE;
        }
        return iSaveablePart.isSaveAsAllowed() ? EvaluationResult.TRUE : EvaluationResult.FALSE;
    }
}

