/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.ui.ISaveablesLifecycleListener;
import org.eclipse.ui.ISaveablesSource;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.InternalHandlerUtil;
import org.eclipse.ui.internal.SaveablesList;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.handlers.AbstractSaveHandler;

public class SaveAllHandler
extends AbstractSaveHandler {
    public SaveAllHandler() {
        this.registerEnablement();
    }

    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        IWorkbenchWindow iWorkbenchWindow = HandlerUtil.getActiveWorkbenchWindowChecked(executionEvent);
        IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
        if (iWorkbenchPage != null) {
            ((WorkbenchPage)iWorkbenchPage).saveAllEditors(false, true);
        }
        return null;
    }

    @Override
    protected EvaluationResult evaluate(IEvaluationContext iEvaluationContext) {
        IWorkbenchWindow iWorkbenchWindow = InternalHandlerUtil.getActiveWorkbenchWindow(iEvaluationContext);
        if (iWorkbenchWindow == null) {
            return EvaluationResult.FALSE;
        }
        WorkbenchPage workbenchPage = (WorkbenchPage)iWorkbenchWindow.getActivePage();
        if (workbenchPage == null) {
            return EvaluationResult.FALSE;
        }
        if (workbenchPage.getDirtyParts().length > 0) {
            return EvaluationResult.TRUE;
        }
        SaveablesList saveablesList = (SaveablesList)iWorkbenchWindow.getWorkbench().getService(ISaveablesLifecycleListener.class);
        ISaveablesSource[] iSaveablesSourceArray = saveablesList.getNonPartSources();
        int n = 0;
        while (n < iSaveablesSourceArray.length) {
            Saveable[] saveableArray = iSaveablesSourceArray[n].getSaveables();
            int n2 = 0;
            while (n2 < saveableArray.length) {
                if (saveableArray[n2].isDirty()) {
                    return EvaluationResult.TRUE;
                }
                ++n2;
            }
            ++n;
        }
        return EvaluationResult.FALSE;
    }
}

