/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuListener2;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.QuickMenuCreator;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.progress.UIJob;

public class QuickMenuHandler
extends AbstractHandler
implements IMenuListener2 {
    private QuickMenuCreator creator = new QuickMenuCreator(){

        @Override
        protected void fillMenu(IMenuManager iMenuManager) {
            if (!(iMenuManager instanceof ContributionManager)) {
                return;
            }
            IMenuService iMenuService = (IMenuService)PlatformUI.getWorkbench().getService(IMenuService.class);
            iMenuService.populateContributionManager((ContributionManager)iMenuManager, QuickMenuHandler.this.locationURI);
            iMenuManager.addMenuListener((IMenuListener)QuickMenuHandler.this);
        }
    };
    private String locationURI;

    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        this.locationURI = executionEvent.getParameter("org.eclipse.ui.window.quickMenu.uri");
        if (this.locationURI == null) {
            throw new ExecutionException("locatorURI must not be null");
        }
        this.creator.createMenu();
        return null;
    }

    public void dispose() {
        if (this.creator != null) {
            this.creator.dispose();
            this.creator = null;
        }
    }

    public void menuAboutToHide(final IMenuManager iMenuManager) {
        new UIJob("quickMenuCleanup"){

            @Override
            public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                IMenuService iMenuService = (IMenuService)PlatformUI.getWorkbench().getService(IMenuService.class);
                iMenuService.releaseContributions((ContributionManager)iMenuManager);
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void menuAboutToShow(IMenuManager iMenuManager) {
    }
}

