/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.misc.StatusUtil;

public class OpenInNewWindowHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        IWorkbenchWindow iWorkbenchWindow = HandlerUtil.getActiveWorkbenchWindow(executionEvent);
        if (iWorkbenchWindow == null) {
            return null;
        }
        try {
            String string = null;
            IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
            IAdaptable iAdaptable = ((Workbench)iWorkbenchWindow.getWorkbench()).getDefaultPageInput();
            if (iWorkbenchPage != null && iWorkbenchPage.getPerspective() != null) {
                string = iWorkbenchPage.getPerspective().getId();
                iAdaptable = iWorkbenchPage.getInput();
            } else {
                string = iWorkbenchWindow.getWorkbench().getPerspectiveRegistry().getDefaultPerspective();
            }
            iWorkbenchWindow.getWorkbench().openWorkbenchWindow(string, iAdaptable);
        }
        catch (WorkbenchException workbenchException) {
            StatusUtil.handleStatus(workbenchException.getStatus(), String.valueOf(WorkbenchMessages.OpenInNewWindowAction_errorTitle) + ": " + workbenchException.getMessage(), 2);
        }
        return null;
    }
}

