/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPersistableEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.dialogs.DialogUtil;

public class NewEditorHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        IWorkbenchWindow iWorkbenchWindow = HandlerUtil.getActiveWorkbenchWindow(executionEvent);
        IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
        if (iWorkbenchPage == null) {
            return null;
        }
        IEditorPart iEditorPart = iWorkbenchPage.getActiveEditor();
        if (iEditorPart == null) {
            return null;
        }
        String string = iEditorPart.getSite().getId();
        if (string == null) {
            return null;
        }
        try {
            if (iEditorPart instanceof IPersistableEditor) {
                XMLMemento xMLMemento = XMLMemento.createWriteRoot("editorState");
                ((IPersistableEditor)((Object)iEditorPart)).saveState(xMLMemento);
                ((WorkbenchPage)iWorkbenchPage).openEditor(iEditorPart.getEditorInput(), string, true, 0, xMLMemento);
            } else {
                iWorkbenchPage.openEditor(iEditorPart.getEditorInput(), string, true, 0);
            }
        }
        catch (PartInitException partInitException) {
            DialogUtil.openError(iWorkbenchWindow.getShell(), WorkbenchMessages.Error, partInitException.getMessage(), partInitException);
        }
        return null;
    }
}

