/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.commands.util.Tracing;
import org.eclipse.ui.commands.ExecutionException;
import org.eclipse.ui.commands.IHandler;
import org.eclipse.ui.internal.handlers.LegacyHandlerListenerWrapper;
import org.eclipse.ui.internal.misc.Policy;

public final class LegacyHandlerWrapper
implements org.eclipse.core.commands.IHandler {
    private static final boolean DEBUG_HANDLERS = Policy.DEBUG_HANDLERS && Policy.DEBUG_HANDLERS_VERBOSE;
    private final IHandler handler;

    public LegacyHandlerWrapper(IHandler iHandler) {
        if (iHandler == null) {
            throw new NullPointerException("A handler wrapper cannot be constructed on a null handler");
        }
        this.handler = iHandler;
    }

    public final void addHandlerListener(IHandlerListener iHandlerListener) {
        this.handler.addHandlerListener(new LegacyHandlerListenerWrapper(this, iHandlerListener));
    }

    public final void dispose() {
        this.handler.dispose();
    }

    public final boolean equals(Object object) {
        if (object instanceof IHandler) {
            return this.handler == object;
        }
        if (object instanceof LegacyHandlerWrapper) {
            return this.handler == ((LegacyHandlerWrapper)object).handler;
        }
        return false;
    }

    public final Object execute(ExecutionEvent executionEvent) throws org.eclipse.core.commands.ExecutionException {
        if (DEBUG_HANDLERS) {
            StringBuffer stringBuffer = new StringBuffer("Executing LegacyHandlerWrapper for ");
            if (this.handler == null) {
                stringBuffer.append("no handler");
            } else {
                stringBuffer.append('\'');
                stringBuffer.append(this.handler.getClass().getName());
                stringBuffer.append('\'');
            }
            Tracing.printTrace((String)"HANDLERS", (String)stringBuffer.toString());
        }
        try {
            return this.handler.execute(executionEvent.getParameters());
        }
        catch (ExecutionException executionException) {
            throw new org.eclipse.core.commands.ExecutionException(executionException.getMessage(), executionException.getCause());
        }
    }

    public final int hashCode() {
        return this.handler.hashCode();
    }

    public final boolean isEnabled() {
        Object v = this.handler.getAttributeValuesByName().get("enabled");
        if (v instanceof Boolean) {
            return (Boolean)v;
        }
        return true;
    }

    public final boolean isHandled() {
        Object v = this.handler.getAttributeValuesByName().get("handled");
        if (v instanceof Boolean) {
            return (Boolean)v;
        }
        return true;
    }

    public final void removeHandlerListener(IHandlerListener iHandlerListener) {
        this.handler.removeHandlerListener(new LegacyHandlerListenerWrapper(this, iHandlerListener));
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("LegacyHandlerWrapper(");
        stringBuffer.append(this.handler);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

