/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.handlers;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandler2;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISourceProvider;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.handlers.HandlerActivation;
import org.eclipse.ui.internal.handlers.HandlerAuthority;
import org.eclipse.ui.internal.handlers.HandlerPersistence;
import org.eclipse.ui.internal.misc.Policy;
import org.eclipse.ui.services.IEvaluationService;
import org.eclipse.ui.services.IServiceLocator;

public final class HandlerService
implements IHandlerService {
    private final ICommandService commandService;
    private final HandlerAuthority handlerAuthority;
    private final HandlerPersistence handlerPersistence;

    static {
        Command.DEBUG_HANDLERS = Policy.DEBUG_HANDLERS_VERBOSE;
        Command.DEBUG_HANDLERS_COMMAND_ID = Policy.DEBUG_HANDLERS_VERBOSE_COMMAND_ID;
    }

    public HandlerService(ICommandService iCommandService, IEvaluationService iEvaluationService, IServiceLocator iServiceLocator) {
        if (iCommandService == null) {
            throw new NullPointerException("A handler service requires a command service");
        }
        this.commandService = iCommandService;
        this.handlerAuthority = new HandlerAuthority(iCommandService, iServiceLocator);
        this.handlerPersistence = new HandlerPersistence(this, iEvaluationService);
    }

    @Override
    public final IHandlerActivation activateHandler(IHandlerActivation iHandlerActivation) {
        String string = iHandlerActivation.getCommandId();
        IHandler iHandler = iHandlerActivation.getHandler();
        Expression expression = iHandlerActivation.getExpression();
        int n = iHandlerActivation.getDepth() + 1;
        HandlerActivation handlerActivation = new HandlerActivation(string, iHandler, expression, n, this);
        this.handlerAuthority.activateHandler(handlerActivation);
        return handlerActivation;
    }

    @Override
    public final IHandlerActivation activateHandler(String string, IHandler iHandler) {
        return this.activateHandler(string, iHandler, null);
    }

    @Override
    public final IHandlerActivation activateHandler(String string, IHandler iHandler, Expression expression) {
        return this.activateHandler(string, iHandler, expression, false);
    }

    @Override
    public final IHandlerActivation activateHandler(String string, IHandler iHandler, Expression expression, boolean bl) {
        HandlerActivation handlerActivation = new HandlerActivation(string, iHandler, expression, 1, this);
        this.handlerAuthority.activateHandler(handlerActivation);
        return handlerActivation;
    }

    @Override
    public final IHandlerActivation activateHandler(String string, IHandler iHandler, Expression expression, int n) {
        return this.activateHandler(string, iHandler, expression);
    }

    @Override
    public final void addSourceProvider(ISourceProvider iSourceProvider) {
    }

    @Override
    public final ExecutionEvent createExecutionEvent(Command command, Event event) {
        return new ExecutionEvent(command, Collections.EMPTY_MAP, (Object)event, (Object)this.getCurrentState());
    }

    @Override
    public ExecutionEvent createExecutionEvent(ParameterizedCommand parameterizedCommand, Event event) {
        return new ExecutionEvent(parameterizedCommand.getCommand(), parameterizedCommand.getParameterMap(), (Object)event, (Object)this.getCurrentState());
    }

    @Override
    public final void deactivateHandler(IHandlerActivation iHandlerActivation) {
        if (iHandlerActivation.getHandlerService() == this) {
            this.handlerAuthority.deactivateHandler(iHandlerActivation);
        }
    }

    @Override
    public final void deactivateHandlers(Collection collection) {
        for (IHandlerActivation iHandlerActivation : collection) {
            this.deactivateHandler(iHandlerActivation);
        }
    }

    @Override
    public final void dispose() {
        this.handlerAuthority.dispose();
        this.handlerPersistence.dispose();
    }

    @Override
    public final Object executeCommand(ParameterizedCommand parameterizedCommand, Event event) throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
        return parameterizedCommand.executeWithChecks((Object)event, (Object)this.getCurrentState());
    }

    @Override
    public final Object executeCommand(String string, Event event) throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
        Command command = this.commandService.getCommand(string);
        ExecutionEvent executionEvent = new ExecutionEvent(command, Collections.EMPTY_MAP, (Object)event, (Object)this.getCurrentState());
        return command.executeWithChecks(executionEvent);
    }

    @Override
    public final IEvaluationContext getCurrentState() {
        return this.handlerAuthority.getCurrentState();
    }

    @Override
    public final void readRegistry() {
        this.handlerPersistence.read();
    }

    @Override
    public final void removeSourceProvider(ISourceProvider iSourceProvider) {
    }

    @Override
    public final void setHelpContextId(IHandler iHandler, String string) {
        this.commandService.setHelpContextId(iHandler, string);
    }

    public final void updateShellKludge() {
        this.handlerAuthority.updateShellKludge();
    }

    public final void updateShellKludge(Shell shell) {
        this.handlerAuthority.updateShellKludge(shell);
    }

    public final IHandler findHandler(String string, IEvaluationContext iEvaluationContext) {
        return this.handlerAuthority.findHandler(string, iEvaluationContext);
    }

    @Override
    public IEvaluationContext createContextSnapshot(boolean bl) {
        return this.handlerAuthority.createContextSnapshot(bl);
    }

    @Override
    public final Object executeCommandInContext(ParameterizedCommand parameterizedCommand, Event event, IEvaluationContext iEvaluationContext) throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
        IHandler iHandler = parameterizedCommand.getCommand().getHandler();
        IHandler iHandler2 = this.findHandler(parameterizedCommand.getId(), iEvaluationContext);
        if (iHandler2 instanceof IHandler2) {
            ((IHandler2)iHandler2).setEnabled((Object)iEvaluationContext);
        }
        try {
            parameterizedCommand.getCommand().setHandler(iHandler2);
            Object object = parameterizedCommand.executeWithChecks((Object)event, (Object)iEvaluationContext);
            return object;
        }
        finally {
            parameterizedCommand.getCommand().setHandler(iHandler);
            if (iHandler2 instanceof IHandler2) {
                ((IHandler2)iHandler2).setEnabled((Object)this.getCurrentState());
            }
        }
    }

    public HandlerPersistence getHandlerPersistence() {
        return this.handlerPersistence;
    }
}

